/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.exc.BedeworkUnimplementedException;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.DirConfigProperties;
import org.bedework.calfacade.configs.LdapConfigProperties;
import org.bedework.calsvc.directory.AbstractDirImpl;

public class UserGroupsLdapImpl
extends AbstractDirImpl {
    @Override
    public boolean validPrincipal(String href) {
        if (href == null) {
            return false;
        }
        if (this.lookupValidPrincipal(href)) {
            return true;
        }
        boolean valid = !href.startsWith("invalid");
        try {
            new URI(href);
        }
        catch (Throwable t) {
            valid = false;
        }
        if (valid) {
            this.addValidPrincipal(href);
        }
        return valid;
    }

    public Collection<BwGroup<?>> getGroups(BwPrincipal<?> val) {
        return this.getGroups(this.getProps(), val);
    }

    public Collection<BwGroup<?>> getAllGroups(BwPrincipal<?> val) {
        Collection<BwGroup<?>> groups = this.getGroups(this.getProps(), val);
        TreeSet allGroups = new TreeSet(groups);
        for (BwGroup<?> grp : groups) {
            Collection<BwGroup<?>> gg = this.getAllGroups((BwPrincipal<?>)grp);
            if (gg.isEmpty()) continue;
            allGroups.addAll(gg);
        }
        return allGroups;
    }

    public boolean getGroupMaintOK() {
        return false;
    }

    public Collection<BwGroup<?>> getAll(boolean populate) {
        Collection<BwGroup<?>> gs = this.getGroups(this.getProps(), null);
        if (!populate) {
            return gs;
        }
        for (BwGroup<?> g : gs) {
            this.getMembers(g);
        }
        return gs;
    }

    public void getMembers(BwGroup<?> group) {
        this.getGroupMembers(this.getProps(), group);
    }

    public void addGroup(BwGroup<?> group) {
        if (this.findGroup(group.getAccount()) != null) {
            throw new BedeworkException("org.bedework.exception.duplicateadmingroup");
        }
        throw new BedeworkUnimplementedException();
    }

    public BwGroup<?> findGroup(String name) {
        return this.findGroup(this.getProps(), name);
    }

    public void addMember(BwGroup<?> group, BwPrincipal<?> val) {
        BwGroup<?> ag = this.findGroup(group.getAccount());
        if (ag == null) {
            throw new BedeworkException("Group " + group + " does not exist");
        }
        if (!this.checkPathForSelf(group, val)) {
            throw new BedeworkException("org.bedework.exception.alreadyonagrouppath");
        }
        throw new BedeworkUnimplementedException();
    }

    public void removeMember(BwGroup<?> group, BwPrincipal<?> val) {
        BwGroup<?> ag = this.findGroup(group.getAccount());
        if (ag == null) {
            throw new BedeworkException("Group " + group + " does not exist");
        }
        throw new BedeworkUnimplementedException();
    }

    public void removeGroup(BwGroup<?> group) {
        throw new BedeworkUnimplementedException();
    }

    public void updateGroup(BwGroup<?> group) {
        throw new BedeworkUnimplementedException();
    }

    public Collection<BwGroup<?>> findGroupParents(BwGroup<?> group) {
        throw new BedeworkUnimplementedException();
    }

    public String getConfigName() {
        return "user-ldap-group";
    }

    private boolean checkPathForSelf(BwGroup<?> group, BwPrincipal<?> val) {
        if (group.equals(val)) {
            return false;
        }
        throw new BedeworkUnimplementedException();
    }

    private InitialLdapContext createLdapInitContext(LdapConfigProperties props) {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", props.getInitialContextFactory());
        env.setProperty("java.naming.security.authentication", props.getSecurityAuthentication());
        env.setProperty("java.naming.security.protocol", props.getSecurityProtocol());
        env.setProperty("java.naming.provider.url", props.getProviderUrl());
        String protocol = env.getProperty("java.naming.security.protocol");
        Object providerURL = env.getProperty("java.naming.provider.url");
        if (providerURL == null) {
            providerURL = "ldap://localhost:" + (protocol != null && protocol.equals("ssl") ? "389" : "636");
            env.setProperty("java.naming.provider.url", (String)providerURL);
        }
        if (props.getAuthDn() != null) {
            env.setProperty("java.naming.security.principal", props.getAuthDn());
            env.put("java.naming.security.credentials", props.getAuthPw());
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(env, null);
            if (this.debug()) {
                this.debug("Logged into LDAP server, " + ctx);
            }
            return ctx;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new BedeworkException(t);
        }
    }

    private BwGroup<?> findGroup(DirConfigProperties dirProps, String groupName) {
        LdapConfigProperties props = (LdapConfigProperties)dirProps;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLdapInitContext(props);
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(props.getGroupIdAttr(), groupName);
            String[] idAttr = new String[]{props.getGroupIdAttr()};
            BwGroup group = null;
            NamingEnumeration<SearchResult> response = ctx.search(props.getGroupContextDn(), (Attributes)matchAttrs, idAttr);
            while (response.hasMore()) {
                if (group != null) {
                    throw new BedeworkException("org.bedework.ldap.groups.multiple.result");
                }
                group = new BwGroup();
                group.setAccount(groupName);
                group.setPrincipalRef(this.makePrincipalUri(groupName, 2));
            }
            BwGroup bwGroup = group;
            return bwGroup;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new RuntimeException(t);
        }
        finally {
            if (ctx != null) {
                this.closeContext(ctx);
            }
        }
    }

    private Collection<BwGroup<?>> getGroups(DirConfigProperties dirProps, BwPrincipal<?> principal) {
        ArrayList groups = new ArrayList();
        LdapConfigProperties props = (LdapConfigProperties)dirProps;
        if (props.getGroupMemberAttr() == null) {
            if (this.debug()) {
                this.debug("No group member attribute set - assuming no groups");
            }
            return groups;
        }
        InitialLdapContext ctx = null;
        String member = null;
        if (principal != null) {
            if (principal.getKind() == 1) {
                member = this.getUserEntryValue(props, principal);
            } else if (principal.getKind() == 2) {
                member = this.getGroupEntryValue(props, principal);
            }
        }
        try {
            try {
                ctx = this.createLdapInitContext(props);
            }
            catch (Throwable t) {
                this.warn("*******************************************");
                this.warn("No group information available");
                this.error(t);
                ArrayList arrayList = groups;
                if (ctx != null) {
                    this.closeContext(ctx);
                }
                return arrayList;
            }
            BasicAttributes matchAttrs = new BasicAttributes(true);
            if (member != null) {
                matchAttrs.put(props.getGroupMemberAttr(), member);
            }
            String[] idAttr = new String[]{props.getGroupIdAttr()};
            NamingEnumeration<SearchResult> response = ctx.search(props.getGroupContextDn(), (Attributes)matchAttrs, idAttr);
            while (response.hasMore()) {
                SearchResult sr = response.next();
                Attributes attrs = sr.getAttributes();
                Attribute nmAttr = attrs.get(props.getGroupIdAttr());
                if (nmAttr.size() != 1) {
                    throw new BedeworkException("org.bedework.ldap.groups.multiple.result");
                }
                BwGroup group = new BwGroup();
                group.setAccount(nmAttr.get(0).toString());
                group.setPrincipalRef(this.makePrincipalUri(group.getAccount(), 2));
                groups.add(group);
            }
            ArrayList arrayList = groups;
            return arrayList;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new BedeworkException(t);
        }
        finally {
            if (ctx != null) {
                this.closeContext(ctx);
            }
        }
    }

    private void getGroupMembers(DirConfigProperties dirProps, BwGroup<?> group) {
        LdapConfigProperties props = (LdapConfigProperties)dirProps;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createLdapInitContext(props);
            BasicAttributes matchAttrs = new BasicAttributes(true);
            matchAttrs.put(props.getGroupIdAttr(), group.getAccount());
            String[] memberAttr = new String[]{props.getGroupMemberAttr()};
            ArrayList<String> mbrs = new ArrayList<String>();
            boolean beenHere = false;
            NamingEnumeration<SearchResult> response = ctx.search(props.getGroupContextDn(), (Attributes)matchAttrs, memberAttr);
            while (response.hasMore()) {
                SearchResult sr = response.next();
                Attributes attrs = sr.getAttributes();
                if (beenHere) {
                    throw new BedeworkException("org.bedework.ldap.groups.multiple.result");
                }
                beenHere = true;
                Attribute membersAttr = attrs.get(props.getGroupMemberAttr());
                for (int m = 0; m < membersAttr.size(); ++m) {
                    mbrs.add(membersAttr.get(m).toString());
                }
            }
            String memberContextAttr = props.getGroupMemberContextDn();
            String memberSearchAttr = props.getGroupMemberSearchAttr();
            String groupMemberUserIdAttr = props.getGroupMemberUserIdAttr();
            String groupMemberGroupIdAttr = props.getGroupMemberGroupIdAttr();
            if (!(this.checkNotNull("memberContextAttr", props.getGroupMemberContextDn()) && this.checkNotNull("memberSearchAttr", props.getGroupMemberSearchAttr()) && this.checkNotNull("groupMemberUserIdAttr", props.getGroupMemberUserIdAttr()) && this.checkNotNull("groupMemberGroupIdAttr", props.getGroupMemberGroupIdAttr()))) {
                throw new BedeworkException("Group search not configured");
            }
            String[] idAttr = new String[]{groupMemberUserIdAttr, groupMemberGroupIdAttr, "objectclass"};
            for (String mbr : mbrs) {
                Attribute attr;
                BwPrincipal p;
                String oc;
                matchAttrs = new BasicAttributes(true);
                matchAttrs.put(memberSearchAttr, mbr);
                response = ctx.search(memberContextAttr, (Attributes)matchAttrs, idAttr);
                if (!response.hasMore()) continue;
                SearchResult sr = response.next();
                Attributes attrs = sr.getAttributes();
                Attribute ocsAttr = attrs.get("objectclass");
                String userOc = props.getUserObjectClass();
                String groupOc = props.getGroupObjectClass();
                boolean isGroup = false;
                for (int oci = 0; oci < ocsAttr.size() && !userOc.equals(oc = ocsAttr.get(oci).toString()); ++oci) {
                    if (!groupOc.equals(oc)) continue;
                    isGroup = true;
                    break;
                }
                if (isGroup) {
                    p = BwPrincipal.makeGroupPrincipal();
                    attr = attrs.get(props.getGroupMemberGroupIdAttr());
                } else {
                    p = BwPrincipal.makeUserPrincipal();
                    attr = attrs.get(props.getGroupMemberUserIdAttr());
                }
                if (attr.size() != 1) {
                    throw new BedeworkException("org.bedework.ldap.groups.multiple.result");
                }
                p.setAccount(attr.get(0).toString());
                p.setPrincipalRef(this.makePrincipalUri(p.getAccount(), p.getKind()));
                group.addGroupMember(p);
            }
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new BedeworkException(t);
        }
        finally {
            if (ctx != null) {
                this.closeContext(ctx);
            }
        }
        for (BwGroup g : group.getGroups()) {
            this.getGroupMembers((DirConfigProperties)props, g);
        }
    }

    private boolean checkNotNull(String name, String val) {
        if (val == null) {
            this.warn("null value for property '" + name + "'");
            return false;
        }
        return true;
    }

    private String getUserEntryValue(LdapConfigProperties props, BwPrincipal<?> p) {
        return this.makeUserDn(props, p);
    }

    private String getGroupEntryValue(LdapConfigProperties props, BwPrincipal<?> p) {
        return this.makeGroupDn(props, p);
    }

    private String makeUserDn(LdapConfigProperties props, BwPrincipal<?> p) {
        return props.getUserDnPrefix() + p.getAccount() + props.getUserDnSuffix();
    }

    private String makeGroupDn(LdapConfigProperties props, BwPrincipal<?> p) {
        return props.getGroupDnPrefix() + p.getAccount() + props.getGroupDnSuffix();
    }

    private void closeContext(InitialLdapContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

