/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.util.Collection;
import java.util.TreeSet;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.exc.BedeworkUnimplementedException;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.DirectoryInfo;
import org.bedework.calfacade.svc.AdminGroups;
import org.bedework.calsvc.directory.AbstractDirImpl;
import org.bedework.util.misc.Util;

public class AdminGroupsDbImpl
extends AbstractDirImpl
implements AdminGroups {
    private static DirectoryInfo dirInfo;

    public String getConfigName() {
        return "dir-config";
    }

    public BwPrincipal getPrincipal(String href) {
        if (dirInfo == null) {
            dirInfo = this.getDirectoryInfo();
        }
        if (href == null) {
            return null;
        }
        if (!href.startsWith(dirInfo.getBwadmingroupPrincipalRoot())) {
            return super.getPrincipal(href);
        }
        String account = Util.buildPath((boolean)false, (String[])new String[]{href.substring(dirInfo.getBwadmingroupPrincipalRoot().length())});
        return this.findGroup(account);
    }

    @Override
    public boolean validPrincipal(String account) {
        return true;
    }

    public BwPrincipalInfo getDirInfo(BwPrincipal p) {
        return null;
    }

    public Collection<BwGroup> getGroups(BwPrincipal val) {
        return new TreeSet<BwGroup>(this.cb.getGroups(val, true));
    }

    public Collection<BwGroup> getAllGroups(BwPrincipal val) {
        Collection<BwGroup> groups = this.getGroups(val);
        TreeSet<BwGroup> allGroups = new TreeSet<BwGroup>(groups);
        for (BwGroup adgrp : groups) {
            Collection<BwGroup> gg = this.getAllGroups((BwPrincipal)adgrp);
            if (gg.isEmpty()) continue;
            allGroups.addAll(gg);
        }
        return allGroups;
    }

    public boolean getGroupMaintOK() {
        return true;
    }

    public Collection<BwGroup<?>> getAll(boolean populate) {
        Collection gs = this.cb.getAll(true);
        if (!populate) {
            return gs;
        }
        for (BwGroup grp : gs) {
            this.getMembers(grp);
        }
        return gs;
    }

    public void getMembers(BwGroup<?> group) {
        group.setGroupMembers(this.cb.getMembers(group, true));
    }

    @Override
    public String getAdminGroupsIdPrefix() {
        return "agrp_";
    }

    public void addGroup(BwGroup<?> group) {
        if (this.findGroup(group.getAccount()) != null) {
            throw new BedeworkException("org.bedework.exception.duplicateadmingroup");
        }
        this.cb.addGroup(group, true);
    }

    public BwGroup<?> findGroup(String name) {
        return this.cb.findGroup(name, true);
    }

    public void addMember(BwGroup<?> group, BwPrincipal<?> val) {
        BwGroup<?> ag = this.findGroup(group.getAccount());
        if (ag == null) {
            throw new BedeworkException("org.bedework.exception.groupnotfound", group.getAccount());
        }
        if (!this.checkPathForSelf(group, val)) {
            throw new BedeworkException("org.bedework.exception.alreadyonagrouppath");
        }
        ag.addGroupMember(val);
        this.cb.addMember(ag, val, true);
    }

    public void removeMember(BwGroup<?> group, BwPrincipal<?> val) {
        BwGroup<?> ag = this.findGroup(group.getAccount());
        if (ag == null) {
            throw new BedeworkException("org.bedework.exception.groupnotfound", group.getAccount());
        }
        ag.removeGroupMember(val);
        this.cb.removeMember(group, val, true);
    }

    public void removeGroup(BwGroup<?> group) {
        this.cb.removeGroup(group, true);
    }

    public void updateGroup(BwGroup<?> group) {
        this.cb.updateGroup(group, true);
    }

    public Collection<BwGroup<?>> findGroupParents(BwGroup<?> group) {
        return this.cb.findGroupParents(group, true);
    }

    @Override
    public Collection<String> getGroups(String rootUrl, String principalUrl) {
        throw new BedeworkUnimplementedException();
    }

    private boolean checkPathForSelf(BwGroup<?> group, BwPrincipal<?> val) {
        if (group.equals(val)) {
            return false;
        }
        for (BwGroup<?> g : this.findGroupParents(group)) {
            if (this.checkPathForSelf(g, val)) continue;
            return false;
        }
        return true;
    }
}

