/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import net.fortuna.ical4j.model.parameter.CuType;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.CurrentAccess;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.exc.BedeworkForbidden;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.Response;
import org.bedework.calcorei.CoreCalendarsI;
import org.bedework.calcorei.CoreEventInfo;
import org.bedework.calcorei.CoreEventsI;
import org.bedework.caldav.util.filter.BooleanFilter;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwAlarm;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventAnnotation;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwParticipant;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.EventListEntry;
import org.bedework.calfacade.Participant;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.calfacade.SchedulingOwner;
import org.bedework.calfacade.base.CategorisedEntity;
import org.bedework.calfacade.base.ShareableEntity;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.filter.RetrieveList;
import org.bedework.calfacade.filter.SfpTokenizer;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.requests.GetInstancesRequest;
import org.bedework.calfacade.responses.InstancesResponse;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.EnsureEntityExistsResult;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.RealiasResult;
import org.bedework.calfacade.util.ChangeTable;
import org.bedework.calfacade.util.ChangeTableEntry;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Preferences;
import org.bedework.calsvc.scheduling.SchedulingIntf;
import org.bedework.calsvci.Categories;
import org.bedework.calsvci.EventsI;
import org.bedework.convert.IcalTranslator;
import org.bedework.convert.Icalendar;
import org.bedework.convert.RecurUtil;
import org.bedework.sysevents.events.EntityFetchEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.calendar.PropertyIndex;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.tagdefs.CaldavTags;
import org.bedework.util.xml.tagdefs.NamespaceAbbrevs;

class Events
extends CalSvcDb
implements EventsI {
    private static final String ValidateAlarmPrefix = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:bedework-validate\nBEGIN:VEVENT\nDTSTART:20101231T230000\nDTEND:20110101T010000\nSUMMARY:Just checking\nUID:1234\nDTSTAMP:20101125T112600\n";
    private static final String ValidateAlarmSuffix = "END:VEVENT\nEND:VCALENDAR\n";

    Events(CalSvc svci) {
        super(svci);
    }

    public Collection<EventInfo> getByUid(String colPath, String guid, String recurrenceId, RecurringRetrievalMode recurRetrieval) {
        Set<EventInfo> res = this.postProcess(this.getCal().getEvent(colPath, guid));
        int num = res.size();
        if (num == 0) {
            return res;
        }
        this.getSvc().postNotification((SysEventBase)new EntityFetchEvent(SysEventBase.SysCode.ENTITY_FETCHED, num));
        if (recurrenceId == null && (recurRetrieval == null || recurRetrieval.mode != RecurringRetrievalMode.Rmode.expanded)) {
            return res;
        }
        if (recurrenceId == null) {
            return this.processExpanded(res, recurRetrieval);
        }
        if (num > 1) {
            throw new RuntimeException("cannot return rid for multiple events");
        }
        ArrayList<EventInfo> eis = new ArrayList<EventInfo>();
        eis.add(this.makeInstance((EventInfo)res.iterator().next(), recurrenceId));
        return eis;
    }

    private Collection<EventInfo> processExpanded(Collection<EventInfo> events, RecurringRetrievalMode recurRetrieval) {
        ArrayList<EventInfo> res = new ArrayList<EventInfo>();
        for (EventInfo ei : events) {
            BwEvent ev = ei.getEvent();
            if (!ev.getRecurring().booleanValue()) {
                res.add(ei);
                continue;
            }
            CurrentAccess ca = ei.getCurrentAccess();
            AuthProperties authPars = this.getSvc().getAuthProperties();
            Collection instances = RecurUtil.getRecurrences((EventInfo)ei, (int)authPars.getMaxYears(), (int)authPars.getMaxInstances(), (String)recurRetrieval.getStartDate(), (String)recurRetrieval.getEndDate());
            if (instances.isEmpty()) {
                return res;
            }
            for (RecurUtil.Recurrence instance : instances) {
                EventInfo oei = instance.override != null ? instance.override : EventInfo.makeProxy((BwEvent)ev, (BwDateTime)instance.start, (BwDateTime)instance.end, (String)instance.recurrenceId, (boolean)true);
                oei.setCurrentAccess(ca);
                oei.setRetrievedEvent(ei);
                res.add(oei);
            }
        }
        return res;
    }

    private EventInfo makeInstance(EventInfo ei, String recurrenceId) {
        BwEvent ev = ei.getEvent();
        if (!ev.getRecurring().booleanValue()) {
            return ei;
        }
        RecurUtil.Recurrence instance = this.findInstance(ei, recurrenceId);
        if (instance == null) {
            return null;
        }
        EventInfo oei = instance.override != null ? instance.override : EventInfo.makeProxy((BwEvent)ev, (BwDateTime)instance.start, (BwDateTime)instance.end, (String)recurrenceId, (boolean)true);
        oei.setCurrentAccess(ei.getCurrentAccess());
        oei.setRetrievedEvent(ei);
        return oei;
    }

    private RecurUtil.Recurrence findInstance(EventInfo ei, String rid) {
        int maxInstances;
        AuthProperties props = this.getSvc().getAuthProperties();
        int maxYears = props.getMaxYears();
        Collection instances = RecurUtil.getRecurrences((EventInfo)ei, (int)maxYears, (int)(maxInstances = props.getMaxInstances().intValue()), null, null);
        if (instances.isEmpty()) {
            return null;
        }
        for (RecurUtil.Recurrence rec : instances) {
            if (!rid.equals(rec.recurrenceId)) continue;
            return rec;
        }
        return null;
    }

    public EventInfo get(String colPath, String name) {
        return this.get(colPath, name, null);
    }

    public EventInfo get(String colPath, String name, String recurrenceId) {
        Object href = Util.buildPath((boolean)false, (String[])new String[]{colPath, "/", name});
        if (recurrenceId != null) {
            href = (String)href + "#" + recurrenceId;
        }
        EventInfo res = this.postProcess(this.getCal().getEvent((String)href));
        int num = 0;
        if (res != null) {
            num = 1;
        }
        this.getSvc().postNotification((SysEventBase)new EntityFetchEvent(SysEventBase.SysCode.ENTITY_FETCHED, num));
        return res;
    }

    public EventInfo get(BwCalendar col, String name, String recurrenceId, List<String> retrieveList) {
        String path;
        block7: {
            if (col == null || name == null) {
                throw new RuntimeException("org.bedework.exception.badrequest");
            }
            if (col.getInternalAlias()) {
                String expr = "(vpath='" + SfpTokenizer.escapeQuotes((String)col.getPath()) + "') and (name='" + SfpTokenizer.escapeQuotes((String)name) + "')";
                SimpleFilterParser sfp = this.getSvc().getFilterParser();
                SimpleFilterParser.ParseResult pr = sfp.parse(expr, true, null);
                if (!pr.ok) {
                    throw new RuntimeException("Failed to parse " + expr + ": message was " + pr.message);
                }
                Collection<EventInfo> evs = this.getEvents(null, pr.filter, null, null, RetrieveList.getRetrieveList(retrieveList), BwIndexer.DeletedState.noDeleted, RecurringRetrievalMode.overrides);
                if (evs.isEmpty()) {
                    return null;
                }
                if (evs.size() == 1) {
                    return evs.iterator().next();
                }
                throw new RuntimeException("Multiple results");
            }
            path = col.getPath();
            if (col.getCalType() == 11) {
                SortedSet eles = col.getEventList();
                for (EventListEntry ele : eles) {
                    if (!ele.getName().equals(name)) continue;
                    path = ele.getPath();
                    break block7;
                }
                return null;
            }
        }
        return this.get(path, name, null);
    }

    public Collection<EventInfo> getEvents(BwCalendar cal, FilterBase filter, BwDateTime startDate, BwDateTime endDate, List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> retrieveList, BwIndexer.DeletedState delState, RecurringRetrievalMode recurRetrieval) {
        Set<BwCalendar> cals = null;
        if (cal != null) {
            cals = Collections.singleton(cal);
        }
        Collection<EventInfo> res = this.getMatching(cals, filter, startDate, endDate, retrieveList, delState, recurRetrieval, false);
        int num = 0;
        if (res != null) {
            num = res.size();
        }
        this.getSvc().postNotification((SysEventBase)new EntityFetchEvent(SysEventBase.SysCode.ENTITY_FETCHED, num));
        return res;
    }

    public Response delete(EventInfo ei, boolean sendSchedulingMessage) {
        return this.delete(ei, false, sendSchedulingMessage);
    }

    public Response delete(EventInfo ei, boolean scheduling, boolean sendSchedulingMessage) {
        return this.delete(ei, scheduling, sendSchedulingMessage, false);
    }

    public EventInfo.UpdateResult add(EventInfo ei, boolean noInvites, boolean schedulingInbox, boolean autoCreateCollection, boolean rollbackOnError) {
        EventInfo.UpdateResult updResult = ei.getUpdResult();
        try {
            Collection overrides;
            RealiasResult raResp;
            if (this.getSvc().getPrincipalInfo().getSubscriptionsOnly()) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.noAccess, (String)"User has read only access");
            }
            updResult.adding = true;
            updResult.hasChanged = true;
            BwEvent event = ei.getEvent();
            this.adjustEntities(ei);
            BwPreferences prefs = this.getPrefs();
            if (prefs != null) {
                GetEntitiesResponse resp = this.getSvc().getCategoriesHandler().getByUids((Collection)prefs.getDefaultCategoryUids());
                if (resp.isOk()) {
                    for (BwCategory cat : resp.getEntities()) {
                        event.addCategory(cat);
                    }
                } else {
                    return (EventInfo.UpdateResult)Response.fromResponse((Response)updResult, (Response)resp);
                }
            }
            if (!(raResp = this.reAlias(event)).isOk()) {
                return (EventInfo.UpdateResult)Response.fromResponse((Response)updResult, (Response)raResp);
            }
            event.assignGuid(this.getSvc().getSystemProperties().getSystemid());
            if (!this.updateEntities(updResult, event)) {
                return updResult;
            }
            BwCalendar cal = this.validate(event, true, schedulingInbox, autoCreateCollection);
            if (cal == null) {
                throw new BedeworkException("No calendar for event");
            }
            if (!cal.isSupportedComponent(event.getEntityType())) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.noAccess, (String)"Invalid component type for this collection");
            }
            if (event instanceof BwEventProxy) {
                BwEventProxy proxy = (BwEventProxy)event;
                BwEventAnnotation override = proxy.getRef();
                this.getSvc().setupSharableEntity((ShareableEntity)override, this.getPrincipal().getPrincipalRef());
            } else {
                this.getSvc().setupSharableEntity((ShareableEntity)event, this.getPrincipal().getPrincipalRef());
                if (ei.getNumContainedItems() > 0) {
                    for (EventInfo aei : ei.getContainedItems()) {
                        BwEvent av = aei.getEvent();
                        av.setParent(event);
                        this.getSvc().setupSharableEntity((ShareableEntity)av, this.getPrincipal().getPrincipalRef());
                    }
                }
            }
            BwCalendar undereffedCal = cal;
            if (cal.getInternalAlias()) {
                boolean setCats = this.getSvc().getPars().getPublicAdmin();
                if (!setCats) {
                    cal = this.getCols().resolveAlias(cal, true, false);
                } else {
                    while (true) {
                        Set cats = cal.getCategories();
                        for (BwCategory cat : cats) {
                            event.addCategory(cat);
                        }
                        if (!cal.getInternalAlias()) break;
                        cal = this.getCols().resolveAlias(cal, false, false);
                    }
                }
                event.setColPath(cal.getPath());
            }
            if (!cal.getCalendarCollection()) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.noAccess);
            }
            if (!event.getPublick().booleanValue() && Util.isEmpty((Collection)event.getAlarms())) {
                this.setDefaultAlarms(ei, undereffedCal);
            }
            boolean schedulingObject = false;
            if (cal.getCollectionInfo().scheduling && (event.getOrganizerSchedulingObject().booleanValue() || event.getAttendeeSchedulingObject().booleanValue())) {
                schedulingObject = true;
            }
            Integer maxAttendees = this.getSvc().getAuthProperties().getMaxAttendeesPerInstance();
            SchedulingInfo si = event.getSchedulingInfo();
            Collection atts = si.getRecipientParticipants().values();
            if (maxAttendees != null && !Util.isEmpty(atts) && atts.size() > maxAttendees) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.limitExceeded, (String)"org.bedework.error.scheduling.toomany.attendees");
            }
            Timestamp currentTimestamp = this.getCurrentTimestamp();
            event.setDtstamps(currentTimestamp);
            if (schedulingObject) {
                event.updateStag(currentTimestamp);
            }
            if ((overrides = ei.getOverrideProxies()) != null) {
                for (BwEventProxy ovev : overrides) {
                    this.setScheduleState((BwEvent)ovev, true, schedulingInbox);
                    SchedulingInfo ovParts = ovev.getSchedulingInfo();
                    Collection ovAtts = ovParts.getRecipientParticipants().values();
                    if (maxAttendees != null && !Util.isEmpty(ovAtts) && ovAtts.size() > maxAttendees) {
                        return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.limitExceeded, (String)"org.bedework.error.scheduling.toomany.attendees");
                    }
                    ovev.setDtstamps(currentTimestamp);
                    if (cal.getCollectionInfo().scheduling && (ovev.getOrganizerSchedulingObject().booleanValue() || ovev.getAttendeeSchedulingObject().booleanValue())) {
                        schedulingObject = true;
                    }
                    if (ovev.getOrganizerSchedulingObject().booleanValue()) {
                        for (Participant att : ovAtts) {
                            if (!att.getParticipationStatus().equals("NEEDS-ACTION")) continue;
                            att.setExpectReply(true);
                        }
                    }
                    if (schedulingObject) {
                        ovev.updateStag(currentTimestamp);
                    }
                    BwEventAnnotation ann = ovev.getRef();
                    ann.setColPath(event.getColPath());
                    ann.setName(event.getName());
                }
            }
            if (event.getOrganizerSchedulingObject().booleanValue()) {
                for (Object att : atts) {
                    if (!att.getParticipationStatus().equals("NEEDS-ACTION")) continue;
                    att.setExpectReply(true);
                }
            }
            CoreEventsI.UpdateEventResult uer = this.getCal().addEvent(ei, schedulingInbox, rollbackOnError);
            if (uer.errorCode != null) {
                return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.failed, (String)("Status " + uer.errorCode + " from addEvent"));
            }
            if (ei.getNumContainedItems() > 0) {
                for (EventInfo oei : ei.getContainedItems()) {
                    oei.getEvent().setName(event.getName());
                    CoreEventsI.UpdateEventResult auer = this.getCal().addEvent(oei, schedulingInbox, rollbackOnError);
                    if (auer.errorCode == null) continue;
                    return (EventInfo.UpdateResult)Response.notOk((Response)updResult, (Response.Status)Response.Status.failed, (String)("Status " + auer.errorCode + " from addEvent"));
                }
            }
            updResult.failedOverrides = uer.failedOverrides;
            if (!noInvites) {
                if (event.getAttendeeSchedulingObject().booleanValue()) {
                    updResult.reply = true;
                }
                if (cal.getCollectionInfo().scheduling && schedulingObject) {
                    SchedulingIntf sched = (SchedulingIntf)this.getSvc().getScheduler();
                    if (this.debug()) {
                        this.debug("schedule event");
                    }
                    sched.implicitSchedule(ei, false);
                }
            }
            return updResult;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            this.getSvc().rollbackTransaction();
            this.reindex(ei);
            return (EventInfo.UpdateResult)Response.error((Response)updResult, (Throwable)t);
        }
    }

    public void reindex(EventInfo ei) {
        try {
            this.getCal().reindex(ei);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    public EventInfo.UpdateResult update(EventInfo ei, boolean noInvites) {
        return this.update(ei, noInvites, null, false, true, false);
    }

    public EventInfo.UpdateResult update(EventInfo ei, boolean noInvites, String fromAttUri, boolean autoCreateCollection) {
        return this.update(ei, noInvites, fromAttUri, false, false, autoCreateCollection);
    }

    public EventInfo.UpdateResult update(EventInfo ei, boolean noInvites, String fromAttUri, boolean alwaysWrite, boolean clientUpdate, boolean autoCreateCollection) {
        EventInfo.UpdateResult updResult = ei.getUpdResult();
        try {
            boolean sendit;
            ChangeTable ct;
            boolean schedulingObject;
            BwEvent event = ei.getEvent();
            if (!this.updateEntities(updResult, event)) {
                return updResult;
            }
            BwCalendar cal = this.validate(event, false, false, autoCreateCollection);
            if (cal == null) {
                throw new BedeworkException("No calendar for event");
            }
            this.adjustEntities(ei);
            RealiasResult raResp = this.reAlias(event);
            if (!raResp.isOk()) {
                return (EventInfo.UpdateResult)Response.fromResponse((Response)updResult, (Response)raResp);
            }
            boolean organizerSchedulingObject = false;
            boolean attendeeSchedulingObject = false;
            if (cal.getCollectionInfo().scheduling) {
                organizerSchedulingObject = event.getOrganizerSchedulingObject();
                attendeeSchedulingObject = event.getAttendeeSchedulingObject();
            }
            boolean bl = schedulingObject = organizerSchedulingObject || attendeeSchedulingObject;
            if (schedulingObject && clientUpdate && !event.getSignificantChange() && (ct = event.getChangeset(this.getPrincipalHref())) != null) {
                event.setSignificantChange(ct.getSignificantChange());
            }
            if (event.getSignificantChange() && schedulingObject) {
                event.updateStag(this.getCurrentTimestamp());
            }
            boolean changed = alwaysWrite || this.checkChanges(ei, organizerSchedulingObject, attendeeSchedulingObject) || ei.getOverridesChanged();
            boolean sequenceChange = ei.getUpdResult().sequenceChange;
            boolean doReschedule = ei.getUpdResult().doReschedule;
            if (ei.getNumOverrides() > 0) {
                for (Object oei : ei.getOverrides()) {
                    this.setScheduleState(oei.getEvent(), false, false);
                    if (cal.getCollectionInfo().scheduling && oei.getEvent().getAttendeeSchedulingObject().booleanValue()) {
                        schedulingObject = true;
                        attendeeSchedulingObject = true;
                    }
                    if (this.checkChanges((EventInfo)oei, organizerSchedulingObject, attendeeSchedulingObject)) {
                        changed = true;
                        if (oei.getUpdResult().sequenceChange) {
                            sequenceChange = true;
                        }
                    }
                    if (schedulingObject) {
                        oei.getEvent().updateStag(this.getCurrentTimestamp());
                    }
                    doReschedule = doReschedule || oei.getUpdResult().doReschedule;
                }
            }
            if (!changed) {
                if (this.debug()) {
                    this.debug("No changes to event: returning");
                }
                return ei.getUpdResult();
            }
            event.setDtstamps(this.getCurrentTimestamp());
            if (organizerSchedulingObject && sequenceChange) {
                event.setSequence(event.getSequence() + 1);
            }
            CoreEventsI.UpdateEventResult uer = this.getCal().updateEvent(ei);
            updResult.deletedInstances = uer.deleted;
            updResult.fromAttUri = fromAttUri;
            if (noInvites || !schedulingObject || !event.getSignificantChange()) {
                if (this.debug() && !noInvites && schedulingObject) {
                    this.debug("Skipping a scheduling object with insignificant changes?");
                }
                return updResult;
            }
            if (organizerSchedulingObject) {
                for (Object att : event.getSchedulingInfo().getRecipientParticipants().values()) {
                    if (!att.getParticipationStatus().equals("NEEDS-ACTION")) continue;
                    att.setExpectReply(true);
                }
            }
            boolean bl2 = sendit = organizerSchedulingObject || updResult.reply;
            if (!sendit && !Util.isEmpty((Collection)ei.getOverrides())) {
                for (EventInfo oei : ei.getOverrides()) {
                    if (!oei.getUpdResult().reply) continue;
                    sendit = true;
                    break;
                }
            }
            if (sendit) {
                SchedulingIntf sched = (SchedulingIntf)this.getSvc().getScheduler();
                sched.implicitSchedule(ei, false);
            }
            return updResult;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            this.getSvc().rollbackTransaction();
            this.reindex(ei);
            return (EventInfo.UpdateResult)Response.error((Response)updResult, (Throwable)t);
        }
    }

    private boolean checkChanges(EventInfo ei, boolean organizerSchedulingObject, boolean attendeeSchedulingObject) {
        EventInfo.UpdateResult updResult = ei.getUpdResult();
        if (ei.getChangeset(this.getPrincipalHref()).isEmpty()) {
            updResult.hasChanged = true;
            if (attendeeSchedulingObject) {
                updResult.reply = true;
            }
            return true;
        }
        if (this.debug()) {
            ei.getChangeset(this.getPrincipalHref()).dumpEntries();
        }
        ChangeTable ct = ei.getChangeset(this.getPrincipalHref());
        Collection ctes = ct.getEntries();
        updResult.sequenceChange = ct.getSequenceChangeNeeded();
        for (ChangeTableEntry cte : ctes) {
            BwIcalPropertyInfo.BwIcalPropertyInfoEntry pie;
            if (!cte.getChanged()) continue;
            updResult.hasChanged = true;
            PropertyIndex.PropertyInfoIndex pi = cte.getIndex();
            if (!organizerSchedulingObject && pi.equals((Object)PropertyIndex.PropertyInfoIndex.ORGANIZER)) {
                BwOrganizer oldOrg = (BwOrganizer)cte.getOldVal();
                BwOrganizer newOrg = (BwOrganizer)cte.getNewVal();
                if (oldOrg == null || newOrg == null || !oldOrg.getOrganizerUri().equals(newOrg.getOrganizerUri())) {
                    throw new BedeworkForbidden(CaldavTags.attendeeAllowed, "Cannot change organizer");
                }
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.ATTENDEE)) {
                updResult.deletedAttendees = cte.getRemovedValues();
                if (attendeeSchedulingObject) {
                    updResult.reply = true;
                } else if (!Util.isEmpty((Collection)updResult.deletedAttendees)) {
                    updResult.sequenceChange = true;
                }
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.PARTICIPANT)) {
                updResult.deletedParticipants = cte.getRemovedValues();
                if (attendeeSchedulingObject) {
                    updResult.reply = true;
                } else if (!Util.isEmpty((Collection)updResult.deletedParticipants)) {
                    updResult.sequenceChange = true;
                }
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.POLL_WINNER) && !attendeeSchedulingObject) {
                updResult.pollWinner = ei.getEvent().getPollWinner();
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.POLL_ITEM) && attendeeSchedulingObject) {
                updResult.reply = true;
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.VOTE) && attendeeSchedulingObject) {
                updResult.reply = true;
            }
            if (pi.equals((Object)PropertyIndex.PropertyInfoIndex.POLL_VOTE_RESPONSE) && attendeeSchedulingObject) {
                updResult.reply = true;
            }
            if (!organizerSchedulingObject || !(pie = BwIcalPropertyInfo.getPinfo((PropertyIndex.PropertyInfoIndex)cte.getIndex())).getReschedule()) continue;
            updResult.doReschedule = true;
        }
        return updResult.hasChanged;
    }

    public void markDeleted(BwEvent event) {
        BwEventProxy proxy = BwEventProxy.makeAnnotation((BwEvent)event, (String)event.getOwnerHref(), (boolean)false);
        BwCalendar cal = this.getCal().getSpecialCalendar(null, (BwPrincipal)this.getPrincipal(), (int)3, (boolean)true, (int)1).cal;
        proxy.setOwnerHref(this.getPrincipal().getPrincipalRef());
        proxy.setDeleted(true);
        proxy.setColPath(cal.getPath());
        this.add(new EventInfo((BwEvent)proxy), true, false, false, false);
    }

    public Response copyMoveNamed(EventInfo fromEi, BwCalendar to, String name, boolean copy, boolean overwrite, boolean newGuidOK) {
        Response resp = new Response();
        BwEvent ev = fromEi.getEvent();
        String fromPath = ev.getColPath();
        boolean sameCal = fromPath.equals(to.getPath());
        if (name == null) {
            name = ev.getName();
        }
        if (sameCal && name.equals(ev.getName())) {
            return resp;
        }
        try {
            EventInfo destEi = this.get(to.getPath(), name);
            if (destEi != null) {
                if (!overwrite) {
                    return Response.notOk((Response)resp, (Response.Status)Response.Status.forbidden, (String)("destination exists: " + name));
                }
                if (!destEi.getEvent().getUid().equals(ev.getUid())) {
                    return Response.notOk((Response)resp, (Response.Status)Response.Status.forbidden, (String)"Cannot change uid");
                }
            }
            if (!copy) {
                if (!sameCal) {
                    BwCalendar from = this.getCols().get(fromPath);
                    this.getCal().moveEvent(fromEi, from, to);
                    this.getCal().touchCalendar(from);
                } else {
                    ev.setName(name);
                }
                ev.updateStag(this.getCurrentTimestamp());
                this.update(fromEi, false, null, false);
            } else {
                BwEvent newEvent = (BwEvent)ev.clone();
                newEvent.setName(name);
                newEvent.setAccess(null);
                EventInfo newEi = new EventInfo(newEvent);
                if (fromEi.getOverrideProxies() != null) {
                    for (BwEventProxy proxy : fromEi.getOverrideProxies()) {
                        newEi.addOverride(new EventInfo((BwEvent)proxy.clone(newEvent, newEvent)));
                    }
                }
                if (sameCal && newGuidOK) {
                    newEvent.setUid(null);
                    newEvent.assignGuid(this.getSvc().getSystemProperties().getSystemid());
                }
                if (destEi != null) {
                    this.delete(destEi, false);
                }
                newEvent.setColPath(to.getPath());
                newEvent.updateStag(this.getCurrentTimestamp());
                this.add(newEi, true, false, false, true);
            }
            if (destEi != null) {
                return resp;
            }
            resp.setMessage("created");
            return resp;
        }
        catch (BedeworkException be) {
            if (be.getMessage().equals("org.bedework.exception.duplicateguid")) {
                return Response.notOk((Response)resp, (Response.Status)Response.Status.forbidden, (String)"duplicate uid");
            }
            return Response.error((Response)resp, (Throwable)be);
        }
    }

    public void claim(BwEvent ev) {
        ev.setOwnerHref(null);
        ev.setCreatorHref(null);
        this.getSvc().setupSharableEntity((ShareableEntity)ev, this.getPrincipal().getPrincipalRef());
    }

    public RealiasResult reAlias(BwEvent ev) {
        RealiasResult resp = new RealiasResult(new TreeSet());
        List aliases = ev.getXproperties("X-BEDEWORK-ALIAS");
        if (!Util.isEmpty((Collection)aliases)) {
            for (BwXproperty alias : aliases) {
                this.doCats(resp, alias.getValue(), ev);
            }
        }
        this.doCats(resp, ev.getColPath(), ev);
        return resp;
    }

    public InstancesResponse getInstances(GetInstancesRequest req) {
        InstancesResponse resp = new InstancesResponse();
        resp.setId(req.getId());
        if (!req.validate((Response)resp)) {
            return resp;
        }
        BwEventObj ev = new BwEventObj();
        try {
            BwDateTime st = req.getStartDt();
            ev.setDtstart(st);
            ev.setDtend(req.getEndDt());
            ev.addRrule(req.getRrule());
            if (!Util.isEmpty((Collection)req.getExdates())) {
                for (String dt : req.getExdates()) {
                    ev.addExdate(BwDateTime.makeBwDateTime((boolean)st.getDateType(), (String)dt, (String)st.getTzid()));
                }
            }
            if (!Util.isEmpty((Collection)req.getRdates())) {
                for (String dt : req.getRdates()) {
                    ev.addRdate(BwDateTime.makeBwDateTime((boolean)st.getDateType(), (String)dt, (String)st.getTzid()));
                }
            }
            AuthProperties authPars = this.getSvc().getAuthProperties();
            RecurUtil.RecurPeriods rp = RecurUtil.getPeriods((BwEvent)ev, (int)authPars.getMaxYears(), (int)authPars.getMaxInstances(), (String)req.getBegin(), (String)req.getEnd());
            resp.setInstances(rp.instances);
            return resp;
        }
        catch (Throwable t) {
            return (InstancesResponse)Response.error((Response)resp, (Throwable)t);
        }
    }

    private void doCats(RealiasResult resp, String colHref, BwEvent ev) {
        try {
            Set cats = this.getCols().getCategorySet(colHref);
            if (Util.isEmpty((Collection)cats)) {
                return;
            }
            resp.getCats().addAll(cats);
            for (BwCategory cat : cats) {
                if (!ev.addCategory(cat)) continue;
                ChangeTable changes = ev.getChangeset(this.getPrincipalHref());
                ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
                cte.addAddedValue((Object)cat);
            }
        }
        catch (Throwable t) {
            Response.error((Response)new RealiasResult(null), (String)t.getMessage());
        }
    }

    public EventsI.SetEntityCategoriesResult setEntityCategories(CategorisedEntity ent, Set<BwCategory> extraCats, Set<String> defCatUids, Set<String> allDefCatUids, Collection<String> strCatUids, ChangeTable changes) {
        BwCategory entcat;
        EventsI.SetEntityCategoriesResult secr = new EventsI.SetEntityCategoriesResult();
        Set entcats = ent.getCategories();
        HashMap<String, BwCategory> entcatMap = new HashMap<String, BwCategory>();
        if (!Util.isEmpty((Collection)entcats)) {
            for (Object entcat2 : entcats) {
                entcatMap.put(entcat2.getUid(), (BwCategory)entcat2);
            }
        }
        if (Util.isEmpty(strCatUids) && Util.isEmpty(extraCats) && Util.isEmpty(defCatUids) && Util.isEmpty(allDefCatUids)) {
            if (!Util.isEmpty((Collection)entcats)) {
                if (changes != null) {
                    ChangeTableEntry cte = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
                    cte.setRemovedValues(new ArrayList(entcats));
                }
                secr.numRemoved = entcats.size();
                entcats.clear();
            }
            secr.rcode = 0;
            return secr;
        }
        TreeSet<BwCategory> cats = new TreeSet<BwCategory>();
        if (extraCats != null) {
            cats.addAll(extraCats);
        }
        if (!Util.isEmpty(defCatUids)) {
            for (String string : defCatUids) {
                BwCategory cat = (BwCategory)this.getSvc().getCategoriesHandler().getPersistent(string);
                if (cat == null) continue;
                cats.add(cat);
            }
        }
        if (!Util.isEmpty(allDefCatUids) && entcats != null) {
            for (String string : allDefCatUids) {
                entcat = (BwCategory)entcatMap.get(string);
                if (entcat == null) continue;
                cats.add(entcat);
            }
        }
        if (!Util.isEmpty(strCatUids)) {
            for (String string : strCatUids) {
                entcat = (BwCategory)entcatMap.get(string);
                if (entcat != null) {
                    cats.add(entcat);
                    continue;
                }
                BwCategory cat = (BwCategory)this.getSvc().getCategoriesHandler().getPersistent(string);
                if (cat == null) continue;
                cats.add(cat);
            }
        }
        ArrayList<BwCategory> toRemove = new ArrayList<BwCategory>();
        if (entcats != null) {
            for (BwCategory evcat : entcats) {
                if (cats.contains(evcat)) {
                    cats.remove(evcat);
                    continue;
                }
                toRemove.add(evcat);
            }
        }
        for (BwCategory cat : cats) {
            ent.addCategory(cat);
            ++secr.numAdded;
        }
        for (BwCategory cat : toRemove) {
            if (!entcats.remove(cat)) continue;
            ++secr.numRemoved;
        }
        if (changes != null && secr.numAdded > 0 && secr.numRemoved > 0) {
            ChangeTableEntry changeTableEntry = changes.getEntry(PropertyIndex.PropertyInfoIndex.CATEGORIES);
            changeTableEntry.setRemovedValues(toRemove);
            changeTableEntry.setAddedValues(cats);
        }
        secr.rcode = 0;
        return secr;
    }

    boolean updateEntities(EventInfo.UpdateResult updResult, BwEvent event) {
        BwLocation loc;
        BwContact ct;
        Categories cathdlr = this.getSvc().getCategoriesHandler();
        Set cats = event.getCategories();
        TreeSet<BwCategory> removeCats = new TreeSet<BwCategory>();
        TreeSet<BwCategory> addCats = new TreeSet<BwCategory>();
        if (cats != null) {
            for (BwCategory cat : cats) {
                if (!cat.unsaved()) continue;
                EnsureEntityExistsResult eeer = cathdlr.ensureExists((BwEventProperty)cat, event.getOwnerHref());
                removeCats.add(cat);
                if (!eeer.isOk()) {
                    Response.fromResponse((Response)updResult, (Response)eeer);
                    return false;
                }
                addCats.add((BwCategory)eeer.getEntity());
            }
            for (BwCategory cat : removeCats) {
                event.removeCategory(cat);
            }
            for (BwCategory cat : addCats) {
                event.addCategory(cat);
            }
        }
        if ((ct = event.getContact()) != null) {
            EnsureEntityExistsResult eeers = this.getSvc().getContactsHandler().ensureExists((BwEventProperty)ct, ct.getOwnerHref());
            if (!eeers.isOk()) {
                Response.fromResponse((Response)updResult, (Response)eeers);
                return false;
            }
            if (eeers.isAdded()) {
                ++updResult.contactsAdded;
            }
            event.setContact((BwContact)eeers.getEntity());
        }
        if ((loc = event.getLocation()) != null) {
            EnsureEntityExistsResult eeerl = this.getSvc().getLocationsHandler().ensureExists((BwEventProperty)loc, loc.getOwnerHref());
            if (!eeerl.isOk()) {
                Response.fromResponse((Response)updResult, (Response)eeerl);
                return false;
            }
            if (eeerl.isAdded()) {
                ++updResult.locationsAdded;
            }
            event.setLocation((BwLocation)eeerl.getEntity());
        }
        return true;
    }

    Collection<EventInfo> getMatching(Collection<BwCalendar> cals, FilterBase filter, BwDateTime startDate, BwDateTime endDate, List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> retrieveList, BwIndexer.DeletedState delState, RecurringRetrievalMode recurRetrieval, boolean freeBusy) {
        TreeSet<EventInfo> ts = new TreeSet<EventInfo>();
        if (filter != null && filter.equals(BooleanFilter.falseFilter)) {
            return ts;
        }
        ArrayList<BwCalendar> calSet = null;
        if (cals != null) {
            calSet = new ArrayList<BwCalendar>();
            for (BwCalendar cal : cals) {
                this.buildCalendarSet(calSet, cal, freeBusy);
            }
        }
        ts.addAll(this.postProcess(this.getCal().getEvents(calSet, filter, startDate, endDate, retrieveList, delState, recurRetrieval, freeBusy)));
        return ts;
    }

    boolean isVisible(BwCalendar col, String entityName) {
        return this.getSvc().getEventsHandler().get(col, entityName, null, null) != null;
    }

    Set<EventInfo> getSynchEvents(String path, String lastmod) {
        return this.postProcess(this.getCal().getSynchEvents(path, lastmod));
    }

    Response delete(EventInfo ei, boolean scheduling, boolean sendSchedulingMessage, boolean reallyDelete) {
        Response resp = new Response();
        if (ei == null) {
            return Response.invalid((Response)resp, (String)"Null event");
        }
        BwEvent event = ei.getEvent();
        if (!event.getTombstoned().booleanValue()) {
            BwCalendar cal;
            try {
                cal = this.getCols().get(event.getColPath());
            }
            catch (BedeworkException be) {
                return Response.error((Response)resp, (Throwable)be);
            }
            boolean schedulingObject = false;
            boolean organizerSchedulingObject = false;
            this.setScheduleState(event, false, false);
            if (cal.getCollectionInfo().scheduling && (event.getOrganizerSchedulingObject().booleanValue() || event.getAttendeeSchedulingObject().booleanValue())) {
                schedulingObject = true;
                organizerSchedulingObject = event.getOrganizerSchedulingObject();
            }
            if (!schedulingObject && event.isRecurringEntity() && !Util.isEmpty((Collection)ei.getOverrideProxies())) {
                for (BwEventProxy ove : ei.getOverrideProxies()) {
                    this.setScheduleState((BwEvent)ove, false, false);
                    if (!cal.getCollectionInfo().scheduling || !ove.getOrganizerSchedulingObject().booleanValue() && !ove.getAttendeeSchedulingObject().booleanValue()) continue;
                    schedulingObject = true;
                    organizerSchedulingObject = ove.getOrganizerSchedulingObject();
                    break;
                }
            }
            if (sendSchedulingMessage && schedulingObject) {
                SchedulingIntf sched = (SchedulingIntf)this.getSvc().getScheduler();
                if (!organizerSchedulingObject) {
                    sched.sendReply(ei, 2, null);
                } else {
                    EventInfo.UpdateResult uer = ei.getUpdResult();
                    uer.deleting = true;
                    event.setSequence(event.getSequence() + 1);
                    if (!sched.implicitSchedule(ei, false).isOk()) {
                        return Response.fromResponse((Response)resp, (Response)uer);
                    }
                }
            }
        }
        try {
            if (!this.getCal().deleteEvent((EventInfo)ei, (boolean)scheduling, (boolean)reallyDelete).eventDeleted) {
                this.getSvc().rollbackTransaction();
                return Response.notFound((Response)resp);
            }
            if (event.getEntityType() != 5) {
                return resp;
            }
            for (EventInfo aei : ei.getContainedItems()) {
                if (this.getCal().deleteEvent((EventInfo)aei, (boolean)scheduling, (boolean)true).eventDeleted) continue;
                this.getSvc().rollbackTransaction();
                return Response.notFound((Response)resp);
            }
            return resp;
        }
        catch (BedeworkException be) {
            return Response.error((Response)resp, (Throwable)be);
        }
    }

    private void adjustEntities(EventInfo event) {
    }

    private void buildCalendarSet(Collection<BwCalendar> cals, BwCalendar calendar, boolean freeBusy) {
        if (calendar == null) {
            return;
        }
        int desiredAccess = 1;
        if (freeBusy) {
            desiredAccess = 4;
        }
        if ((calendar = this.getCols().get(calendar.getPath())) == null) {
            return;
        }
        if (!this.getSvc().checkAccess((ShareableEntity)calendar, desiredAccess, true).getAccessAllowed()) {
            return;
        }
        if (calendar.getInternalAlias()) {
            BwCalendar saveColl = calendar;
            this.getCols().resolveAlias(calendar, true, freeBusy);
            while (calendar.getInternalAlias()) {
                if ((calendar = calendar.getAliasTarget()) != null) continue;
                saveColl.setLastRefreshStatus("403: Forbidden");
                return;
            }
        }
        if (calendar.getCalendarCollection() || calendar.getExternalSub() || cals.isEmpty() && calendar.getSpecial()) {
            cals.add(calendar);
            return;
        }
        if (calendar.getCalType() != 0) {
            return;
        }
        for (BwCalendar c : this.getCols().getChildren(calendar)) {
            this.buildCalendarSet(cals, c, freeBusy);
        }
    }

    private BwCalendar validate(BwEvent ev, boolean adding, boolean schedulingInbox, boolean autoCreateCollection) {
        if (ev.getColPath() == null) {
            throw new BedeworkException("org.bedework.exception.noeventcalendar");
        }
        if (ev.getNoStart() == null) {
            throw new BedeworkException("org.bedework.exception.missingeventproperty", "noStart");
        }
        if (ev.getDtstart() == null) {
            throw new BedeworkException("org.bedework.exception.missingeventproperty", "dtstart");
        }
        if (ev.getDtend() == null) {
            throw new BedeworkException("org.bedework.exception.missingeventproperty", "dtend");
        }
        if (ev.getDuration() == null) {
            throw new BedeworkException("org.bedework.exception.missingeventproperty", "duration");
        }
        if (ev.getRecurring() == null) {
            throw new BedeworkException("org.bedework.exception.missingeventproperty", "recurring");
        }
        if (ev.getEntityType() != 4 && ev.getSummary() == null) {
            throw new BedeworkException("org.bedework.exception.missingeventproperty", "summary");
        }
        String checkedString = this.checkString(ev.getSummary());
        if (checkedString != null) {
            ev.setSummary(checkedString);
        }
        if ((checkedString = this.checkString(ev.getDescription())) != null) {
            ev.setDescription(checkedString);
        }
        this.setScheduleState(ev, adding, schedulingInbox);
        BwCalendar col = this.getCols().get(ev.getColPath());
        if (col == null) {
            String entityType;
            if (!autoCreateCollection) {
                throw new BedeworkException("org.bedework.exception.calendarnotfound");
            }
            int calType = switch (entityType = IcalDefs.entityTypeIcalNames[ev.getEntityType()]) {
                case "VEVENT" -> 1;
                case "VTODO" -> 15;
                case "VPOLL" -> 12;
                default -> throw new BedeworkException("org.bedework.exception.noeventcalendar");
            };
            CoreCalendarsI.GetSpecialCalendarResult gscr = this.getCal().getSpecialCalendar(null, this.getPrincipal(), calType, true, 25);
            if (gscr.cal == null) {
                throw new BedeworkException("org.bedework.exception.noeventcalendar");
            }
            col = gscr.cal;
        }
        if (this.getPars().getPublicAdmin() && !this.getPars().getService()) {
            Preferences prefs = (Preferences)this.getSvc().getPrefsHandler();
            prefs.updateAdminPrefs(false, col, ev.getCategories(), ev.getLocation(), ev.getContact());
        }
        return col;
    }

    private String checkString(String val) {
        if (val == null) {
            return null;
        }
        String s1 = val.replaceAll("(\\r\\n|\\r)", "\n");
        boolean changed = !s1.equals(val);
        String s2 = s1.replaceAll("[\u0000-\t\u000b-\f\u000e-\u0019\u007f]+", "");
        if (!s2.equals(s1)) {
            changed = true;
        }
        if (!changed) {
            return null;
        }
        return s2;
    }

    private void setScheduleState(BwEvent ev, boolean adding, boolean schedulingInbox) {
        boolean weAreOrganizer;
        ev.setOrganizerSchedulingObject(Boolean.valueOf(false));
        ev.setAttendeeSchedulingObject(Boolean.valueOf(false));
        if (ev.getEntityType() != 0 && ev.getEntityType() != 2 && ev.getEntityType() != 7) {
            return;
        }
        SchedulingInfo si = ev.getSchedulingInfo();
        SchedulingOwner sowner = si.getSchedulingOwner();
        Collection atts = si.getRecipientParticipants().values();
        if (Util.isEmpty(atts) || sowner.noOwner()) {
            return;
        }
        String curPrincipal = this.getSvc().getPrincipal().getPrincipalRef();
        Directories dirs = this.getSvc().getDirectories();
        String curCalAddr = dirs.principalToCaladdr((AccessPrincipal)this.getPrincipal());
        BwPrincipal evPrincipal = dirs.caladdrToPrincipal(sowner.getCalendarAddress());
        boolean bl = weAreOrganizer = evPrincipal != null && evPrincipal.getPrincipalRef().equals(curPrincipal);
        if (!weAreOrganizer) {
            if (si.findParticipant(curCalAddr) != null) {
                ev.setAttendeeSchedulingObject(Boolean.valueOf(true));
            }
            return;
        }
        ev.setOrganizerSchedulingObject(Boolean.valueOf(true));
        ChangeTable chg = ev.getChangeset(this.getPrincipalHref());
        TreeSet<Participant> groups = new TreeSet<Participant>();
        if (!schedulingInbox) {
            ChangeTableEntry cteAtts = chg.getEntry(PropertyIndex.PropertyInfoIndex.ATTENDEE);
            ChangeTableEntry cteParts = chg.getEntry(PropertyIndex.PropertyInfoIndex.PARTICIPANT);
            block0: for (Participant att : atts) {
                BwAttendee chgAtt;
                if (CuType.GROUP.getValue().equals(att.getKind())) {
                    groups.add(att);
                }
                if (curCalAddr.equals(att.getCalendarAddress()) || att.getParticipationStatus().equals("NEEDS-ACTION")) continue;
                if (adding) {
                    att.setParticipationStatus("NEEDS-ACTION");
                    continue;
                }
                if (cteAtts != null && !Util.isEmpty((Collection)cteAtts.getAddedValues())) {
                    for (Object o : cteAtts.getAddedValues()) {
                        chgAtt = (BwAttendee)o;
                        if (!chgAtt.getCn().equals(att.getCalendarAddress())) continue;
                        chgAtt.setPartstat("NEEDS-ACTION");
                        continue block0;
                    }
                }
                if (cteParts == null || Util.isEmpty((Collection)cteParts.getAddedValues())) continue;
                for (Object o : cteParts.getAddedValues()) {
                    chgAtt = (BwParticipant)o;
                    if (!chgAtt.getCalendarAddress().equals(att.getCalendarAddress())) continue;
                    chgAtt.setParticipationStatus("NEEDS-ACTION");
                    continue block0;
                }
            }
        }
        boolean vpoll = ev.getEntityType() == 7;
        for (Participant att : groups) {
            BwPrincipalInfo pi;
            Directories.FindPrincipalsResult groupPisRes = dirs.find(att.getCalendarAddress(), att.getKind(), true);
            List groupPis = groupPisRes.principals();
            if (groupPis == null || groupPis.size() != 1 || (pi = (BwPrincipalInfo)groupPis.get(0)).getMembers() == null) continue;
            si.removeRecipientParticipant(att);
            for (BwPrincipalInfo mbrPi : pi.getMembers()) {
                if (mbrPi.getCaladruri() == null) continue;
                Participant mbrAtt = si.makeParticipantLike(att);
                mbrAtt.setParticipantType(att.getParticipantType());
                mbrAtt.setCalendarAddress(mbrPi.getCaladruri());
                mbrAtt.setEmail(mbrPi.getEmail());
                mbrAtt.setKind(mbrPi.getKind());
                mbrAtt.setMemberOf(att.getCalendarAddress());
            }
        }
        if (ev instanceof BwEventProxy) {
            return;
        }
        if ("Jasig Scheduling Assistant".equals(this.getPars().getClientId())) {
            ev.addXproperty(new BwXproperty("X-BEDEWORK-SCHED-ASSIST", null, "true"));
        }
    }

    private EventInfo postProcess(CoreEventInfo cei) {
        if (cei == null) {
            return null;
        }
        BwEvent ev = cei.getEvent();
        if (ev instanceof BwEventAnnotation) {
            ev = new BwEventProxy((BwEventAnnotation)ev);
        }
        TreeSet<EventInfo> overrides = new TreeSet<EventInfo>();
        if (cei.getOverrides() != null) {
            for (CoreEventInfo ocei : cei.getOverrides()) {
                BwEventProxy op = (BwEventProxy)ocei.getEvent();
                overrides.add(new EventInfo((BwEvent)op));
            }
        }
        EventInfo ei = new EventInfo(ev, overrides);
        if (cei.getNumContainedItems() > 0) {
            for (CoreEventInfo ccei : cei.getContainedItems()) {
                BwEvent cv = ccei.getEvent();
                ei.addContainedItem(new EventInfo(cv));
            }
        }
        ei.setCurrentAccess(cei.getCurrentAccess());
        return ei;
    }

    private Set<EventInfo> postProcess(Collection<CoreEventInfo> ceis) {
        TreeSet<EventInfo> eis = new TreeSet<EventInfo>();
        for (CoreEventInfo cei : ceis) {
            eis.add(this.postProcess(cei));
        }
        return eis;
    }

    private void setDefaultAlarms(EventInfo ei, BwCalendar col) {
        boolean isTask;
        BwEvent event = ei.getEvent();
        boolean isEvent = event.getEntityType() == 0;
        boolean bl = isTask = event.getEntityType() == 2;
        if (!isEvent && !isTask) {
            return;
        }
        boolean isDate = event.getDtstart().getDateType();
        String al = this.getDefaultAlarmDef(col, isEvent, isDate);
        if (al == null) {
            al = this.getDefaultAlarmDef(this.getCols().getHome(), isEvent, isDate);
        }
        if (al == null || al.isEmpty()) {
            return;
        }
        Set<BwAlarm> alarms = this.compileAlarms(al);
        if (alarms == null) {
            return;
        }
        for (BwAlarm alarm : alarms) {
            alarm.addXproperty(new BwXproperty("X-APPLE-DEFAULT-ALARM", null, "TRUE"));
            event.addAlarm(alarm);
            ei.getChangeset(this.getPrincipalHref()).addValue(PropertyIndex.PropertyInfoIndex.VALARM, (Object)alarm);
        }
    }

    private String getDefaultAlarmDef(BwCalendar col, boolean isEvent, boolean isDate) {
        if (col == null) {
            return null;
        }
        QName pname = isEvent ? (isDate ? CaldavTags.defaultAlarmVeventDate : CaldavTags.defaultAlarmVeventDatetime) : (isDate ? CaldavTags.defaultAlarmVtodoDate : CaldavTags.defaultAlarmVtodoDatetime);
        return col.getProperty(NamespaceAbbrevs.prefixed((QName)pname));
    }

    public Set<BwAlarm> compileAlarms(String val) {
        try {
            StringReader sr = new StringReader(ValidateAlarmPrefix + val + ValidateAlarmSuffix);
            IcalTranslator trans = new IcalTranslator(this.getSvc().getIcalCallback());
            Icalendar ic = trans.fromIcal(null, (Reader)sr);
            if (ic == null || ic.getEventInfo() == null) {
                if (this.debug()) {
                    this.debug("Not single event");
                }
                return null;
            }
            EventInfo ei = ic.getEventInfo();
            BwEvent ev = ei.getEvent();
            Set alarms = ev.getAlarms();
            if (Util.isEmpty((Collection)alarms)) {
                return null;
            }
            return alarms;
        }
        catch (BedeworkException be) {
            if (this.debug()) {
                this.error(be);
            }
            return null;
        }
    }
}

