/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.Response;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.ShareableEntity;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Events;
import org.bedework.util.misc.Util;
import org.bedework.util.security.PwEncryptionIntf;

public class CalSvcHelperRw
extends CalSvcDb {
    public CalSvcHelperRw(CalSvc svci) {
        super(svci);
    }

    protected void setupSharableEntity(BwShareableDbentity<?> entity, String ownerHref) {
        this.getSvc().setupSharableEntity((ShareableEntity)entity, ownerHref);
    }

    protected PwEncryptionIntf getEncrypter() {
        return this.getSvc().getEncrypter();
    }

    protected BwCalendar getSpecialCalendar(BwPrincipal<?> owner, int calType, boolean create, int access) {
        return this.getCols().getSpecial(owner, calType, create, access);
    }

    protected Collection<EventInfo> getEvents(Collection<BwCalendar> cols, FilterBase filter, BwDateTime startDate, BwDateTime endDate, RecurringRetrievalMode recurRetrieval, boolean freeBusy) {
        Events events = (Events)this.getSvc().getEventsHandler();
        return events.getMatching(cols, filter, startDate, endDate, null, BwIndexer.DeletedState.noDeleted, recurRetrieval, freeBusy);
    }

    protected GetEntitiesResponse<EventInfo> getEventsByUid(String colPath, String guid) {
        Events events = (Events)this.getSvc().getEventsHandler();
        GetEntitiesResponse resp = new GetEntitiesResponse();
        try {
            Collection<EventInfo> ents = events.getByUid(colPath, guid, null, RecurringRetrievalMode.overrides);
            if (Util.isEmpty(ents)) {
                resp.setStatus(Response.Status.notFound);
            } else {
                resp.setEntities(ents);
            }
            return resp;
        }
        catch (Throwable t) {
            return (GetEntitiesResponse)Response.error((Response)resp, (Throwable)t);
        }
    }
}

