/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webdav.servlet.common;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.xml.namespace.QName;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.servlet.HttpAppLogger;
import org.bedework.util.servlet.io.CharArrayWrappedResponse;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.common.AclMethod;
import org.bedework.webdav.servlet.common.CopyMethod;
import org.bedework.webdav.servlet.common.DeleteMethod;
import org.bedework.webdav.servlet.common.GetMethod;
import org.bedework.webdav.servlet.common.HeadMethod;
import org.bedework.webdav.servlet.common.MethodBase;
import org.bedework.webdav.servlet.common.MkcolMethod;
import org.bedework.webdav.servlet.common.MoveMethod;
import org.bedework.webdav.servlet.common.OptionsMethod;
import org.bedework.webdav.servlet.common.PostMethod;
import org.bedework.webdav.servlet.common.PropFindMethod;
import org.bedework.webdav.servlet.common.PropPatchMethod;
import org.bedework.webdav.servlet.common.PutMethod;
import org.bedework.webdav.servlet.shared.WebdavException;
import org.bedework.webdav.servlet.shared.WebdavForbidden;
import org.bedework.webdav.servlet.shared.WebdavNsIntf;

public abstract class WebdavServlet
extends HttpServlet
implements HttpAppLogger,
HttpSessionListener {
    protected boolean dumpContent;
    protected boolean preserveSession;
    protected HashMap<String, MethodBase.MethodInfo> methods = new HashMap();
    private static final HashMap<String, Waiter> waiters = new HashMap();
    private final BwLogger logger = new BwLogger();

    public String getLogPrefix(HttpServletRequest request) {
        return "webdav";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.dumpContent = "true".equals(config.getInitParameter("dumpContent"));
        this.preserveSession = "true".equals(config.getInitParameter("preserve-session"));
        this.addMethods();
    }

    public void setPreserveSession(boolean val) {
        this.preserveSession = val;
    }

    public abstract WebdavNsIntf getNsIntf(HttpServletRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        WebdavNsIntf intf = null;
        boolean serverError = false;
        try {
            MethodBase method;
            String methodName;
            this.logRequest(req);
            if (this.debug()) {
                this.debug("entry: " + req.getMethod());
                this.dumpRequest(req);
            }
            this.tryWait(req, true);
            intf = this.getNsIntf(req);
            if (req.getCharacterEncoding() == null) {
                req.setCharacterEncoding("UTF-8");
                if (this.debug()) {
                    this.debug("No charset specified in request; forced to UTF-8");
                }
            }
            if (this.debug() && this.dumpContent) {
                resp = new CharArrayWrappedResponse(resp);
            }
            if ((methodName = req.getHeader("X-HTTP-Method-Override")) == null) {
                methodName = req.getMethod();
            }
            if ((method = intf.getMethod(methodName)) == null) {
                this.info("No method for '" + methodName + "'");
                resp.setStatus(405);
            } else {
                method.checkServerInfo(req, resp);
                method.doMethod(req, resp);
            }
        }
        catch (WebdavForbidden wdf) {
            this.sendError(intf, wdf, resp);
        }
        catch (Throwable t) {
            serverError = this.handleException(intf, t, resp, serverError);
        }
        finally {
            if (intf != null) {
                try {
                    intf.close();
                }
                catch (Throwable t) {
                    serverError = this.handleException(intf, t, resp, serverError);
                }
            }
            try {
                this.tryWait(req, false);
            }
            catch (Throwable t) {}
            if (this.debug() && this.dumpContent && resp instanceof CharArrayWrappedResponse) {
                CharArrayWrappedResponse wresp = (CharArrayWrappedResponse)resp;
                if (wresp.getUsedOutputStream()) {
                    this.debug("------------------------ response written to output stream -------------------");
                } else {
                    String str = wresp.toString();
                    if (str == null || str.isEmpty()) {
                        this.debug("------------------------ No response content -------------------");
                        resp.setContentLength(0);
                    } else {
                        this.debug("------------------------ Dump of response -------------------");
                        this.debug(str);
                        this.debug("---------------------- End dump of response -----------------");
                        byte[] bs = str.getBytes();
                        resp = (HttpServletResponse)wresp.getResponse();
                        this.debug("contentLength=" + bs.length);
                        resp.setContentLength(bs.length);
                        resp.getOutputStream().write(bs);
                    }
                }
            }
            try {
                this.logRequestOut(req);
            }
            catch (Throwable wresp) {}
            if (!this.preserveSession) {
                try {
                    HttpSession sess = req.getSession(false);
                    if (sess != null) {
                        sess.invalidate();
                    }
                }
                catch (Throwable sess) {}
            }
        }
    }

    private boolean handleException(WebdavNsIntf intf, Throwable t, HttpServletResponse resp, boolean serverError) {
        if (serverError) {
            return true;
        }
        try {
            if (t instanceof WebdavException) {
                WebdavException wde = (WebdavException)t;
                int status = wde.getStatusCode();
                if (status == 500) {
                    this.error(wde);
                    serverError = true;
                }
                this.sendError(intf, wde, resp);
                return serverError;
            }
            if (this.debug()) {
                this.error(t);
            }
            this.sendError(intf, t, resp);
            return true;
        }
        catch (Throwable t1) {
            this.error(t1);
            return true;
        }
    }

    private void sendError(WebdavNsIntf intf, Throwable t, HttpServletResponse resp) {
        try {
            try {
                intf.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t instanceof WebdavException) {
                WebdavException wde = (WebdavException)t;
                QName errorTag = wde.getErrorTag();
                if (errorTag != null) {
                    if (this.debug()) {
                        this.debug("setStatus(" + wde.getStatusCode() + ") message=" + wde.getMessage());
                    }
                    resp.setStatus(wde.getStatusCode());
                    resp.setContentType("text/xml; charset=UTF-8");
                    if (!this.emitError(intf, errorTag, wde.getMessage(), resp.getWriter())) {
                        StringWriter sw = new StringWriter();
                        this.emitError(intf, errorTag, wde.getMessage(), sw);
                        try {
                            if (this.debug()) {
                                this.debug("setStatus(" + wde.getStatusCode() + ") message=" + wde.getMessage());
                            }
                            resp.sendError(wde.getStatusCode(), sw.toString());
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    if (this.debug()) {
                        this.debug("setStatus(" + wde.getStatusCode() + ") message=" + wde.getMessage());
                    }
                    resp.sendError(wde.getStatusCode(), wde.getMessage());
                }
            } else {
                if (this.debug()) {
                    this.debug("setStatus(500) message=" + t.getMessage());
                }
                resp.sendError(500, t.getMessage());
            }
        }
        catch (Throwable ignored) {
            resp.setStatus(500);
        }
    }

    private boolean emitError(WebdavNsIntf intf, QName errorTag, String extra, Writer wtr) {
        XmlEmit xml = new XmlEmit();
        intf.addNamespace(xml);
        xml.startEmit(wtr);
        xml.openTag(WebdavTags.error);
        intf.emitError(errorTag, extra, xml);
        xml.closeTag(WebdavTags.error);
        xml.flush();
        return true;
    }

    protected void addMethods() {
        this.methods.put("ACL", new MethodBase.MethodInfo(AclMethod.class, false));
        this.methods.put("COPY", new MethodBase.MethodInfo(CopyMethod.class, false));
        this.methods.put("GET", new MethodBase.MethodInfo(GetMethod.class, false));
        this.methods.put("HEAD", new MethodBase.MethodInfo(HeadMethod.class, false));
        this.methods.put("OPTIONS", new MethodBase.MethodInfo(OptionsMethod.class, false));
        this.methods.put("PROPFIND", new MethodBase.MethodInfo(PropFindMethod.class, false));
        this.methods.put("DELETE", new MethodBase.MethodInfo(DeleteMethod.class, true));
        this.methods.put("MKCOL", new MethodBase.MethodInfo(MkcolMethod.class, true));
        this.methods.put("MOVE", new MethodBase.MethodInfo(MoveMethod.class, true));
        this.methods.put("POST", new MethodBase.MethodInfo(PostMethod.class, true));
        this.methods.put("PROPPATCH", new MethodBase.MethodInfo(PropPatchMethod.class, true));
        this.methods.put("PUT", new MethodBase.MethodInfo(PutMethod.class, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryWait(HttpServletRequest req, boolean in) throws Throwable {
        Waiter wtr;
        Object object = waiters;
        synchronized (object) {
            String key = req.getRemoteUser();
            if (key == null) {
                return;
            }
            wtr = waiters.get(key);
            if (wtr == null) {
                if (!in) {
                    return;
                }
                wtr = new Waiter();
                wtr.active = true;
                waiters.put(key, wtr);
                return;
            }
        }
        object = wtr;
        synchronized (object) {
            if (!in) {
                wtr.active = false;
                wtr.notify();
                return;
            }
            ++wtr.waiting;
            while (wtr.active) {
                if (this.debug()) {
                    this.debug("in: waiters=" + wtr.waiting);
                }
                wtr.wait();
            }
            --wtr.waiting;
            wtr.active = true;
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        HttpSession session = se.getSession();
        String sessid = session.getId();
        if (sessid == null) {
            return;
        }
        HashMap<String, Waiter> hashMap = waiters;
        synchronized (hashMap) {
            waiters.remove(sessid);
        }
    }

    public void dumpRequest(HttpServletRequest req) {
        String key;
        Enumeration names = req.getHeaderNames();
        String title = "Request headers";
        this.debug(title);
        while (names.hasMoreElements()) {
            key = (String)names.nextElement();
            Enumeration vals = req.getHeaders(key);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (key.equalsIgnoreCase("authorization") && val != null && val.toLowerCase().startsWith("basic")) {
                    val = "Basic **********";
                }
                this.debug("  " + key + " = \"" + val + "\"");
            }
        }
        names = req.getParameterNames();
        title = "Request parameters";
        this.debug(title + " - global info and uris");
        this.debug("getRemoteAddr = " + req.getRemoteAddr());
        this.debug("getRequestURI = " + req.getRequestURI());
        this.debug("getRemoteUser = " + req.getRemoteUser());
        this.debug("getRequestedSessionId = " + req.getRequestedSessionId());
        this.debug("HttpUtils.getRequestURL(req) = " + req.getRequestURL());
        this.debug("contextPath=" + req.getContextPath());
        this.debug("query=" + req.getQueryString());
        this.debug("contentlen=" + req.getContentLength());
        this.debug("request=" + req);
        this.debug("parameters:");
        this.debug(title);
        while (names.hasMoreElements()) {
            key = (String)names.nextElement();
            String val = req.getParameter(key);
            this.debug("  " + key + " = \"" + val + "\"");
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(((Object)((Object)this)).getClass());
        }
        return this.logger;
    }

    static class Waiter {
        boolean active;
        int waiting;

        Waiter() {
        }
    }
}

