/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.impl;

import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;

public class HttpPublicKeyRecordRetriever
implements PublicKeyRecordRetriever {
    @Override
    public List<String> getRecords(CharSequence methodAndOptions, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
        if (!"http/well-known".equals(methodAndOptions)) {
            throw new PermFailException("Only http/well-known is supported: " + methodAndOptions + " options unsupported.");
        }
        StringBuilder path = new StringBuilder("http://");
        path.append(token);
        path.append(":8008");
        path.append("/.well-known/domainkey/");
        path.append(token);
        path.append("/");
        path.append(selector);
        String response = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(path.toString());
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            response = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
        }
        catch (Throwable t) {
            throw new PermFailException("Error fetching key from : " + path.toString());
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        if (response == null) {
            return null;
        }
        LineNumberReader lnr = new LineNumberReader(new StringReader(response));
        ArrayList<String> records = new ArrayList<String>();
        try {
            while (true) {
                String l;
                if ((l = lnr.readLine()) == null) {
                    return records;
                }
                records.add(l);
            }
        }
        catch (Throwable t) {
            throw new PermFailException("Error parsing result from : " + path.toString());
        }
    }
}

