/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.session.jdbc;

import java.io.Serializable;
import java.security.Principal;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.Instant;
import javax.sql.DataSource;
import org.beangle.cache.CacheManager;
import org.beangle.commons.event.Event;
import org.beangle.commons.io.BinarySerializer;
import org.beangle.commons.lang.Objects$;
import org.beangle.data.jdbc.query.ParamSetter$;
import org.beangle.security.authc.Account;
import org.beangle.security.session.LoginEvent;
import org.beangle.security.session.LogoutEvent;
import org.beangle.security.session.OvermaxSessionException;
import org.beangle.security.session.Session;
import org.beangle.security.session.SessionProfile;
import org.beangle.security.session.SessionRegistry;
import org.beangle.security.session.jdbc.DBSessionCleaner;
import org.beangle.security.session.jdbc.DBSessionRepo;
import org.beangle.security.util.SecurityDaemon$;
import org.beangle.security.util.Task;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\u0007\u000f\u0001eA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\nW\u0001\u0011\t\u0011)A\u0005YIB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0011\u0019y\u0005\u0001)A\u0005\u000f\")\u0001\u000b\u0001C!#\")\u0001\f\u0001C!3\"1q\u0010\u0001C!\u0003\u0003Aq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u00055\u0002\u0001\"\u0003\u00020\t\tBIQ*fgNLwN\u001c*fO&\u001cHO]=\u000b\u0005=\u0001\u0012\u0001\u00026eE\u000eT!!\u0005\n\u0002\u000fM,7o]5p]*\u00111\u0003F\u0001\tg\u0016\u001cWO]5us*\u0011QCF\u0001\bE\u0016\fgn\u001a7f\u0015\u00059\u0012aA8sO\u000e\u00011c\u0001\u0001\u001b=A\u00111\u0004H\u0007\u0002\u001d%\u0011QD\u0004\u0002\u000e\t\n\u001bVm]:j_:\u0014V\r]8\u0011\u0005}\u0001S\"\u0001\t\n\u0005\u0005\u0002\"aD*fgNLwN\u001c*fO&\u001cHO]=\u0002\u0015\u0011\fG/Y*pkJ\u001cW\r\u0005\u0002%S5\tQE\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0003!\nQA[1wCbL!AK\u0013\u0003\u0015\u0011\u000bG/Y*pkJ\u001cW-\u0001\u0007dC\u000eDW-T1oC\u001e,'\u000f\u0005\u0002.a5\taF\u0003\u00020)\u0005)1-Y2iK&\u0011\u0011G\f\u0002\r\u0007\u0006\u001c\u0007.Z'b]\u0006<WM]\u0005\u0003WMJ!\u0001N\u001b\u0003!\r\u000b7\r[3TKN\u001c\u0018n\u001c8SKB|'BA\u0018\u0011\u0003)\u0019XM]5bY&TXM\u001d\t\u0003quj\u0011!\u000f\u0006\u0003um\n!![8\u000b\u0005q\"\u0012aB2p[6|gn]\u0005\u0003}e\u0012\u0001CQ5oCJL8+\u001a:jC2L'0\u001a:\u0002\rqJg.\u001b;?)\u0011\t%i\u0011#\u0011\u0005m\u0001\u0001\"\u0002\u0012\u0005\u0001\u0004\u0019\u0003\"B\u0016\u0005\u0001\u0004a\u0003\"\u0002\u001c\u0005\u0001\u00049\u0014!D5og\u0016\u0014HoQ8mk6t7/F\u0001H!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003mC:<'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013aa\u0015;sS:<\u0017AD5og\u0016\u0014HoQ8mk6t7\u000fI\u0001\u0005S:LG\u000fF\u0001S!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u0011)f.\u001b;\u0002\u0011I,w-[:uKJ$RAW/jcj\u0004\"aH.\n\u0005q\u0003\"aB*fgNLwN\u001c\u0005\u0006=\"\u0001\raX\u0001\ng\u0016\u001c8/[8o\u0013\u0012\u0004\"\u0001Y4\u000f\u0005\u0005,\u0007C\u00012U\u001b\u0005\u0019'B\u00013\u0019\u0003\u0019a$o\\8u}%\u0011a\rV\u0001\u0007!J,G-\u001a4\n\u00059C'B\u00014U\u0011\u0015Q\u0007\u00021\u0001l\u0003\u0011IgNZ8\u0011\u00051|W\"A7\u000b\u00059\u0014\u0012!B1vi\"\u001c\u0017B\u00019n\u0005\u001d\t5mY8v]RDQA\u001d\u0005A\u0002M\fQ!Y4f]R\u0004\"\u0001^<\u000f\u0005})\u0018B\u0001<\u0011\u0003\u001d\u0019Vm]:j_:L!\u0001_=\u0003\u000b\u0005;WM\u001c;\u000b\u0005Y\u0004\u0002\"B>\t\u0001\u0004a\u0018a\u00029s_\u001aLG.\u001a\t\u0003?uL!A \t\u0003\u001dM+7o]5p]B\u0013xNZ5mK\u0006Ya-\u001b8e\u000bb\u0004\u0018N]3e)\t\t\u0019\u0001E\u0003\u0002\u0006\u0005-q,\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u000e\u0005\u001d!aA*fc\u0006a1/Z:tS>t7i\\;oiR!\u00111CA\r!\r\u0019\u0016QC\u0005\u0004\u0003/!&aA%oi\"9\u00111\u0004\u0006A\u0002\u0005M\u0011AC2bi\u0016<wN]=JI\u00061!/Z7pm\u0016$b!!\t\u0002(\u0005%\u0002\u0003B*\u0002$iK1!!\nU\u0005\u0019y\u0005\u000f^5p]\")al\u0003a\u0001?\"1\u00111F\u0006A\u0002}\u000baA]3bg>t\u0017\u0001B:bm\u0016$2AUA\u0019\u0011\u0019\t\u0019\u0004\u0004a\u00015\u0006\t1\u000f")
public class DBSessionRegistry
extends DBSessionRepo
implements SessionRegistry {
    private final BinarySerializer serializer;
    private final String insertColumns;

    private String insertColumns() {
        return this.insertColumns;
    }

    @Override
    public void init() {
        SecurityDaemon$.MODULE$.start("Beangle Session", this.flushInterval(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Task[]{this.accessReporter(), new DBSessionCleaner(this)}));
    }

    public Session register(String sessionId, Account info, Session.Agent agent, SessionProfile profile) {
        Session session;
        int sc;
        Session existed = (Session)this.get(sessionId).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        String principal = info.getName();
        if (profile.checkCapacity() && (sc = this.sessionCount(info.categoryId())) + 1 > profile.capacity()) {
            throw new OvermaxSessionException(profile.capacity(), (Object)principal);
        }
        if (existed != null && Objects$.MODULE$.equals((Object)existed.principal(), (Object)principal)) {
            session = existed;
        } else {
            Seq<Session> concurrents;
            int expiredCnt;
            Option<Session> option = existed != null ? this.remove(sessionId, " expired by replacement.") : BoxedUnit.UNIT;
            if (profile.checkConcurrent() && profile.concurrent() > 0 && (expiredCnt = (concurrents = this.findByPrincipal(principal)).size() + 1 - profile.concurrent()) > 0) {
                ((IterableOnceOps)concurrents.take(expiredCnt)).foreach((Function1 & Serializable)x -> {
                    this.expire(x.id());
                    return BoxedUnit.UNIT;
                });
            }
            Session session2 = this.builder().build(sessionId, (Principal)info, Instant.now(), agent, profile.ttiSeconds());
            this.save(session2);
            this.publish((Event)new LoginEvent(session2));
            session = session2;
        }
        return session;
    }

    public Seq<String> findExpired() {
        return (Seq)this.executor().query(new StringBuilder(92).append("select id from ").append(this.sessionTable()).append(" info where add_seconds(info.last_access_at,tti_seconds) <= current_timestamp").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])).map((Function1 & Serializable)data -> data[0].toString());
    }

    private int sessionCount(int categoryId) {
        return BoxesRunTime.unboxToInt((Object)this.executor().queryForInt(new StringBuilder(0).append(new StringBuilder(40).append("select count(*) from ").append(this.sessionTable()).append(" where category_id=").toString()).append(categoryId).toString()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    /*
     * WARNING - void declaration
     */
    public Option<Session> remove(String sessionId, String reason) {
        void var3_3;
        Option<Session> s = this.get(sessionId);
        s.foreach((Function1 & Serializable)session -> {
            DBSessionRegistry.$anonfun$remove$1(this, sessionId, reason, session);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private void save(Session s) {
        String sessionId = s.id();
        Session.Agent ac = s.agent();
        this.executor().statement(new StringBuilder(45).append("insert into ").append(this.sessionTable()).append(" (").append(this.insertColumns()).append(") values(?,?,?,?,?,?,?,?,?,?,?)").toString()).prepare((Function1 & Serializable)x -> {
            DBSessionRegistry.$anonfun$save$1(this, sessionId, s, ac, x);
            return BoxedUnit.UNIT;
        }).execute();
        this.put(s);
    }

    public static final /* synthetic */ void $anonfun$remove$1(DBSessionRegistry $this, String sessionId$1, String reason$1, Session session) {
        $this.evict(session);
        $this.executor().update(new StringBuilder(23).append("delete from ").append($this.sessionTable()).append(" where id=?").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sessionId$1}));
        $this.publish((Event)new LogoutEvent(session, reason$1));
    }

    public static final /* synthetic */ void $anonfun$save$1(DBSessionRegistry $this, String sessionId$2, Session s$1, Session.Agent ac$1, PreparedStatement x) {
        x.setString(1, sessionId$2);
        x.setString(2, s$1.principal().getName());
        x.setString(3, ((Account)s$1.principal()).description());
        x.setString(4, ac$1.ip());
        x.setString(5, ac$1.name());
        x.setString(6, ac$1.os());
        x.setTimestamp(7, Timestamp.from(s$1.loginAt()));
        x.setTimestamp(8, Timestamp.from(s$1.loginAt()));
        x.setInt(9, s$1.ttiSeconds());
        x.setInt(10, ((Account)s$1.principal()).categoryId());
        ParamSetter$.MODULE$.setParam(x, 11, (Object)$this.serializer.asBytes((Object)s$1), -2);
    }

    public DBSessionRegistry(DataSource dataSource, CacheManager cacheManager, BinarySerializer serializer) {
        this.serializer = serializer;
        super(dataSource, cacheManager, serializer);
        this.insertColumns = "id,principal,description,ip,agent,os,login_at,last_access_at,tti_seconds,category_id,data";
    }
}

