/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.beangle.commons.conversion.converter.String2BooleanConverter$;
import org.beangle.commons.lang.Dates$;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.transfer.excel.CellOps;
import org.beangle.data.transfer.excel.ExcelStyleRegistry;
import org.beangle.data.transfer.io.DataType;
import org.beangle.data.transfer.io.DataType$;
import scala.Float$;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class CellOps$
implements Serializable {
    private static final NumberFormat NumFormat;
    public static final CellOps$ MODULE$;

    private CellOps$() {
    }

    static {
        MODULE$ = new CellOps$();
        NumFormat = NumberFormat.getNumberInstance();
        NumFormat.setMinimumFractionDigits(0);
        NumFormat.setGroupingUsed(false);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CellOps$.class);
    }

    public Cell toCell(Cell x) {
        return x;
    }

    public final int hashCode$extension(Cell $this) {
        return $this.hashCode();
    }

    public final boolean equals$extension(Cell $this, Object x$0) {
        boolean bl;
        Object object = x$0;
        if (object instanceof CellOps) {
            Cell cell = object == null ? null : ((CellOps)object).org$beangle$data$transfer$excel$CellOps$$cell();
            Cell cell2 = $this;
            Cell cell3 = cell;
            bl = !(cell2 != null ? !cell2.equals(cell3) : cell3 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void fillin$extension(Cell $this, Object value, ExcelStyleRegistry registry) {
        Object s;
        Object object = value;
        Object v = object instanceof Some ? (s = ((Some)object).value()) : (None$.MODULE$.equals(object) ? null : value);
        Object object2 = v;
        if (object2 == null) {
            this.org$beangle$data$transfer$excel$CellOps$$$fillBlank$extension($this);
            return;
        } else if (object2 instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)object2;
            java.util.Date date = d;
            if (date instanceof Date) {
                Date sd = (Date)date;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, sd, registry);
                return;
            } else if (date instanceof Timestamp) {
                Timestamp st = (Timestamp)date;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, st, registry);
                return;
            } else if (date instanceof Time) {
                Time stt = (Time)date;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, stt, registry);
                return;
            } else {
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, d, registry);
            }
            return;
        } else if (object2 instanceof Calendar) {
            Calendar uc = (Calendar)object2;
            this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, uc.getTime(), registry);
            return;
        } else if (object2 instanceof Temporal) {
            Temporal t = (Temporal)object2;
            Temporal temporal = t;
            if (temporal instanceof LocalDate) {
                LocalDate ld = (LocalDate)temporal;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, Date.valueOf(ld), registry);
                return;
            } else if (temporal instanceof Instant) {
                Instant i = (Instant)temporal;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, java.util.Date.from(i), registry);
                return;
            } else if (temporal instanceof LocalDateTime) {
                LocalDateTime ldt = (LocalDateTime)temporal;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, java.util.Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant()), registry);
                return;
            } else if (temporal instanceof ZonedDateTime) {
                ZonedDateTime zdt = (ZonedDateTime)temporal;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, java.util.Date.from(zdt.toInstant()), registry);
                return;
            } else if (temporal instanceof LocalTime) {
                LocalTime lt = (LocalTime)temporal;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, Time.valueOf(lt), registry);
                return;
            } else if (temporal instanceof Year) {
                Year y = (Year)temporal;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, y, registry);
                return;
            } else {
                if (!(temporal instanceof YearMonth)) throw new MatchError((Object)temporal);
                YearMonth yt = (YearMonth)temporal;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, yt, registry);
            }
            return;
        } else if (object2 instanceof MonthDay) {
            MonthDay md = (MonthDay)object2;
            this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, md, registry);
            return;
        } else if (object2 instanceof Number) {
            Number n = (Number)object2;
            Number number = n;
            if (number instanceof Integer) {
                Integer i = (Integer)number;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, i, registry);
                return;
            } else if (number instanceof Float) {
                Float f = (Float)number;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, f.floatValue(), registry);
                return;
            } else if (number instanceof Double) {
                Double d = (Double)number;
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, d, registry);
                return;
            } else {
                this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, n.intValue(), registry);
            }
            return;
        } else if (object2 instanceof Boolean) {
            Boolean b = (Boolean)object2;
            this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, b, registry);
            return;
        } else {
            this.org$beangle$data$transfer$excel$CellOps$$$fill$extension($this, v.toString(), registry);
        }
    }

    public final Object getValue$extension(Cell $this) {
        Comparable<java.util.Date> comparable;
        CellType cellType = $this.getCellType();
        CellType cellType2 = CellType.BLANK;
        CellType cellType3 = cellType;
        if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
            comparable = null;
        } else {
            CellType cellType4 = CellType.STRING;
            CellType cellType5 = cellType;
            if (!(cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null)) {
                comparable = Strings$.MODULE$.trim($this.getRichStringCellValue().getString());
            } else {
                CellType cellType6 = CellType.NUMERIC;
                CellType cellType7 = cellType;
                if (!(cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null)) {
                    comparable = DateUtil.isCellDateFormatted((Cell)$this) ? $this.getDateCellValue() : BoxesRunTime.boxToDouble((double)$this.getNumericCellValue());
                } else {
                    CellType cellType8 = CellType.BOOLEAN;
                    CellType cellType9 = cellType;
                    if (!(cellType8 != null ? !cellType8.equals(cellType9) : cellType9 != null)) {
                        comparable = $this.getBooleanCellValue() ? BoxesRunTime.boxToBoolean((boolean)true) : BoxesRunTime.boxToBoolean((boolean)false);
                    } else {
                        CellType cellType10 = CellType.FORMULA;
                        CellType cellType11 = cellType;
                        if (!(cellType10 != null ? !cellType10.equals(cellType11) : cellType11 != null)) {
                            CellType cellType12 = $this.getCachedFormulaResultType();
                            CellType cellType13 = CellType.STRING;
                            CellType cellType14 = cellType12;
                            if (!(cellType13 != null ? !cellType13.equals(cellType14) : cellType14 != null)) {
                                comparable = Strings$.MODULE$.trim($this.getRichStringCellValue().getString());
                            } else {
                                CellType cellType15 = CellType.NUMERIC;
                                CellType cellType16 = cellType12;
                                comparable = !(cellType15 != null ? !cellType15.equals(cellType16) : cellType16 != null) ? BoxesRunTime.boxToDouble((double)$this.getNumericCellValue()) : null;
                            }
                        } else {
                            comparable = null;
                        }
                    }
                }
            }
        }
        return comparable;
    }

    public final Object getValue$extension(Cell $this, DataType dataType) {
        Object object;
        Object object2 = this.getValue$extension($this);
        if (object2 == null) {
            object = null;
        } else if (object2 instanceof String) {
            String s = (String)object2;
            object = this.org$beangle$data$transfer$excel$CellOps$$$convert$extension($this, s, dataType);
        } else if (object2 instanceof Double) {
            Double d = (Double)object2;
            object = this.org$beangle$data$transfer$excel$CellOps$$$convert$extension($this, Predef$.MODULE$.Double2double(d), dataType);
        } else if (object2 instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)object2;
            object = this.org$beangle$data$transfer$excel$CellOps$$$convert$extension($this, d, dataType);
        } else if (object2 instanceof Object) {
            Object d;
            object = d = object2;
        } else {
            throw new MatchError(object2);
        }
        return object;
    }

    public final Object org$beangle$data$transfer$excel$CellOps$$$convert$extension(Cell $this, String str, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        DataType dataType3 = DataType$.String;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            object = str;
        } else {
            DataType dataType5 = DataType$.Short;
            DataType dataType6 = dataType2;
            if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
                object = Numbers$.MODULE$.convert2Short(str, Numbers$.MODULE$.convert2Short$default$2());
            } else {
                DataType dataType7 = DataType$.Integer;
                DataType dataType8 = dataType2;
                if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
                    object = Numbers$.MODULE$.convert2Int(str, Numbers$.MODULE$.convert2Int$default$2());
                } else {
                    DataType dataType9 = DataType$.Long;
                    DataType dataType10 = dataType2;
                    if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
                        object = Numbers$.MODULE$.convert2Long(str, Numbers$.MODULE$.convert2Long$default$2());
                    } else {
                        DataType dataType11 = DataType$.Float;
                        DataType dataType12 = dataType2;
                        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
                            object = Numbers$.MODULE$.convert2Float(str, Numbers$.MODULE$.convert2Float$default$2());
                        } else {
                            DataType dataType13 = DataType$.Double;
                            DataType dataType14 = dataType2;
                            if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
                                object = Numbers$.MODULE$.convert2Double(str, Numbers$.MODULE$.convert2Double$default$2());
                            } else {
                                DataType dataType15 = DataType$.Date;
                                DataType dataType16 = dataType2;
                                if (!(dataType15 != null ? !dataType15.equals(dataType16) : dataType16 != null)) {
                                    object = LocalDate.parse(Dates$.MODULE$.normalize(str));
                                } else {
                                    DataType dataType17 = DataType$.DateTime;
                                    DataType dataType18 = dataType2;
                                    if (!(dataType17 != null ? !dataType17.equals(dataType18) : dataType18 != null)) {
                                        object = LocalDateTime.parse(Dates$.MODULE$.normalize(str));
                                    } else {
                                        DataType dataType19 = DataType$.Boolean;
                                        DataType dataType20 = dataType2;
                                        if (!(dataType19 != null ? !dataType19.equals(dataType20) : dataType20 != null)) {
                                            object = String2BooleanConverter$.MODULE$.apply(str);
                                        } else {
                                            DataType dataType21 = DataType$.Time;
                                            DataType dataType22 = dataType2;
                                            if (!(dataType21 != null ? !dataType21.equals(dataType22) : dataType22 != null)) {
                                                object = LocalTime.parse(str);
                                            } else {
                                                DataType dataType23 = DataType$.YearMonth;
                                                DataType dataType24 = dataType2;
                                                if (!(dataType23 != null ? !dataType23.equals(dataType24) : dataType24 != null)) {
                                                    object = YearMonth.parse(str.contains("-") ? str.substring(0, 4) + "-" + str.substring(4) : str);
                                                } else {
                                                    DataType dataType25 = DataType$.MonthDay;
                                                    DataType dataType26 = dataType2;
                                                    if (!(dataType25 != null ? !dataType25.equals(dataType26) : dataType26 != null)) {
                                                        object = MonthDay.parse(str.startsWith("--") ? "--" + str : str);
                                                    } else {
                                                        throw new RuntimeException("convert string to " + dataType + " is not supported");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public final Object org$beangle$data$transfer$excel$CellOps$$$convert$extension(Cell $this, double d, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        DataType dataType3 = DataType$.String;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            object = NumFormat.format(d);
        } else {
            DataType dataType5 = DataType$.Short;
            DataType dataType6 = dataType2;
            if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
                object = BoxesRunTime.boxToShort((short)Predef$.MODULE$.double2Double(d).shortValue());
            } else {
                DataType dataType7 = DataType$.Integer;
                DataType dataType8 = dataType2;
                if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
                    object = BoxesRunTime.boxToInteger((int)Predef$.MODULE$.double2Double(d).intValue());
                } else {
                    DataType dataType9 = DataType$.Long;
                    DataType dataType10 = dataType2;
                    if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
                        object = BoxesRunTime.boxToLong((long)Predef$.MODULE$.double2Double(d).longValue());
                    } else {
                        DataType dataType11 = DataType$.Float;
                        DataType dataType12 = dataType2;
                        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
                            object = BoxesRunTime.boxToFloat((float)Predef$.MODULE$.double2Double(d).floatValue());
                        } else {
                            DataType dataType13 = DataType$.Double;
                            DataType dataType14 = dataType2;
                            if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
                                object = BoxesRunTime.boxToDouble((double)d);
                            } else {
                                throw new RuntimeException("Cannot convert double to  " + dataType);
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public final Object org$beangle$data$transfer$excel$CellOps$$$convert$extension(Cell $this, java.util.Date d, DataType dataType) {
        Object object;
        DataType dataType2 = dataType;
        DataType dataType3 = DataType$.String;
        DataType dataType4 = dataType2;
        if (!(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null)) {
            object = new Date(d.getTime()).toLocalDate().toString();
        } else {
            DataType dataType5 = DataType$.Date;
            DataType dataType6 = dataType2;
            if (!(dataType5 != null ? !dataType5.equals(dataType6) : dataType6 != null)) {
                object = new Date(d.getTime()).toLocalDate();
            } else {
                DataType dataType7 = DataType$.DateTime;
                DataType dataType8 = dataType2;
                if (!(dataType7 != null ? !dataType7.equals(dataType8) : dataType8 != null)) {
                    object = d.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                } else {
                    DataType dataType9 = DataType$.Time;
                    DataType dataType10 = dataType2;
                    if (!(dataType9 != null ? !dataType9.equals(dataType10) : dataType10 != null)) {
                        object = d.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
                    } else {
                        DataType dataType11 = DataType$.YearMonth;
                        DataType dataType12 = dataType2;
                        if (!(dataType11 != null ? !dataType11.equals(dataType12) : dataType12 != null)) {
                            object = YearMonth.from(new Date(d.getTime()).toLocalDate());
                        } else {
                            DataType dataType13 = DataType$.MonthDay;
                            DataType dataType14 = dataType2;
                            if (!(dataType13 != null ? !dataType13.equals(dataType14) : dataType14 != null)) {
                                object = MonthDay.from(new Date(d.getTime()).toLocalDate());
                            } else {
                                throw new RuntimeException("Cannot convert date to  " + dataType);
                            }
                        }
                    }
                }
            }
        }
        return object;
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, Date d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)d);
        $this.setCellStyle(registry.get(DataType$.Date));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, java.util.Date d, ExcelStyleRegistry registry) {
        $this.setCellValue(d);
        $this.setCellStyle(registry.get(DataType$.DateTime));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, YearMonth d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)Date.valueOf(d.atDay(1)));
        $this.setCellStyle(registry.get(DataType$.YearMonth));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, Year d, ExcelStyleRegistry registry) {
        $this.setCellValue(Int$.MODULE$.int2double(d.getValue()));
        $this.setCellStyle(registry.get(DataType$.YearMonth));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, MonthDay d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)Date.valueOf(d.atYear(2000)));
        $this.setCellStyle(registry.get(DataType$.MonthDay));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, Time d, ExcelStyleRegistry registry) {
        $this.setCellValue((java.util.Date)d);
        $this.setCellStyle(registry.get(DataType$.Time));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, float d, ExcelStyleRegistry registry) {
        $this.setCellValue(Float$.MODULE$.float2double(d));
        $this.setCellStyle(registry.get(DataType$.Float));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, double d, ExcelStyleRegistry registry) {
        $this.setCellValue(d);
        $this.setCellStyle(registry.get(DataType$.Double));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, int d, ExcelStyleRegistry registry) {
        $this.setCellValue(Int$.MODULE$.int2double(d));
        $this.setCellStyle(registry.get(DataType$.Integer));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, String s, ExcelStyleRegistry registry) {
        $this.setCellValue((RichTextString)new XSSFRichTextString(s));
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fill$extension(Cell $this, boolean b, ExcelStyleRegistry registry) {
        $this.setCellValue(b ? "Y" : "N");
    }

    public final void org$beangle$data$transfer$excel$CellOps$$$fillBlank$extension(Cell $this) {
        $this.setBlank();
    }
}

