/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.ds;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.reflect.BeanInfos$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.jdbc.ds.DatasourceConfig;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.vendor.DriverInfo;
import org.beangle.data.jdbc.vendor.Vendors$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.xml.Node;
import scala.xml.XML$;

public final class DataSourceUtils$
implements Logging,
Serializable {
    private static Logger logger;
    public static final DataSourceUtils$ MODULE$;

    private DataSourceUtils$() {
    }

    static {
        MODULE$ = new DataSourceUtils$();
        Logging.$init$((Logging)MODULE$);
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DataSourceUtils$.class);
    }

    public DataSource build(String driver, String username, String password, Map<String, String> props) {
        return new HikariDataSource(new HikariConfig(this.buildProperties(driver, username, password, props)));
    }

    public void close(DataSource dataSource) {
        DataSource dataSource2 = dataSource;
        if (dataSource2 instanceof HikariDataSource) {
            HikariDataSource hikarids = (HikariDataSource)dataSource2;
            hikarids.close();
        } else {
            Method method = dataSource.getClass().getMethod("close", new Class[0]);
            if (method != null) {
                method.invoke((Object)dataSource, new Object[0]);
            } else {
                Logger$.MODULE$.info$extension(this.logger(), () -> this.close$$anonfun$1(dataSource));
            }
        }
    }

    private Properties buildProperties(String driver, String username, String password, Map<String, String> props) {
        Object object;
        Properties properties = new Properties();
        Set writables = BeanInfos$.MODULE$.get(HikariConfig.class).writables().keySet();
        props.foreach((Function1 & Serializable)e -> {
            Object key;
            Object object = e._1();
            String string = "url";
            Object object2 = !(object != null ? !object.equals(string) : string != null) ? "jdbcUrl" : (key = (String)e._1());
            if (!writables.contains(key)) {
                key = "dataSource." + (String)key;
            }
            return properties.put(key, e._2());
        });
        String string = driver;
        String string2 = "oracle";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (!properties.containsKey("jdbcUrl") && !props.contains((Object)"driverType")) {
                properties.put("dataSource.driverType", "thin");
            }
        }
        if (username != null) {
            properties.put("username", username);
        }
        if (password != null) {
            properties.put("password", password);
        }
        if (properties.containsKey("jdbcUrl")) {
            object = Class.forName(((DriverInfo)Vendors$.MODULE$.drivers().apply((Object)driver)).className());
        } else if (!properties.containsKey("dataSourceClassName")) {
            properties.put("dataSourceClassName", ((DriverInfo)Vendors$.MODULE$.drivers().apply((Object)driver)).dataSourceClassName());
            object = BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return properties;
    }

    public DatasourceConfig parseXml(InputStream is, String name) {
        ObjectRef conf = ObjectRef.create(null);
        XML$.MODULE$.load(is).$bslash$bslash("datasource").foreach((Function1)(JProcedure1 & Serializable)elem -> {
            DatasourceConfig one = this.parseXml((Node)elem);
            if (name != null) {
                String string = name;
                String string2 = one.name();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    DatasourceConfig datasourceConfig = one;
                    conf$1.elem = datasourceConfig;
                    datasourceConfig = null;
                }
            } else {
                DatasourceConfig datasourceConfig = one;
                conf$1.elem = datasourceConfig;
                datasourceConfig = null;
            }
        });
        return (DatasourceConfig)conf.elem;
    }

    public DatasourceConfig parseXml(Node xml) {
        DriverInfo d;
        Option option;
        DriverInfo driver = null;
        String url = xml.$bslash$bslash("url").text().trim();
        String driverName = xml.$bslash$bslash("driver").text().trim();
        if (Strings$.MODULE$.isEmpty((CharSequence)driverName) && Strings$.MODULE$.isNotEmpty((CharSequence)url)) {
            driverName = Strings$.MODULE$.substringBetween(url, "jdbc:", ":");
        }
        if (!((option = Vendors$.MODULE$.drivers().get((Object)driverName)) instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new RuntimeException("Not Supported:[" + driverName + "] supports:" + Vendors$.MODULE$.driverPrefixes());
            }
            throw new MatchError((Object)option);
        }
        driver = d = (DriverInfo)((Some)option).value();
        Engine engine = xml.$bslash("@engine").isEmpty() ? driver.vendor().engine() : (Engine)Reflections$.MODULE$.newInstance(xml.$bslash$bslash("engine").text().trim());
        DatasourceConfig dbconf = new DatasourceConfig(driverName, engine);
        if (Strings$.MODULE$.isNotEmpty((CharSequence)url)) {
            dbconf.props().put((Object)"url", (Object)url);
        }
        if (xml.$bslash("@name").nonEmpty()) {
            dbconf.name_$eq(xml.$bslash("@name").text().trim());
        }
        dbconf.user_$eq(xml.$bslash$bslash("user").text().trim());
        dbconf.password_$eq(xml.$bslash$bslash("password").text().trim());
        dbconf.catalog_$eq(engine.toIdentifier(xml.$bslash$bslash("catalog").text().trim()));
        String schemaName = xml.$bslash$bslash("schema").text().trim();
        if (Strings$.MODULE$.isEmpty((CharSequence)schemaName)) {
            String string = schemaName = engine.defaultSchema();
            String string2 = "$user";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                schemaName = dbconf.user();
            }
        }
        dbconf.schema_$eq(engine.toIdentifier(schemaName));
        xml.$bslash$bslash("props").$bslash$bslash("prop").foreach((Function1 & Serializable)ele -> dbconf.props().put((Object)ele.$bslash("@name").text(), (Object)ele.$bslash("@value").text()));
        Set processed = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"url", "driver", "props", "user", "password", "catalog", "schema"}));
        xml.$bslash("_").foreach((Function1)(JProcedure1 & Serializable)n -> {
            String label = n.label();
            if (!processed.contains((Object)label) && Strings$.MODULE$.isNotEmpty((CharSequence)n.text())) {
                dbconf.props().put((Object)label, (Object)n.text());
            }
        });
        return dbconf;
    }

    private final String close$$anonfun$1(DataSource dataSource$1) {
        return "Cannot find " + dataSource$1.getClass().getName() + "'s close method";
    }
}

