/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.text.i18n;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Charsets$;
import org.beangle.commons.lang.ClassLoaders$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.annotation.description;
import org.beangle.commons.text.i18n.DefaultTextBundle;
import org.beangle.commons.text.i18n.TextBundle;
import org.beangle.commons.text.i18n.TextBundleRegistry;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@description(value="\u7f3a\u7701TextBundle\u6ce8\u518c\u8868")
public class DefaultTextBundleRegistry
implements TextBundleRegistry {
    private final HashMap caches = new HashMap();
    private final ListBuffer defaultBundleNames = new ListBuffer();
    private boolean reloadable = false;

    public HashMap<Locale, ConcurrentHashMap<String, TextBundle>> caches() {
        return this.caches;
    }

    public ListBuffer<String> defaultBundleNames() {
        return this.defaultBundleNames;
    }

    @Override
    public boolean reloadable() {
        return this.reloadable;
    }

    @Override
    public void reloadable_$eq(boolean x$1) {
        this.reloadable = x$1;
    }

    @Override
    public void addDefaults(Seq<String> bundleNames) {
        this.defaultBundleNames().$plus$plus$eq(bundleNames);
    }

    @Override
    public TextBundle load(Locale locale, String bundleName) {
        ConcurrentHashMap localeBundles = (ConcurrentHashMap)this.caches().getOrElseUpdate((Object)locale, DefaultTextBundleRegistry::$anonfun$1);
        ObjectRef bundle = ObjectRef.create((Object)((TextBundle)localeBundles.get(bundleName)));
        if ((TextBundle)bundle.elem == null) {
            Option<TextBundle> option = this.loadJavaBundle(bundleName, locale);
            if (option instanceof Some) {
                TextBundle b;
                TextBundle textBundle = b = (TextBundle)((Some)option).value();
                bundle.elem = textBundle;
                textBundle = null;
            } else if (None$.MODULE$.equals(option)) {
                this.loadNewBundle(bundleName, locale).foreach((Function1 & Serializable)x$1 -> {
                    TextBundle textBundle;
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        TextBundle nested = (TextBundle)tuple2._2();
                        String string = name;
                        String string2 = bundleName;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            TextBundle textBundle2 = nested;
                            bundle$1.elem = textBundle2;
                            textBundle2 = null;
                            textBundle = BoxedUnit.UNIT;
                        } else {
                            textBundle = localeBundles.put(name, nested);
                        }
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    return textBundle;
                });
            } else {
                throw new MatchError(option);
            }
            localeBundles.put(bundleName, (TextBundle)bundle.elem);
        }
        if (this.reloadable()) {
            this.caches().clear();
        }
        return (TextBundle)bundle.elem;
    }

    public Map<String, TextBundle> loadNewBundle(String bname, Locale locale) {
        Map map;
        None$ url;
        None$ none$;
        ObjectRef bundleName = ObjectRef.create((Object)bname);
        ObjectRef resource = ObjectRef.create((Object)this.toDefaultResourceName((String)bundleName.elem, locale));
        Option option = ClassLoaders$.MODULE$.getResource((String)resource.elem, ClassLoaders$.MODULE$.getResource$default$2());
        if (None$.MODULE$.equals(option)) {
            String className = Strings$.MODULE$.substringAfterLast((String)bundleName.elem, ".");
            if (className.length() > 0 && Character.isUpperCase(className.charAt(0))) {
                Object object;
                bundleName.elem = object = Strings$.MODULE$.substringBeforeLast((String)bundleName.elem, ".") + ".package";
                object = null;
                String string = this.toDefaultResourceName((String)bundleName.elem, locale);
                resource.elem = string;
                string = null;
                none$ = ClassLoaders$.MODULE$.getResource((String)resource.elem, ClassLoaders$.MODULE$.getResource$default$2());
            } else {
                none$ = None$.MODULE$;
            }
        } else if (option instanceof Some) {
            Some some = (Some)option;
            URL u = (URL)some.value();
            Some url2 = some;
            none$ = url2;
        } else {
            throw new MatchError((Object)option);
        }
        None$ none$2 = url = none$;
        if (None$.MODULE$.equals(none$2)) {
            DefaultTextBundle defaultBundle = new DefaultTextBundle(locale, (String)resource.elem, (Map<String, String>)Predef$.MODULE$.Map().empty());
            String string = (String)bundleName.elem;
            String string2 = bname;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Object[] objectArray = new Tuple2[1];
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)((String)bundleName.elem));
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)defaultBundle);
                map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            } else {
                Object[] objectArray = new Tuple2[2];
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)((String)bundleName.elem));
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)defaultBundle);
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)bname);
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)defaultBundle);
                map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            }
        } else if (none$2 instanceof Some) {
            URL url3 = (URL)((Some)none$2).value();
            String prefix = Strings$.MODULE$.substringBeforeLast((String)bundleName.elem, ".") + ".";
            Map bundles = (Map)this.readBundles(url3.openStream(), this.readBundles$default$2()).map((Function1 & Serializable)x$1 -> {
                Map values;
                String name;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    name = (String)tuple2._1();
                    values = (Map)tuple2._2();
                } else {
                    throw new MatchError((Object)tuple2);
                }
                return name.length() == 0 ? Tuple2$.MODULE$.apply((Object)((String)bundleName$2.elem), (Object)new DefaultTextBundle(locale, (String)resource$1.elem, (Map<String, String>)values)) : Tuple2$.MODULE$.apply((Object)(prefix + name), (Object)new DefaultTextBundle(locale, (String)resource$1.elem, (Map<String, String>)values));
            });
            if (bundles.contains((Object)bname)) {
                map = bundles;
            } else {
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)bname);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new DefaultTextBundle(locale, (String)resource.elem, (Map<String, String>)Predef$.MODULE$.Map().empty()));
                map = (Map)bundles.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
        } else {
            throw new MatchError((Object)none$2);
        }
        return map;
    }

    public Option<TextBundle> loadJavaBundle(String bundleName, Locale locale) {
        None$ none$;
        String resource = this.toJavaResourceName(bundleName, locale);
        Option option = ClassLoaders$.MODULE$.getResource(resource, ClassLoaders$.MODULE$.getResource$default$2());
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            URL r = (URL)((Some)option).value();
            none$ = Some$.MODULE$.apply((Object)new DefaultTextBundle(locale, resource, (Map<String, String>)IOs$.MODULE$.readJavaProperties(r)));
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    public String toJavaResourceName(String bundleName, Locale locale) {
        Object fullName = bundleName;
        String localeName = this.toLocaleStr(locale);
        String suffix = "properties";
        if (!"".equals(localeName)) {
            fullName = (String)fullName + "_" + localeName;
        }
        StringBuilder sb = new StringBuilder(((String)fullName).length() + 1 + suffix.length());
        sb.append(((String)fullName).replace('.', '/')).append('.').append(suffix);
        return sb.toString();
    }

    public String toDefaultResourceName(String bundleName, Locale locale) {
        String localeName;
        String fullName = bundleName;
        String suffix = localeName = this.toLocaleStr(locale);
        StringBuilder sb = new StringBuilder(fullName.length() + 1 + suffix.length());
        sb.append(fullName.replace('.', '/'));
        if (!"".equals(suffix)) {
            sb.append('.').append(suffix);
        }
        return sb.toString();
    }

    public String toLocaleStr(Locale locale) {
        StringBuilder stringBuilder;
        Locale locale2 = locale;
        Locale locale3 = Locale.ROOT;
        if (!(locale2 != null ? !((Object)locale2).equals(locale3) : locale3 != null)) {
            return "";
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String string = language;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = country;
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String string5 = variant;
                String string6 = "";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    return "";
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        String string7 = variant;
        String string8 = "";
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            stringBuilder = sb.append(language).append('_').append(country).append('_').append(variant);
        } else {
            String string9 = country;
            String string10 = "";
            stringBuilder = (string9 == null ? string10 != null : !string9.equals(string10)) ? sb.append(language).append('_').append(country) : sb.append(language);
        }
        return sb.toString();
    }

    @Override
    public List<TextBundle> getBundles(Locale locale) {
        List list;
        Option option = this.caches().get((Object)locale);
        if (option instanceof Some) {
            ConcurrentHashMap map = (ConcurrentHashMap)((Some)option).value();
            list = CollectionConverters$.MODULE$.CollectionHasAsScala(map.values()).asScala().toList();
        } else if (None$.MODULE$.equals(option)) {
            list = package$.MODULE$.List().empty();
        } else {
            throw new MatchError((Object)option);
        }
        return list;
    }

    @Override
    public Option<String> getDefaultText(String key, Locale locale) {
        ObjectRef msg = ObjectRef.create((Object)None$.MODULE$);
        this.defaultBundleNames().find((Function1 & Serializable)bundleName -> {
            Option option;
            TextBundle bundle = this.load(locale, (String)bundleName);
            msg$1.elem = option = bundle.get(key);
            option = null;
            return !None$.MODULE$.equals((Option)msg$1.elem);
        });
        return (Option)msg.elem;
    }

    public Map<String, Map<String, String>> readBundles(InputStream input, Charset charset) {
        Map map;
        if (input == null) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            String defaults = "";
            HashMap texts = new HashMap();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(input, charset));
            String line = reader.readLine();
            while (line != null) {
                int index = line.indexOf(61);
                if (index > 0 && index != line.length() - 1) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (Character.isUpperCase(key.charAt(0))) {
                        int dotIdx = key.indexOf(46);
                        if (-1 == dotIdx) {
                            ((HashMap)texts.getOrElseUpdate((Object)defaults, DefaultTextBundleRegistry::readBundles$$anonfun$1)).put((Object)key, (Object)value);
                        } else {
                            ((HashMap)texts.getOrElseUpdate((Object)key.substring(0, dotIdx), DefaultTextBundleRegistry::readBundles$$anonfun$2)).put((Object)key.substring(dotIdx + 1), (Object)value);
                        }
                    } else {
                        ((HashMap)texts.getOrElseUpdate((Object)defaults, DefaultTextBundleRegistry::readBundles$$anonfun$3)).put((Object)key, (Object)value);
                    }
                }
                line = reader.readLine();
            }
            if (!texts.contains((Object)defaults)) {
                texts.put((Object)defaults, (Object)HashMap$.MODULE$.empty());
            }
            HashMap results = (HashMap)texts.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                HashMap values = (HashMap)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)name, (Object)values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            });
            map = results.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return map;
    }

    public Charset readBundles$default$2() {
        return Charsets$.MODULE$.UTF_8();
    }

    private static final ConcurrentHashMap $anonfun$1() {
        return new ConcurrentHashMap();
    }

    private static final HashMap readBundles$$anonfun$1() {
        return new HashMap();
    }

    private static final HashMap readBundles$$anonfun$2() {
        return new HashMap();
    }

    private static final HashMap readBundles$$anonfun$3() {
        return new HashMap();
    }
}

