/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.basepom.inline.mojo.ArtifactIdentifier;
import org.basepom.inline.mojo.DependencyBuilder;
import org.basepom.inline.mojo.InlineDependency;
import org.basepom.inline.mojo.PluginLog;
import org.basepom.inline.mojo.PomUtil;
import org.basepom.inline.mojo.ScopeLimitingFilter;
import org.basepom.inline.transformer.ClassPath;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarTransformer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.graph.Dependency;
import org.jdom2.JDOMException;

@Mojo(name="inline", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class InlineMojo
extends AbstractMojo {
    private static final PluginLog LOG = new PluginLog(InlineMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    public MavenSession mavenSession;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    public List<MavenProject> reactorProjects;
    @Component
    public ProjectBuilder mavenProjectBuilder;
    @Component
    public ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    public RepositorySystem repositorySystem;
    @Component
    public MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}")
    public File outputDirectory = null;
    @Parameter(property="inline.pomFile", defaultValue="${project.file}")
    public File pomFile = null;
    @Parameter
    private List<InlineDependency> inlineDependencies = ImmutableList.of();
    @Parameter
    private List<ArtifactIdentifier> includes = ImmutableList.of();
    @Parameter
    private List<ArtifactIdentifier> excludes = ImmutableList.of();
    @Parameter(defaultValue="true", property="inline.hide-classes")
    public boolean hideClasses = true;
    @Parameter(defaultValue="false", property="inline.skip")
    public boolean skip = false;
    @Parameter(defaultValue="false", property="inline.quiet")
    public boolean quiet = false;
    @Parameter(required=true, property="inline.prefix")
    public String prefix = null;
    @Parameter(defaultValue="true", property="inline.requireProvided")
    public boolean requireProvided = true;
    @Parameter(defaultValue="true", property="inline.requireOptional")
    public boolean requireOptional = true;
    @Parameter(defaultValue="true", property="inline.failOnNoMatch")
    public boolean failOnNoMatch = true;
    @Parameter
    public File outputJarFile = null;
    @Parameter
    public File outputPomFile = null;
    @Parameter(defaultValue="false", property="inline.attachArtifact")
    public boolean inlinedArtifactAttached = false;
    @Parameter(defaultValue="true", property="inline.replacePomFile")
    public boolean replacePomFile = true;
    @Parameter(defaultValue="inlined")
    public String inlinedClassifierName = "inlined";

    public void setInlineDependencies(List<InlineDependency> inlineDependencies) {
        this.inlineDependencies = ImmutableList.copyOf(inlineDependencies);
    }

    public void setIncludes(List<ArtifactIdentifier> includes) {
        this.includes = ImmutableList.copyOf(includes);
    }

    public void setExcludes(List<ArtifactIdentifier> excludes) {
        this.excludes = ImmutableList.copyOf(excludes);
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            LOG.report(this.quiet, "skipping plugin execution", new Object[0]);
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            LOG.report(this.quiet, "ignoring POM project", new Object[0]);
            return;
        }
        if (this.project.getArtifact().getFile() == null) {
            throw new MojoExecutionException("No project artifact found!");
        }
        try {
            ImmutableSetMultimap.Builder dependencyBuilder = ImmutableSetMultimap.builder();
            ImmutableSet.Builder pomDependenciesToAdd = ImmutableSet.builder();
            this.computeDependencyMap((ImmutableSetMultimap.Builder<InlineDependency, Dependency>)dependencyBuilder, (ImmutableSet.Builder<Dependency>)pomDependenciesToAdd);
            ImmutableSetMultimap dependencyMap = dependencyBuilder.build();
            this.rewriteJarFile((ImmutableSetMultimap<InlineDependency, Dependency>)dependencyMap);
            this.rewritePomFile((Set<Dependency>)pomDependenciesToAdd.build(), (Set<Dependency>)ImmutableSet.copyOf((Collection)dependencyMap.values()));
        }
        catch (UncheckedIOException e) {
            throw new MojoExecutionException((Throwable)e.getCause());
        }
        catch (IOException | XMLStreamException | DependencyResolutionException | ProjectBuildingException | JDOMException e) {
            throw new MojoExecutionException(e);
        }
    }

    private void computeDependencyMap(ImmutableSetMultimap.Builder<InlineDependency, Dependency> dependencyMapBuilder, ImmutableSet.Builder<Dependency> pomBuilder) throws DependencyResolutionException, ProjectBuildingException {
        DependencyBuilder dependencyBuilder = new DependencyBuilder(this.project, this.mavenSession, this.mavenProjectBuilder, this.projectDependenciesResolver, this.reactorProjects);
        ImmutableSet directArtifacts = (ImmutableSet)this.project.getDependencyArtifacts().stream().map(ArtifactIdentifier::new).collect(ImmutableSet.toImmutableSet());
        ImmutableList<Dependency> directDependencies = dependencyBuilder.mapProject(this.project, (node, parents) -> directArtifacts.contains((Object)new ArtifactIdentifier(node)));
        ImmutableList<Dependency> projectDependencies = dependencyBuilder.mapProject(this.project, ScopeLimitingFilter.computeDependencyScope("compile+runtime"));
        Map dependencyScopes = (Map)projectDependencies.stream().filter(dependency -> dependency.getArtifact() != null).collect(ImmutableMap.toImmutableMap(this::getId, (Function)Functions.identity()));
        BiConsumer<InlineDependency, Dependency> dependencyConsumer = (inlineDependency, dependency) -> {
            LOG.debug("%s matches %s for inlining.", inlineDependency, dependency);
            dependencyMapBuilder.put(inlineDependency, dependency);
        };
        ImmutableSet.Builder directExcludes = ImmutableSet.builder();
        block0: for (Dependency dependencyArtifact : directDependencies) {
            for (InlineDependency inlineDependency2 : this.inlineDependencies) {
                if (!inlineDependency2.matchDependency(dependencyArtifact)) continue;
                dependencyConsumer.accept(inlineDependency2, dependencyArtifact);
                LOG.report(this.quiet, "Inlining direct dependency %s (matched %s)", dependencyArtifact, inlineDependency2);
                continue block0;
            }
            directExcludes.add((Object)dependencyArtifact);
        }
        Set excludes = directExcludes.build().stream().map(ArtifactIdentifier::new).collect(Collectors.toUnmodifiableSet());
        this.excludes = ImmutableList.copyOf((Iterable)Iterables.concat(this.excludes, excludes));
        LOG.debug("Excludes after creating includes: %s", this.excludes);
        ImmutableMap directDependencyMap = dependencyMapBuilder.build().asMap();
        for (Map.Entry dependencyEntry : directDependencyMap.entrySet()) {
            InlineDependency inlineDependency3 = (InlineDependency)dependencyEntry.getKey();
            for (Dependency projectDependency : (Collection)dependencyEntry.getValue()) {
                Consumer<Dependency> consumer = inlineDependency3.isInlineTransitive() ? dependency -> {
                    if ("runtime".equals(dependency.getScope())) {
                        pomBuilder.add(dependency);
                    } else {
                        dependencyConsumer.accept(inlineDependency3, (Dependency)dependency);
                        LOG.report(this.quiet, "Inlining transitive dependency %s (matched %s)", dependency, inlineDependency3);
                    }
                } : arg_0 -> pomBuilder.add(arg_0);
                dependencyBuilder.mapDependency(projectDependency, ScopeLimitingFilter.computeTransitiveScope(projectDependency.getScope())).stream().map(dependency -> dependencyScopes.getOrDefault(this.getId((Dependency)dependency), dependency)).filter(this.createFilterSet()).filter(dependency -> this.isIncluded(inlineDependency3, (Dependency)dependency)).forEach(consumer);
            }
        }
        LOG.debug("Done!", new Object[0]);
    }

    private String getId(Dependency dependency) {
        org.eclipse.aether.artifact.Artifact artifact = dependency.getArtifact();
        Preconditions.checkState((artifact != null ? 1 : 0) != 0, (String)"Artifact for dependency %s is null!", (Object)dependency);
        return Joiner.on((char)':').join((Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), new Object[]{artifact.getClassifier()});
    }

    private Predicate<Dependency> createFilterSet() {
        Predicate<Dependency> predicate = dependency -> !"system".equals(dependency.getScope());
        if (this.requireProvided) {
            predicate = predicate.and(dependency -> "provided".equals(dependency.getScope()));
        }
        if (this.requireOptional) {
            predicate = predicate.and(Dependency::isOptional);
        }
        return predicate;
    }

    private void rewriteJarFile(ImmutableSetMultimap<InlineDependency, Dependency> dependencies) throws IOException {
        File outputJar = this.outputJarFile != null ? this.outputJarFile : this.inlinedArtifactFileWithClassifier();
        this.doJarTransformation(outputJar, dependencies);
        if (this.outputJarFile == null) {
            if (this.inlinedArtifactAttached) {
                LOG.info("Attaching inlined artifact.", new Object[0]);
                this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.inlinedClassifierName, outputJar);
            } else {
                LOG.info("Replacing original artifact with inlined artifact.", new Object[0]);
                File originalArtifact = this.project.getArtifact().getFile();
                if (originalArtifact != null) {
                    File backupFile = new File(originalArtifact.getParentFile(), "original-" + originalArtifact.getName());
                    Files.move(originalArtifact.toPath(), backupFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    Files.move(outputJar.toPath(), originalArtifact.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }

    private void rewritePomFile(Set<Dependency> dependenciesToAdd, Set<Dependency> dependenciesToRemove) throws IOException, XMLStreamException, JDOMException {
        String pomContents;
        try (FileReader reader = new FileReader(this.project.getFile(), StandardCharsets.UTF_8);){
            pomContents = CharStreams.toString((Readable)reader);
        }
        PomUtil pomUtil = new PomUtil(pomContents);
        dependenciesToRemove.forEach(pomUtil::removeDependency);
        dependenciesToAdd.forEach(pomUtil::addDependency);
        Object pomName = this.pomFile.getName();
        pomName = "new-" + (String)(((String)pomName).startsWith(".") ? ((String)pomName).substring(1) : pomName);
        File newPomFile = this.outputPomFile != null ? this.outputPomFile : new File(this.outputDirectory, (String)pomName);
        try (FileWriter writer = new FileWriter(newPomFile, StandardCharsets.UTF_8);){
            pomUtil.writePom(writer);
        }
        if (this.replacePomFile) {
            this.project.setPomFile(newPomFile);
        }
    }

    private void doJarTransformation(File outputJar, ImmutableSetMultimap<InlineDependency, Dependency> dependencies) throws IOException {
        try (JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(outputJar));){
            Consumer<ClassPathResource> jarConsumer = this.getJarWriter(jarOutputStream);
            JarTransformer transformer = new JarTransformer(jarConsumer);
            ClassPath classPath = new ClassPath(this.project.getBasedir());
            Artifact artifact = this.project.getArtifact();
            classPath.addFile(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), new ClassPathTag[]{ClassPathTag.ROOT_JAR});
            dependencies.forEach((inlineDependency, dependency) -> {
                org.eclipse.aether.artifact.Artifact dependencyArtifact = dependency.getArtifact();
                Preconditions.checkState((dependencyArtifact.getFile() != null ? 1 : 0) != 0, (String)"Could not locate artifact file for %s", (Object)dependencyArtifact);
                classPath.addFile(dependencyArtifact.getFile(), this.prefix, dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId(), this.hideClasses, new ClassPathTag[0]);
            });
            transformer.transform(classPath);
        }
    }

    private Consumer<ClassPathResource> getJarWriter(JarOutputStream jarOutputStream) {
        return classPathResource -> {
            try {
                String name = classPathResource.getName();
                LOG.debug(String.format("Writing '%s' to jar", name), new Object[0]);
                JarEntry outputEntry = new JarEntry(name);
                outputEntry.setTime(classPathResource.getLastModifiedTime());
                outputEntry.setCompressedSize(-1L);
                jarOutputStream.putNextEntry(outputEntry);
                jarOutputStream.write(classPathResource.getContent());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private File inlinedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String inlineName = String.format("%s-%s-%s.%s", this.project.getArtifactId(), artifact.getVersion(), this.inlinedClassifierName, artifact.getArtifactHandler().getExtension());
        return new File(this.outputDirectory, inlineName);
    }

    public boolean isIncluded(InlineDependency inlineDependency, Dependency dependency) {
        if (dependency.isOptional() && !inlineDependency.isInlineOptionals()) {
            return false;
        }
        boolean included = this.includes.stream().map(artifactIdentifier -> artifactIdentifier.matchDependency(dependency)).findFirst().orElse(this.includes.isEmpty());
        boolean excluded = this.excludes.stream().map(artifactIdentifier -> artifactIdentifier.matchDependency(dependency)).findFirst().orElse(false);
        return included && !excluded;
    }
}

