/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.input.StAXStreamBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

final class PomUtil {
    private final String pomText;
    private final Document pomDocument;

    PomUtil(String pomText) throws XMLStreamException, JDOMException {
        this.pomText = pomText;
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new StringReader(pomText));
        StAXStreamBuilder builder = new StAXStreamBuilder();
        this.pomDocument = builder.build(reader);
    }

    void writePom(OutputStreamWriter writer) throws IOException {
        if (this.pomDocument.getContentSize() > 1 && this.pomDocument.getContent(0).getCType() == Content.CType.Comment && this.pomDocument.getContent(1).getCType() == Content.CType.Element) {
            this.pomDocument.addContent(1, (Content)new Text("\n"));
        }
        XMLOutputter xml = new XMLOutputter();
        xml.setFormat(Format.getPrettyFormat().setLineSeparator(LineSeparator.SYSTEM));
        xml.output(this.pomDocument, (Writer)writer);
    }

    void removeDependency(Dependency dependency) {
        Namespace pomNs = Namespace.getNamespace((String)"pom", (String)this.pomDocument.getRootElement().getNamespaceURI());
        XPathFactory xpathFactory = XPathFactory.instance();
        Artifact artifact = dependency.getArtifact();
        String xpathExpression = Strings.emptyToNull((String)artifact.getClassifier()) == null ? String.format("//pom:dependencies/pom:dependency[pom:artifactId[text() = '%s'] and pom:groupId[text() = '%s'] and not(pom:classifier) ]", artifact.getArtifactId(), artifact.getGroupId()) : String.format("//pom:dependencies/pom:dependency[pom:artifactId[text() = '%s'] and pom:groupId[text() = '%s'] and pom:classifier[text() = '%s']]", artifact.getArtifactId(), artifact.getGroupId(), artifact.getClassifier());
        XPathExpression dependencies = xpathFactory.compile(xpathExpression, Filters.content(), null, new Namespace[]{pomNs});
        List contents = dependencies.evaluate((Object)this.pomDocument.getRootElement());
        for (Content content : contents) {
            content.getParentElement().removeContent(content);
        }
    }

    void addDependency(Dependency dependency) {
        Namespace pomNs = Namespace.getNamespace((String)"pom", (String)this.pomDocument.getRootElement().getNamespaceURI());
        XPathFactory xpathFactory = XPathFactory.instance();
        XPathExpression dependencies = xpathFactory.compile("/pom:project/pom:dependencies", Filters.content(), null, new Namespace[]{pomNs});
        Content content = (Content)Iterables.getOnlyElement((Iterable)dependencies.evaluate((Object)this.pomDocument.getRootElement()));
        Namespace newNs = this.pomDocument.getRootElement().getNamespace();
        Element dependencyElement = new Element("dependency", newNs);
        dependencyElement.addContent((Content)new Element("groupId", newNs).addContent(dependency.getArtifact().getGroupId()));
        dependencyElement.addContent((Content)new Element("artifactId", newNs).addContent(dependency.getArtifact().getArtifactId()));
        dependencyElement.addContent((Content)new Element("version", newNs).addContent(dependency.getArtifact().getVersion()));
        String scope = dependency.getScope();
        if (Strings.emptyToNull((String)scope) != null && !"compile".equals(scope)) {
            dependencyElement.addContent((Content)new Element("scope", newNs).addContent(scope));
        }
        if (dependency.isOptional()) {
            dependencyElement.addContent((Content)new Element("optional", newNs).addContent("true"));
        }
        ((Element)content).addContent((Content)dependencyElement);
    }
}

