/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.mojo.dependencyscope;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.basepom.mojo.dependencyscope.DependencyViolation;
import org.basepom.mojo.dependencyscope.TraversalContext;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class DependencyScopeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    public MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    public RepositorySystemSession repositorySystemSession;
    @Parameter(property="useParallelDependencyResolution", defaultValue="true")
    public boolean useParallelDependencyResolution;
    @Parameter(defaultValue="false")
    public boolean linkToDocumentation;
    @Parameter(defaultValue="false")
    public boolean fail;
    @Parameter(defaultValue="false")
    public boolean skip;
    @Parameter(property="verbose", defaultValue="true")
    public boolean verbose;
    @Component
    public RepositorySystem repositorySystem;
    @Component
    public DependencyGraphBuilder dependencyGraphBuilder;
    private ListeningExecutorService executorService;
    private Set<String> checkedArtifacts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.executorService = this.newExecutorService();
        this.checkedArtifacts = Sets.newConcurrentHashSet();
        DependencyNode node = this.buildDependencyNode();
        TraversalContext context = TraversalContext.newContextFor(this.project, node);
        ArrayList<ListenableFuture<Set<DependencyViolation>>> futures = new ArrayList<ListenableFuture<Set<DependencyViolation>>>();
        for (DependencyNode dependency : node.getChildren()) {
            if ("test".equals(dependency.getArtifact().getScope())) continue;
            TraversalContext subcontext = context.stepInto(this.project, dependency);
            futures.add(this.findViolations(subcontext));
        }
        Set<DependencyViolation> violations = DependencyScopeMojo.resolve((ListenableFuture<List<Set<DependencyViolation>>>)Futures.allAsList(futures));
        this.executorService.shutdown();
        if (!violations.isEmpty()) {
            this.printViolations(violations);
            if (this.fail) {
                throw new MojoFailureException("Test dependency scope issues found");
            }
        } else {
            this.getLog().info((CharSequence)"No test dependency scope issues found");
        }
    }

    private ListenableFuture<Set<DependencyViolation>> findViolations(final TraversalContext context) {
        final SettableFuture future = SettableFuture.create();
        if (!this.checkedArtifacts.add(context.currentArtifact().getId())) {
            future.set((Object)ImmutableSet.of());
            return future;
        }
        Futures.addCallback(this.resolveArtifactDescriptor(context.currentArtifact()), (FutureCallback)new FutureCallback<ArtifactDescriptorResult>(){

            public void onSuccess(ArtifactDescriptorResult artifactDescriptor) {
                if (artifactDescriptor == null) {
                    this.onFailure(new NullPointerException("artifactDescriptor"));
                    return;
                }
                try {
                    Set runtimeDependencies = (Set)artifactDescriptor.getDependencies().stream().filter(x$0 -> DependencyScopeMojo.dependencyRequiredAtRuntime(x$0)).filter(dependency -> !context.isExcluded((Dependency)dependency)).collect(ImmutableSet.toImmutableSet());
                    if (runtimeDependencies.isEmpty()) {
                        future.set((Object)ImmutableSet.of());
                        return;
                    }
                    TraversalContext temp = context;
                    TraversalContext context2 = temp.extendManagedDependencyExclusions(artifactDescriptor.getDependencies());
                    final Set violations = Sets.newConcurrentHashSet();
                    final CountDownLatch latch = new CountDownLatch(runtimeDependencies.size());
                    for (Dependency dependency2 : runtimeDependencies) {
                        Optional<TraversalContext> subcontext;
                        if (context2.isOverriddenToTestScope(dependency2)) {
                            violations.add(new DependencyViolation(context2, dependency2));
                        }
                        if ((subcontext = context2.stepInto(dependency2)).isEmpty()) {
                            DependencyScopeMojo.this.getLog().warn((CharSequence)("Could not find project version for dependency " + dependency2 + ". This is probably a bug in the plugin"));
                        }
                        ListenableFuture subfuture = subcontext.map(traversalContext -> DependencyScopeMojo.this.findViolations((TraversalContext)traversalContext)).orElseGet(() -> Futures.immediateFuture((Object)ImmutableSet.of()));
                        Futures.addCallback((ListenableFuture)subfuture, (FutureCallback)new FutureCallback<Set<DependencyViolation>>(){

                            public void onSuccess(Set<DependencyViolation> result) {
                                try {
                                    violations.addAll(result);
                                }
                                finally {
                                    latch.countDown();
                                    if (latch.getCount() == 0L) {
                                        future.set((Object)violations);
                                    }
                                }
                            }

                            public void onFailure(Throwable t) {
                                future.setException(t);
                            }
                        }, (Executor)MoreExecutors.directExecutor());
                    }
                }
                catch (Exception e) {
                    future.setException((Throwable)e);
                }
            }

            public void onFailure(Throwable t) {
                future.setException(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    private DependencyNode buildDependencyNode() throws MojoExecutionException {
        try {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setProject(this.project);
            return this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, artifact -> !"provided".equals(artifact.getScope()) && !"system".equals(artifact.getScope()));
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Error building dependency graph", (Exception)((Object)e));
        }
    }

    private ListenableFuture<ArtifactDescriptorResult> resolveArtifactDescriptor(Artifact artifact) {
        return this.executorService.submit(() -> {
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(DependencyScopeMojo.toAether(artifact), this.project.getRemoteProjectRepositories(), null);
            try {
                return this.repositorySystem.readArtifactDescriptor(this.repositorySystemSession, request);
            }
            catch (ArtifactDescriptorException e) {
                String message = "Error resolving descriptor for artifact " + DependencyScopeMojo.asString(artifact);
                throw new MojoExecutionException(message, (Exception)((Object)e));
            }
        });
    }

    private void printViolations(Set<DependencyViolation> violations) {
        HashMap<String, TreeSet<DependencyViolation>> violationsByDependency = new HashMap<String, TreeSet<DependencyViolation>>();
        for (DependencyViolation violation : violations) {
            String key = DependencyScopeMojo.readableGATC(violation.getDependency());
            if (!violationsByDependency.containsKey(key)) {
                violationsByDependency.put(key, new TreeSet<DependencyViolation>(DependencyScopeMojo.artifactNameComparator()));
            }
            ((Set)violationsByDependency.get(key)).add(violation);
        }
        Consumer<String> logger = this.fail ? arg_0 -> ((Log)this.getLog()).error(arg_0) : arg_0 -> ((Log)this.getLog()).warn(arg_0);
        for (Map.Entry dependencyViolation : violationsByDependency.entrySet()) {
            logger.accept("Found a problem with test-scoped dependency " + (String)dependencyViolation.getKey());
            for (DependencyViolation violation : (Set)dependencyViolation.getValue()) {
                logger.accept("Scope " + violation.getDependency().getScope() + " was expected by artifact " + DependencyScopeMojo.asString(violation.getSource().currentArtifact()));
                if (!this.verbose) continue;
                logger.accept("");
                logger.accept("Dependency chain:");
                StringBuilder prefix = new StringBuilder();
                boolean first = true;
                for (String artifact : violation.getPath()) {
                    if (first) {
                        logger.accept(artifact);
                        first = false;
                        continue;
                    }
                    logger.accept(prefix + "\\- " + artifact);
                    prefix.append("   ");
                }
            }
        }
        if (this.linkToDocumentation) {
            this.getLog().info((CharSequence)"For information on how to fix these issues, see here:");
            this.getLog().info((CharSequence)"https://github.com/HubSpot/dependency-scope-maven-plugin#how-to-fix-issues");
        }
    }

    private ListeningExecutorService newExecutorService() {
        if (this.useParallelDependencyResolution) {
            this.getLog().debug((CharSequence)"Using parallel dependency resolution");
            return MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(Math.min(Runtime.getRuntime().availableProcessors() * 5, 20), new ThreadFactoryBuilder().setNameFormat("dependency-project-builder-%s").setDaemon(true).build()));
        }
        this.getLog().debug((CharSequence)"Using single-threaded dependency resolution");
        return MoreExecutors.newDirectExecutorService();
    }

    private static boolean dependencyRequiredAtRuntime(Dependency dependency) {
        if (dependency.isOptional()) {
            return false;
        }
        String scope = dependency.getScope();
        return "compile".equals(scope) || "runtime".equals(scope);
    }

    private static Set<DependencyViolation> resolve(ListenableFuture<List<Set<DependencyViolation>>> future) throws MojoExecutionException {
        try {
            return Sets.newHashSet((Iterable)Iterables.concat((Iterable)((Iterable)future.get())));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("Interrupted while checking dependency scopes", (Exception)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), MojoExecutionException.class);
            }
            throw new MojoExecutionException("Error while checking dependency scopes", (Exception)e);
        }
    }

    private static Comparator<DependencyViolation> artifactNameComparator() {
        return Comparator.comparing(violation -> DependencyScopeMojo.asString(violation.getSource().currentArtifact()));
    }

    private static String readableGATC(Dependency dependency) {
        org.eclipse.aether.artifact.Artifact artifact = dependency.getArtifact();
        String name = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (!"jar".equals(artifact.getExtension())) {
            name = name + ":" + artifact.getExtension();
        }
        if (!artifact.getClassifier().isEmpty()) {
            name = name + ":" + artifact.getClassifier();
        }
        return name;
    }

    private static String asString(Artifact artifact) {
        String name = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (artifact.getType() != null && !"jar".equals(artifact.getType())) {
            name = name + ":" + artifact.getType();
        }
        if (artifact.getClassifier() != null) {
            name = name + ":" + artifact.getClassifier();
        }
        artifact.isSnapshot();
        name = name + ":" + artifact.getBaseVersion();
        return name;
    }

    private static org.eclipse.aether.artifact.Artifact toAether(Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion(), null, artifact.getFile());
    }
}

