/*
 * Decompiled with CFR 0.152.
 */
package org.barfuin.texttree.internal;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.barfuin.texttree.api.TreeOptions;
import org.barfuin.texttree.api.color.NodeColor;
import org.barfuin.texttree.internal.TreeElementType;
import org.fusesource.jansi.Ansi;

public class ColorizableAppender {
    private final TreeOptions options;
    private final StringBuilder sb = new StringBuilder();
    private final Ansi ansi = Ansi.ansi((StringBuilder)this.sb);
    private boolean colorWasUsed = false;
    private NodeColor latestColorUsed = NodeColor.None;
    private int currentLineLength = 0;

    public ColorizableAppender(TreeOptions pTreeOptions) {
        this.options = Objects.requireNonNull(pTreeOptions, "tree options must not be null");
    }

    public void appendText(@Nullable String pNodeText, @Nullable NodeColor pColorOverride) {
        this.append(TreeElementType.Text, pNodeText, pColorOverride);
    }

    public void append(@Nonnull TreeElementType pElementType, @Nonnull String pString) {
        this.append(pElementType, pString, null);
    }

    public void append(@Nonnull TreeElementType pElementType, @Nullable String pString, @Nullable NodeColor pColorOverride) {
        if (!"".equals(pString)) {
            NodeColor effectiveColor;
            NodeColor nodeColor = effectiveColor = pColorOverride != null ? pColorOverride : this.getColorFromScheme(pElementType);
            if (!this.colorWasUsed && effectiveColor == NodeColor.None) {
                this.sb.append(pString);
            } else {
                this.emitColor(effectiveColor).a(pString);
                this.colorWasUsed = true;
            }
            this.currentLineLength += pString != null ? pString.length() : "null".length();
        }
    }

    @Nonnull
    private NodeColor getColorFromScheme(@Nonnull TreeElementType pElementType) {
        NodeColor result;
        switch (pElementType) {
            case Edge: {
                result = this.options.getColorScheme().getEdgeColor();
                break;
            }
            case Text: {
                result = this.options.getColorScheme().getTextColor();
                break;
            }
            case CalloutError: {
                result = this.options.getColorScheme().getCalloutErrorColor();
                break;
            }
            case CalloutNote: {
                result = this.options.getColorScheme().getCalloutNoteColor();
                break;
            }
            case Annotation: {
                result = this.options.getColorScheme().getAnnotationColor();
                break;
            }
            default: {
                throw new IllegalStateException("bug: unhandled element in color scheme - " + (Object)((Object)pElementType));
            }
        }
        return result != null ? result : NodeColor.None;
    }

    @Nonnull
    private Ansi emitColor(@Nonnull NodeColor pNodeColor) {
        if (pNodeColor != this.latestColorUsed) {
            switch (pNodeColor) {
                case None: {
                    this.ansi.reset();
                    break;
                }
                case Black: {
                    this.ansi.fgBlack();
                    break;
                }
                case White: {
                    this.ansi.fgBright(Ansi.Color.WHITE);
                    break;
                }
                case DarkRed: {
                    this.ansi.fgRed();
                    break;
                }
                case LightRed: {
                    this.ansi.fgBrightRed();
                    break;
                }
                case DarkGreen: {
                    this.ansi.fgGreen();
                    break;
                }
                case LightGreen: {
                    this.ansi.fgBrightGreen();
                    break;
                }
                case DarkYellow: {
                    this.ansi.fgYellow();
                    break;
                }
                case LightYellow: {
                    this.ansi.fgBrightYellow();
                    break;
                }
                case DarkBlue: {
                    this.ansi.fgBlue();
                    break;
                }
                case LightBlue: {
                    this.ansi.fgBrightBlue();
                    break;
                }
                case DarkMagenta: {
                    this.ansi.fgMagenta();
                    break;
                }
                case LightMagenta: {
                    this.ansi.fgBrightMagenta();
                    break;
                }
                case DarkCyan: {
                    this.ansi.fgCyan();
                    break;
                }
                case LightCyan: {
                    this.ansi.fgBrightCyan();
                    break;
                }
                case DarkGray: {
                    this.ansi.fgBrightBlack();
                    break;
                }
                case LightGray: {
                    this.ansi.fg(Ansi.Color.WHITE);
                }
            }
            this.latestColorUsed = pNodeColor;
        }
        return this.ansi;
    }

    public void newLine() {
        if (this.colorWasUsed) {
            if (this.latestColorUsed != NodeColor.None) {
                this.ansi.reset();
                this.latestColorUsed = NodeColor.None;
            }
            this.ansi.newline();
        } else {
            this.sb.append(System.lineSeparator());
        }
        this.currentLineLength = 0;
    }

    public String finishUp() {
        if (this.colorWasUsed) {
            return this.ansi.toString();
        }
        return this.sb.toString();
    }

    public int getCurrentLineLength() {
        return this.currentLineLength;
    }
}

