/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.conversion.avro;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.axonframework.conversion.avro.AvroUtil;
import org.axonframework.extension.spring.conversion.avro.ClasspathAvroSchemaLoader;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class SpecificRecordBaseClasspathAvroSchemaLoader
implements ClasspathAvroSchemaLoader {
    private final ClassPathScanningCandidateComponentProvider candidateProvider = new ClassPathScanningCandidateComponentProvider(false);

    public SpecificRecordBaseClasspathAvroSchemaLoader(ResourceLoader resourceLoader) {
        this.candidateProvider.setResourceLoader(resourceLoader);
        this.candidateProvider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(SpecificRecordBase.class));
    }

    @Override
    public List<Schema> load(List<String> packageNames) {
        return packageNames.stream().map(this::scan).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Schema> scan(String packageName) {
        Set candidates = this.candidateProvider.findCandidateComponents(packageName);
        return candidates.stream().map(candidate -> {
            try {
                Class<?> clazz = Class.forName(candidate.getBeanClassName());
                if (SpecificRecordBase.class.isAssignableFrom(clazz)) {
                    Class<?> specificRecordBaseClass = clazz;
                    return AvroUtil.getClassSchemaChecked(specificRecordBaseClass);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

