/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.messaging;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import org.axonframework.messaging.core.SubscribableEventSource;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;

public class ApplicationContextEventPublisher
implements InitializingBean,
ApplicationContextAware {
    private final SubscribableEventSource messageSource;
    private ApplicationContext applicationContext;

    public ApplicationContextEventPublisher(SubscribableEventSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationEvent convert(EventMessage eventMessage) {
        return new PayloadApplicationEvent((Object)this.messageSource, eventMessage.payload());
    }

    public void afterPropertiesSet() {
        this.messageSource.subscribe((msgs, ctx) -> {
            msgs.forEach(msg -> {
                ApplicationEvent converted = this.convert((EventMessage)msg);
                if (converted != null) {
                    this.applicationContext.publishEvent(this.convert((EventMessage)msg));
                }
            });
            return CompletableFuture.completedFuture(null);
        });
    }
}

