/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.function.Function;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.BaseModule;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.common.configuration.Module;
import org.axonframework.common.configuration.ModuleBuilder;

@Internal
public class SpringLazyCreatingModule<S extends Module>
extends BaseModule<SpringLazyCreatingModule<S>> {
    private final Function<Configuration, ModuleBuilder<? extends Module>> moduleBuilder;
    private String moduleName;

    SpringLazyCreatingModule(String name, Function<Configuration, ModuleBuilder<? extends Module>> moduleBuilder) {
        super(name);
        this.moduleBuilder = moduleBuilder;
    }

    public String name() {
        return this.moduleName != null ? this.moduleName : super.name();
    }

    public Configuration build(@Nonnull Configuration parent, @Nonnull LifecycleRegistry lifecycleRegistry) {
        Module module = this.moduleBuilder.apply(parent).build();
        this.moduleName = module.name();
        Configuration configuration = module.build(parent, lifecycleRegistry);
        Optional.of((ComponentRegistry)parent.getComponent(ComponentRegistry.class, () -> null)).ifPresentOrElse(r -> r.registerModule(module), () -> this.componentRegistry(r -> r.registerModule(module)));
        return configuration;
    }
}

