/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.authorization;

import jakarta.annotation.Nonnull;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.common.annotations.AnnotationUtils;
import org.axonframework.extension.spring.authorization.UnauthorizedMessageException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;

public class MessageAuthorizationHandlerInterceptor<M extends Message>
implements MessageHandlerInterceptor<M> {
    public static final String METADATA_AUTHORITIES_KEY = "authorities";
    private static final Logger logger = LoggerFactory.getLogger(MessageAuthorizationHandlerInterceptor.class);

    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<M> interceptorChain) {
        if (!AnnotationUtils.isAnnotationPresent((AnnotatedElement)message.payloadType(), Secured.class)) {
            return interceptorChain.proceed(message, context);
        }
        Secured annotation = message.payloadType().getAnnotation(Secured.class);
        Set requiredAuthorities = Arrays.stream(annotation.value()).collect(Collectors.toSet());
        try {
            Set messageAuthorities = Optional.ofNullable(message.metadata().get((Object)METADATA_AUTHORITIES_KEY)).map(authorityMetadata -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found authorities [{}]", authorityMetadata);
                }
                return new HashSet<String>(Arrays.asList(authorityMetadata.split(",")));
            }).orElseThrow(() -> new UnauthorizedMessageException("No authorities found for message with identifier [" + message.identifier() + "]"));
            if (logger.isDebugEnabled()) {
                logger.debug("Authorizing for [{}] and [{}]", (Object)message.type().name(), (Object)annotation.value());
            }
            messageAuthorities.retainAll(requiredAuthorities);
            if (!messageAuthorities.isEmpty()) {
                return interceptorChain.proceed(message, context);
            }
            throw new UnauthorizedMessageException("Unauthorized message with identifier [" + message.identifier() + "]");
        }
        catch (UnauthorizedMessageException e) {
            return MessageStream.failed((Throwable)((Object)new UnauthorizedMessageException("Unauthorized message with identifier [" + message.identifier() + "]")));
        }
    }
}

