/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config.annotation;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.extension.spring.config.annotation.SpringBeanDependencyResolverFactory;
import org.axonframework.extension.spring.config.annotation.SpringBeanParameterResolverFactory;
import org.axonframework.messaging.core.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.core.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringParameterResolverFactoryBean
implements FactoryBean<ParameterResolverFactory>,
BeanClassLoaderAware,
InitializingBean,
ApplicationContextAware {
    private final List<ParameterResolverFactory> factories = new ArrayList<ParameterResolverFactory>();
    private ClassLoader classLoader;
    private ApplicationContext applicationContext;

    public ParameterResolverFactory getObject() {
        return MultiParameterResolverFactory.ordered(this.factories);
    }

    public Class<?> getObjectType() {
        return ParameterResolverFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        this.factories.add(ClasspathParameterResolverFactory.forClassLoader((ClassLoader)this.classLoader));
        this.factories.add(new SpringBeanDependencyResolverFactory(this.applicationContext));
        this.factories.add(new SpringBeanParameterResolverFactory(this.applicationContext));
    }

    public void setAdditionalFactories(List<ParameterResolverFactory> additionalFactories) {
        this.factories.addAll(additionalFactories);
    }

    public void setBeanClassLoader(@Nonnull ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

