/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.common.configuration.Module;
import org.axonframework.common.configuration.ModuleBuilder;
import org.axonframework.extension.spring.config.EventProcessorSettings;
import org.axonframework.extension.spring.config.SpringCustomizations;
import org.axonframework.extension.spring.config.SpringLazyCreatingModule;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.configuration.CommandHandlingModule;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.configuration.EventHandlingComponentsConfigurer;
import org.axonframework.messaging.eventhandling.configuration.EventProcessorModule;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.PooledStreamingEventProcessorModule;
import org.axonframework.messaging.eventhandling.processing.subscribing.SubscribingEventProcessorModule;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.configuration.QueryHandlingModule;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

@Internal
public class MessageHandlerConfigurer
implements ConfigurationEnhancer,
ApplicationContextAware {
    private final Type type;
    private final List<String> handlerBeansRefs;
    private ApplicationContext applicationContext;

    public MessageHandlerConfigurer(Type type, List<String> beanRefs) {
        this.type = type;
        this.handlerBeansRefs = beanRefs;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        switch (this.type.ordinal()) {
            case 1: {
                this.configureEventHandlers(registry);
                break;
            }
            case 2: {
                this.configureQueryHandlers(registry);
                break;
            }
            case 0: {
                this.configureCommandHandlers(registry);
            }
        }
    }

    private void configureEventHandlers(ComponentRegistry registry) {
        this.groupNamedBeanDefinitionsByPackage().forEach((packageName, beanDefs) -> {
            Function<EventHandlingComponentsConfigurer.RequiredComponentPhase, EventHandlingComponentsConfigurer.CompletePhase> componentRegistration = phase -> {
                EventHandlingComponentsConfigurer.AdditionalComponentPhase resultOfRegistration = null;
                for (NamedBeanDefinition namedBeanDefinition : beanDefs) {
                    resultOfRegistration = phase.annotated(this.createComponentBuilder(namedBeanDefinition));
                }
                return resultOfRegistration;
            };
            String processorName = "EventProcessor[" + packageName + "]";
            Function<Configuration, ModuleBuilder<? extends Module>> moduleBuilder = configuration -> {
                Map<String, EventProcessorSettings> allSettings = ((EventProcessorSettings.MapWrapper)configuration.getComponent(EventProcessorSettings.MapWrapper.class)).settings();
                EventProcessorSettings settings = Optional.ofNullable(allSettings.get(packageName)).orElseGet(() -> (EventProcessorSettings)allSettings.get("..default"));
                return switch (settings.processorMode()) {
                    default -> throw new MatchException(null, null);
                    case EventProcessorSettings.ProcessorMode.POOLED -> {
                        EventProcessorSettings.PooledEventProcessorSettings moduleSettings = (EventProcessorSettings.PooledEventProcessorSettings)settings;
                        yield (PooledStreamingEventProcessorModule)EventProcessorModule.pooledStreaming((String)processorName).eventHandlingComponents(componentRegistration).customized(SpringCustomizations.pooledStreamingCustomizations(packageName, moduleSettings).andThen(c -> c.unitOfWorkFactory((UnitOfWorkFactory)configuration.getComponent(UnitOfWorkFactory.class))));
                    }
                    case EventProcessorSettings.ProcessorMode.SUBSCRIBING -> {
                        EventProcessorSettings.SubscribingEventProcessorSettings moduleSettings = (EventProcessorSettings.SubscribingEventProcessorSettings)settings;
                        yield (SubscribingEventProcessorModule)EventProcessorModule.subscribing((String)processorName).eventHandlingComponents(componentRegistration).customized(SpringCustomizations.subscribingCustomizations(packageName, moduleSettings).andThen(c -> c.unitOfWorkFactory((UnitOfWorkFactory)configuration.getComponent(UnitOfWorkFactory.class))));
                    }
                };
            };
            registry.registerModule(new SpringLazyCreatingModule("Lazy[" + processorName + "]", moduleBuilder));
        });
    }

    private void configureQueryHandlers(ComponentRegistry registry) {
        this.groupNamedBeanDefinitionsByPackage().forEach((packageName, beanDefs) -> {
            String moduleName = "QueryHandling[" + packageName + "]";
            QueryHandlingModule.QueryHandlerPhase queryHandlingModuleBuilder = QueryHandlingModule.named((String)moduleName).queryHandlers();
            beanDefs.forEach(namedBeanDefinition -> queryHandlingModuleBuilder.annotatedQueryHandlingComponent(this.createComponentBuilder((NamedBeanDefinition)namedBeanDefinition)));
            registry.registerModule(queryHandlingModuleBuilder.build());
        });
    }

    private void configureCommandHandlers(ComponentRegistry registry) {
        this.groupNamedBeanDefinitionsByPackage().forEach((packageName, beanDefs) -> {
            String moduleName = "CommandHandling[" + packageName + "]";
            CommandHandlingModule.CommandHandlerPhase commandHandlingModuleBuilder = CommandHandlingModule.named((String)moduleName).commandHandlers();
            beanDefs.forEach(namedBeanDefinition -> commandHandlingModuleBuilder.annotatedCommandHandlingComponent(this.createComponentBuilder((NamedBeanDefinition)namedBeanDefinition)));
            registry.registerModule(commandHandlingModuleBuilder.build());
        });
    }

    private ComponentBuilder<Object> createComponentBuilder(@Nonnull NamedBeanDefinition namedBeanDefinition) {
        return configuration -> this.applicationContext.getBean(namedBeanDefinition.name());
    }

    private Map<String, List<NamedBeanDefinition>> groupNamedBeanDefinitionsByPackage() {
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        return this.handlerBeansRefs.stream().map(name -> new NamedBeanDefinition((String)name, beanFactory.getBeanDefinition(name))).collect(Collectors.groupingBy(nbd -> {
            BeanDefinition patt0$temp;
            String className = nbd.definition().getBeanClassName();
            if (className == null && (patt0$temp = nbd.definition()) instanceof AbstractBeanDefinition) {
                AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)patt0$temp;
                if (abstractBeanDefinition.hasBeanClass()) {
                    className = abstractBeanDefinition.getBeanClass().getName();
                } else {
                    BeanDefinition patt1$temp = nbd.definition();
                    if (patt1$temp instanceof AnnotatedBeanDefinition) {
                        AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)patt1$temp;
                        className = annotatedBeanDefinition.getMetadata().getClassName();
                    }
                }
            }
            return className != null && className.contains(".") ? className.substring(0, className.lastIndexOf(46)) : "default";
        }));
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static enum Type {
        COMMAND(CommandMessage.class),
        EVENT(EventMessage.class),
        QUERY(QueryMessage.class);

        private final Class<? extends Message> messageType;

        private Type(Class<? extends Message> messageType) {
            this.messageType = messageType;
        }

        public Class<? extends Message> getMessageType() {
            return this.messageType;
        }
    }

    record NamedBeanDefinition(@Nonnull String name, @Nonnull BeanDefinition definition) {
    }
}

