/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.Priority;
import org.axonframework.common.annotations.AnnotationUtils;
import org.axonframework.extension.spring.SpringUtils;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@Priority(value=-1073741824)
public class SpringBeanParameterResolverFactory
implements ParameterResolverFactory,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringBeanParameterResolverFactory.class);
    private ApplicationContext applicationContext;

    public SpringBeanParameterResolverFactory() {
    }

    public SpringBeanParameterResolverFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public ParameterResolver<?> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (this.applicationContext == null) {
            return null;
        }
        Class<?> parameterType = parameters[parameterIndex].getType();
        String[] beansFound = this.applicationContext.getBeanNamesForType(parameterType);
        if (beansFound.length == 0) {
            return null;
        }
        if (beansFound.length > 1) {
            Optional<ParameterResolver<?>> resolver;
            AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
            if (beanFactory instanceof ConfigurableListableBeanFactory && (resolver = this.findQualifiedBean(beansFound, (ConfigurableListableBeanFactory)beanFactory, parameters, parameterIndex)).isPresent()) {
                return resolver.get();
            }
            if (logger.isWarnEnabled()) {
                logger.warn("{} beans of type {} found, but none was marked as primary and parameter lacks @Qualifier. Ignoring this parameter.", (Object)beansFound.length, (Object)parameterType.getSimpleName());
            }
            return null;
        }
        return new SpringBeanParameterResolver(this.applicationContext.getAutowireCapableBeanFactory(), beansFound[0]);
    }

    private Optional<ParameterResolver<?>> findQualifiedBean(String[] beansFound, ConfigurableListableBeanFactory clBeanFactory, Parameter[] parameters, int parameterIndex) {
        Parameter parameter = parameters[parameterIndex];
        Optional qualifier = AnnotationUtils.findAnnotationAttributes((AnnotatedElement)parameter, Qualifier.class);
        if (qualifier.isPresent()) {
            for (String bean : beansFound) {
                if (!SpringUtils.isQualifierMatch(bean, clBeanFactory, (String)((Map)qualifier.get()).get("qualifier"))) continue;
                return Optional.of(new SpringBeanParameterResolver((AutowireCapableBeanFactory)clBeanFactory, bean));
            }
        }
        for (String bean : beansFound) {
            if (!clBeanFactory.containsBeanDefinition(bean) || !clBeanFactory.getBeanDefinition(bean).isPrimary()) continue;
            return Optional.of(new SpringBeanParameterResolver((AutowireCapableBeanFactory)clBeanFactory, bean));
        }
        return Optional.empty();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static class SpringBeanParameterResolver
    implements ParameterResolver<Object> {
        private final AutowireCapableBeanFactory beanFactory;
        private final String beanName;

        public SpringBeanParameterResolver(AutowireCapableBeanFactory beanFactory, String beanName) {
            this.beanFactory = beanFactory;
            this.beanName = beanName;
        }

        public Object resolveParameterValue(@Nonnull ProcessingContext context) {
            return this.beanFactory.getBean(this.beanName);
        }

        public boolean matches(@Nonnull ProcessingContext context) {
            return true;
        }
    }
}

