/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import java.util.List;
import java.util.Optional;
import org.axonframework.common.configuration.DecoratorDefinition;
import org.axonframework.extension.springboot.autoconfig.AxonAutoConfiguration;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.interception.DispatchInterceptorRegistry;
import org.axonframework.messaging.core.interception.HandlerInterceptorRegistry;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureAfter(value={AxonAutoConfiguration.class})
public class InterceptorAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={MessageDispatchInterceptor.class})
    public DecoratorDefinition<DispatchInterceptorRegistry, DispatchInterceptorRegistry> dispatchInterceptorEnhancer(Optional<List<MessageDispatchInterceptor<? super CommandMessage>>> commandInterceptors, Optional<List<MessageDispatchInterceptor<? super EventMessage>>> eventInterceptors, Optional<List<MessageDispatchInterceptor<? super QueryMessage>>> queryInterceptors) {
        return DecoratorDefinition.forType(DispatchInterceptorRegistry.class).with((config, name, delegate) -> InterceptorAutoConfiguration.registerDispatchInterceptors(delegate, commandInterceptors, eventInterceptors, queryInterceptors));
    }

    private static DispatchInterceptorRegistry registerDispatchInterceptors(DispatchInterceptorRegistry registry, Optional<List<MessageDispatchInterceptor<? super CommandMessage>>> commandInterceptors, Optional<List<MessageDispatchInterceptor<? super EventMessage>>> eventInterceptors, Optional<List<MessageDispatchInterceptor<? super QueryMessage>>> queryInterceptors) {
        if (commandInterceptors.isPresent()) {
            for (MessageDispatchInterceptor<? super CommandMessage> messageDispatchInterceptor : commandInterceptors.get()) {
                registry = registry.registerCommandInterceptor(c -> interceptor);
            }
        }
        if (eventInterceptors.isPresent()) {
            for (MessageDispatchInterceptor<? super CommandMessage> messageDispatchInterceptor : eventInterceptors.get()) {
                registry = registry.registerEventInterceptor(c -> interceptor);
            }
        }
        if (queryInterceptors.isPresent()) {
            for (MessageDispatchInterceptor<? super CommandMessage> messageDispatchInterceptor : queryInterceptors.get()) {
                registry = registry.registerQueryInterceptor(c -> interceptor);
            }
        }
        return registry;
    }

    @Bean
    @ConditionalOnBean(value={MessageHandlerInterceptor.class})
    public DecoratorDefinition<HandlerInterceptorRegistry, HandlerInterceptorRegistry> handlerInterceptorEnhancer(Optional<List<MessageHandlerInterceptor<Message>>> interceptors, Optional<List<MessageHandlerInterceptor<CommandMessage>>> commandInterceptors, Optional<List<MessageHandlerInterceptor<EventMessage>>> eventInterceptors, Optional<List<MessageHandlerInterceptor<QueryMessage>>> queryInterceptors) {
        return DecoratorDefinition.forType(HandlerInterceptorRegistry.class).with((config, name, delegate) -> InterceptorAutoConfiguration.registerHandlerInterceptors(delegate, interceptors, commandInterceptors, eventInterceptors, queryInterceptors));
    }

    private static HandlerInterceptorRegistry registerHandlerInterceptors(HandlerInterceptorRegistry registry, Optional<List<MessageHandlerInterceptor<Message>>> interceptors, Optional<List<MessageHandlerInterceptor<CommandMessage>>> commandInterceptors, Optional<List<MessageHandlerInterceptor<EventMessage>>> eventInterceptors, Optional<List<MessageHandlerInterceptor<QueryMessage>>> queryInterceptors) {
        if (interceptors.isPresent()) {
            for (MessageHandlerInterceptor<Message> messageHandlerInterceptor : interceptors.get()) {
                registry = registry.registerInterceptor(c -> interceptor);
            }
        }
        if (commandInterceptors.isPresent()) {
            for (MessageHandlerInterceptor<Message> messageHandlerInterceptor : commandInterceptors.get()) {
                registry = registry.registerCommandInterceptor(c -> interceptor);
            }
        }
        if (eventInterceptors.isPresent()) {
            for (MessageHandlerInterceptor<Message> messageHandlerInterceptor : eventInterceptors.get()) {
                registry = registry.registerEventInterceptor(c -> interceptor);
            }
        }
        if (queryInterceptors.isPresent()) {
            for (MessageHandlerInterceptor<Message> messageHandlerInterceptor : queryInterceptors.get()) {
                registry = registry.registerQueryInterceptor(c -> interceptor);
            }
        }
        return registry;
    }
}

