/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.extension.springboot.actuator.axonserver.AxonServerHealthIndicator;
import org.axonframework.extension.springboot.actuator.axonserver.AxonServerStatusAggregator;
import org.axonframework.extension.springboot.autoconfig.AxonServerAutoConfiguration;
import org.springframework.boot.actuate.health.SimpleStatusAggregator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={AxonServerAutoConfiguration.class})
@ConditionalOnClass(name={"org.springframework.boot.actuate.health.AbstractHealthIndicator", "org.axonframework.axonserver.connector.AxonServerConnectionManager"})
@ConditionalOnProperty(name={"axon.axonserver.enabled"}, matchIfMissing=true)
public class AxonServerActuatorAutoConfiguration {
    @ConditionalOnMissingBean(value={AxonServerHealthIndicator.class})
    @Bean
    public AxonServerHealthIndicator axonServerHealthIndicator(AxonServerConnectionManager connectionManager) {
        return new AxonServerHealthIndicator(connectionManager);
    }

    @ConditionalOnMissingBean(value={SimpleStatusAggregator.class})
    @Bean
    public AxonServerStatusAggregator axonServerStatusAggregator() {
        return new AxonServerStatusAggregator();
    }
}

