/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.message.SchemaStore;
import org.axonframework.extension.spring.serialization.avro.AvroSchemaPackages;
import org.axonframework.extension.spring.serialization.avro.ClasspathAvroSchemaLoader;
import org.axonframework.extension.spring.serialization.avro.SpecificRecordBaseClasspathAvroSchemaLoader;
import org.axonframework.extension.springboot.autoconfig.ConverterAutoConfiguration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.io.ResourceLoader;

@AutoConfiguration
@AutoConfigureBefore(value={ConverterAutoConfiguration.class})
@ConditionalOnClass(name={"org.apache.avro.message.SchemaStore"})
public class AvroSchemaStoreAutoConfiguration {
    @Bean(value={"defaultAxonSchemaStore"})
    @Conditional(value={AvroConfiguredCondition.class, OnMissingDefaultSchemaStoreCondition.class})
    public SchemaStore defaultAxonSchemaStore(Set<Schema> schemas) {
        SchemaStore.Cache cachingSchemaStore = new SchemaStore.Cache();
        schemas.forEach(arg_0 -> ((SchemaStore.Cache)cachingSchemaStore).addSchema(arg_0));
        return cachingSchemaStore;
    }

    @Bean
    @Conditional(value={AvroConfiguredCondition.class})
    public Set<Schema> collectAvroSchemasFromClassPath(BeanFactory beanFactory, List<ClasspathAvroSchemaLoader> schemaLoader) {
        List packagesCandidates = AvroSchemaPackages.get((BeanFactory)beanFactory).getPackages();
        ArrayList packagesToScan = new ArrayList();
        if (packagesCandidates.isEmpty() && AutoConfigurationPackages.has((BeanFactory)beanFactory)) {
            packagesToScan.addAll(AutoConfigurationPackages.get((BeanFactory)beanFactory));
        } else {
            packagesToScan.addAll(packagesCandidates);
        }
        return schemaLoader.stream().map(loader -> loader.load(packagesToScan)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Bean(value={"specificRecordBaseClasspathAvroSchemaLoader"})
    @Conditional(value={AvroConfiguredCondition.class})
    public ClasspathAvroSchemaLoader specificRecordBaseClasspathAvroSchemaLoader(ResourceLoader resourceLoader) {
        return new SpecificRecordBaseClasspathAvroSchemaLoader(resourceLoader);
    }

    private static class OnMissingDefaultSchemaStoreCondition
    extends AllNestedConditions {
        public OnMissingDefaultSchemaStoreCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={SchemaStore.class})
        static class SchemaStoreIsMissingCondition {
            SchemaStoreIsMissingCondition() {
            }
        }
    }

    private static class AvroConfiguredCondition
    extends AnyNestedCondition {
        public AvroConfiguredCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(name={"axon.converter.events"}, havingValue="avro")
        static class EventsAvroCondition {
            EventsAvroCondition() {
            }
        }

        @ConditionalOnProperty(name={"axon.converter.messages"}, havingValue="avro")
        static class MessagesAvroCondition {
            MessagesAvroCondition() {
            }
        }
    }
}

