/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventsourcing.tokenstore;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.management.ManagementFactory;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.eventhandling.tokenstore.ConfigToken;
import org.axonframework.eventhandling.tokenstore.GenericTokenEntry;
import org.axonframework.eventhandling.tokenstore.TokenStore;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToInitializeTokenException;
import org.axonframework.eventhandling.tokenstore.UnableToRetrieveIdentifierException;
import org.axonframework.eventhandling.tokenstore.jpa.TokenEntry;
import org.axonframework.extensions.mongo.MongoTemplate;
import org.axonframework.serialization.Serializer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoTokenStore
implements TokenStore {
    private static final Logger logger = LoggerFactory.getLogger(MongoTokenStore.class);
    private static final Clock clock = Clock.systemUTC();
    private static final String CONFIG_TOKEN_ID = "__config";
    private static final int CONFIG_SEGMENT = 0;
    private final MongoTemplate mongoTemplate;
    private final Serializer serializer;
    private final TemporalAmount claimTimeout;
    private final String nodeId;
    private final Class<?> contentType;

    protected MongoTokenStore(Builder builder) {
        builder.validate();
        this.mongoTemplate = builder.mongoTemplate;
        this.serializer = builder.serializer;
        this.claimTimeout = builder.claimTimeout;
        this.nodeId = builder.nodeId;
        this.contentType = builder.contentType;
        if (builder.ensureIndexes) {
            this.ensureIndexes();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public void storeToken(TrackingToken token, String processorName, int segment) throws UnableToClaimTokenException {
        this.updateToken(token, processorName, segment);
    }

    private void updateToken(TrackingToken token, String processorName, int segment) {
        GenericTokenEntry tokenEntry = new GenericTokenEntry(token, this.serializer, this.contentType, processorName, segment);
        tokenEntry.claim(this.nodeId, this.claimTimeout);
        Bson update = Updates.combine((Bson[])new Bson[]{Updates.set((String)"owner", (Object)this.nodeId), Updates.set((String)"timestamp", (Object)tokenEntry.timestamp().toEpochMilli()), Updates.set((String)"token", (Object)tokenEntry.getSerializedToken().getData()), Updates.set((String)"tokenType", (Object)tokenEntry.getSerializedToken().getType().getName())});
        UpdateResult updateResult = this.mongoTemplate.trackingTokensCollection().updateOne(this.claimableTokenEntryFilter(processorName, segment), update);
        if (updateResult.getModifiedCount() == 0L) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is either already claimed or it does not exist", processorName, segment));
        }
    }

    public void initializeTokenSegments(String processorName, int segmentCount) throws UnableToClaimTokenException {
        this.initializeTokenSegments(processorName, segmentCount, null);
    }

    public void initializeTokenSegments(String processorName, int segmentCount, TrackingToken initialToken) throws UnableToClaimTokenException {
        if (this.fetchSegments(processorName).length > 0) {
            throw new UnableToClaimTokenException("Unable to initialize segments. Some tokens were already present for the given processor.");
        }
        List entries = IntStream.range(0, segmentCount).mapToObj(segment -> new GenericTokenEntry(initialToken, this.serializer, this.contentType, processorName, segment)).map(this::tokenEntryToDocument).collect(Collectors.toList());
        this.mongoTemplate.trackingTokensCollection().insertMany(entries, new InsertManyOptions().ordered(false));
    }

    public TrackingToken fetchToken(String processorName, int segment) throws UnableToClaimTokenException {
        return this.loadToken(processorName, segment).getToken(this.serializer);
    }

    private AbstractTokenEntry<?> loadToken(String processorName, int segment) {
        Document document = (Document)this.mongoTemplate.trackingTokensCollection().findOneAndUpdate(this.claimableTokenEntryFilter(processorName, segment), Updates.combine((Bson[])new Bson[]{Updates.set((String)"owner", (Object)this.nodeId), Updates.set((String)"timestamp", (Object)clock.millis())}), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
        if (document == null) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It has not been initialized yet", processorName, segment));
        }
        AbstractTokenEntry<?> tokenEntry = this.documentToTokenEntry(document);
        if (!tokenEntry.claim(this.nodeId, this.claimTimeout)) {
            throw new UnableToClaimTokenException(String.format("Unable to claim token '%s[%s]'. It is owned by '%s'", processorName, segment, tokenEntry.getOwner()));
        }
        return tokenEntry;
    }

    public void extendClaim(String processorName, int segment) throws UnableToClaimTokenException {
        UpdateResult updateResult = this.mongoTemplate.trackingTokensCollection().updateOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processorName", (Object)processorName), Filters.eq((String)"segment", (Object)segment), Filters.eq((String)"owner", (Object)this.nodeId)}), Updates.set((String)"timestamp", (Object)TokenEntry.clock.instant().toEpochMilli()));
        if (updateResult.getMatchedCount() == 0L) {
            throw new UnableToClaimTokenException(String.format("Unable to extend claim on token token '%s[%s]'. It is owned by another segment.", processorName, segment));
        }
    }

    public void releaseClaim(String processorName, int segment) {
        UpdateResult updateResult = this.mongoTemplate.trackingTokensCollection().updateOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processorName", (Object)processorName), Filters.eq((String)"segment", (Object)segment), Filters.eq((String)"owner", (Object)this.nodeId)}), Updates.set((String)"owner", null));
        if (updateResult.getMatchedCount() == 0L) {
            logger.warn("Releasing claim of token {}/{} failed. It was owned by another node.", (Object)processorName, (Object)segment);
        }
    }

    public void initializeSegment(TrackingToken token, String processorName, int segment) throws UnableToInitializeTokenException {
        block2: {
            try {
                GenericTokenEntry tokenEntry = new GenericTokenEntry(token, this.serializer, this.contentType, processorName, segment);
                this.mongoTemplate.trackingTokensCollection().insertOne((Object)this.tokenEntryToDocument((AbstractTokenEntry<?>)tokenEntry));
            }
            catch (MongoWriteException exception) {
                if (ErrorCategory.fromErrorCode((int)exception.getError().getCode()) != ErrorCategory.DUPLICATE_KEY) break block2;
                throw new UnableToInitializeTokenException(String.format("Unable to initialize token '%s[%s]'", processorName, segment));
            }
        }
    }

    public void deleteToken(String processorName, int segment) throws UnableToClaimTokenException {
        DeleteResult deleteResult = this.mongoTemplate.trackingTokensCollection().deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processorName", (Object)processorName), Filters.eq((String)"segment", (Object)segment), Filters.eq((String)"owner", (Object)this.nodeId)}));
        if (deleteResult.getDeletedCount() == 0L) {
            throw new UnableToClaimTokenException("Unable to remove token. It is not owned by " + this.nodeId);
        }
    }

    public boolean requiresExplicitSegmentInitialization() {
        return true;
    }

    public int[] fetchSegments(String processorName) {
        ArrayList segments = (ArrayList)this.mongoTemplate.trackingTokensCollection().find(Filters.eq((String)"processorName", (Object)processorName)).sort(Sorts.ascending((String[])new String[]{"segment"})).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"segment"}), Projections.excludeId()})).map(d -> (Integer)d.get((Object)"segment", Integer.class)).into(new ArrayList());
        int[] ints = new int[segments.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = (Integer)segments.get(i);
        }
        return ints;
    }

    public Optional<String> retrieveStorageIdentifier() throws UnableToRetrieveIdentifierException {
        try {
            return Optional.of(this.getConfig()).map(configToken -> configToken.get("id"));
        }
        catch (Exception e) {
            throw new UnableToRetrieveIdentifierException("Exception occurred while trying to establish storage identifier", (Throwable)e);
        }
    }

    private ConfigToken getConfig() {
        GenericTokenEntry token;
        Document document = (Document)this.mongoTemplate.trackingTokensCollection().find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"processorName", (Object)CONFIG_TOKEN_ID), Filters.eq((String)"segment", (Object)0)})).first();
        if (Objects.isNull(document)) {
            token = new GenericTokenEntry((TrackingToken)new ConfigToken(Collections.singletonMap("id", UUID.randomUUID().toString())), this.serializer, this.contentType, CONFIG_TOKEN_ID, 0);
            this.mongoTemplate.trackingTokensCollection().insertOne((Object)this.tokenEntryToDocument((AbstractTokenEntry<?>)token));
        } else {
            token = this.documentToTokenEntry(document);
        }
        return (ConfigToken)token.getToken(this.serializer);
    }

    private Bson claimableTokenEntryFilter(String processorName, int segment) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"processorName", (Object)processorName), Filters.eq((String)"segment", (Object)segment), Filters.or((Bson[])new Bson[]{Filters.eq((String)"owner", (Object)this.nodeId), Filters.eq((String)"owner", null), Filters.lt((String)"timestamp", (Object)clock.instant().minus(this.claimTimeout).toEpochMilli())})});
    }

    private Document tokenEntryToDocument(AbstractTokenEntry<?> tokenEntry) {
        return new Document("processorName", (Object)tokenEntry.getProcessorName()).append("segment", (Object)tokenEntry.getSegment()).append("owner", (Object)tokenEntry.getOwner()).append("timestamp", (Object)tokenEntry.timestamp().toEpochMilli()).append("token", tokenEntry.getSerializedToken() == null ? null : tokenEntry.getSerializedToken().getData()).append("tokenType", tokenEntry.getSerializedToken() == null ? null : tokenEntry.getSerializedToken().getType().getName());
    }

    private AbstractTokenEntry<?> documentToTokenEntry(Document document) {
        return new GenericTokenEntry(this.readSerializedData(document), document.getString((Object)"tokenType"), Instant.ofEpochMilli(document.getLong((Object)"timestamp")).toString(), document.getString((Object)"owner"), document.getString((Object)"processorName"), document.getInteger((Object)"segment").intValue(), this.contentType);
    }

    private <T> T readSerializedData(Document document) {
        if (byte[].class.equals(this.contentType)) {
            Binary token = (Binary)document.get((Object)"token", Binary.class);
            return (T)(token != null ? token.getData() : null);
        }
        return (T)document.get((Object)"token", this.contentType);
    }

    @Deprecated
    public void ensureIndexes() {
        this.mongoTemplate.trackingTokensCollection().createIndex(Indexes.ascending((String[])new String[]{"processorName", "segment"}), new IndexOptions().unique(true));
    }

    public static class Builder {
        private MongoTemplate mongoTemplate;
        private Serializer serializer;
        private TemporalAmount claimTimeout = Duration.ofSeconds(10L);
        private String nodeId = ManagementFactory.getRuntimeMXBean().getName();
        private Class<?> contentType = byte[].class;
        private boolean ensureIndexes = true;

        public Builder mongoTemplate(MongoTemplate mongoTemplate) {
            BuilderUtils.assertNonNull((Object)mongoTemplate, (String)"MongoTemplate may not be null");
            this.mongoTemplate = mongoTemplate;
            return this;
        }

        public Builder serializer(Serializer serializer) {
            BuilderUtils.assertNonNull((Object)serializer, (String)"Serializer may not be null");
            this.serializer = serializer;
            return this;
        }

        public Builder claimTimeout(TemporalAmount claimTimeout) {
            BuilderUtils.assertNonNull((Object)claimTimeout, (String)"The claim timeout may not be null");
            this.claimTimeout = claimTimeout;
            return this;
        }

        public Builder nodeId(String nodeId) {
            this.assertNodeId(nodeId, "The nodeId may not be null or empty");
            this.nodeId = nodeId;
            return this;
        }

        public Builder contentType(Class<?> contentType) {
            BuilderUtils.assertNonNull(contentType, (String)"The content type may not be null");
            this.contentType = contentType;
            return this;
        }

        public Builder ensureIndexes(boolean ensureIndexes) {
            this.ensureIndexes = ensureIndexes;
            return this;
        }

        public MongoTokenStore build() {
            return new MongoTokenStore(this);
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.mongoTemplate, (String)"The MongoTemplate is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.serializer, (String)"The Serializer is a hard requirement and should be provided");
        }

        private void assertNodeId(String nodeId, String exceptionMessage) {
            BuilderUtils.assertThat((Object)nodeId, name -> Objects.nonNull(name) && !"".equals(name), (String)exceptionMessage);
        }
    }
}

