/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventsourcing.eventstore;

import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoSettingsFactory {
    private static final Logger logger = LoggerFactory.getLogger(MongoSettingsFactory.class);
    private final MongoClientSettings defaults;
    private List<ServerAddress> mongoAddresses = Collections.emptyList();
    private WriteConcern writeConcern;
    private int connectionsPerHost;
    private int socketConnectTimeout;
    private long maxWaitTime;
    private int socketReadTimeOut;

    public MongoSettingsFactory() {
        this.defaults = MongoClientSettings.builder().build();
    }

    public MongoClientSettings createMongoClientSettings() {
        MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder().applyToConnectionPoolSettings(builder -> builder.maxWaitTime(this.getMaxWaitTime(), TimeUnit.MILLISECONDS).maxSize(this.getConnectionsPerHost())).applyToSocketSettings(builder -> builder.connectTimeout(this.getSocketConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.getSocketReadTimeOut(), TimeUnit.MILLISECONDS)).writeConcern(this.defaultWriteConcern());
        if (this.mongoAddresses != null && this.mongoAddresses.size() > 0) {
            mongoClientSettingsBuilder.applyToClusterSettings(builder -> builder.hosts(this.mongoAddresses));
        }
        MongoClientSettings settings = mongoClientSettingsBuilder.build();
        if (logger.isDebugEnabled()) {
            logger.debug("Mongo Options");
            logger.debug("Connections per host :{}", (Object)settings.getConnectionPoolSettings().getMaxSize());
            logger.debug("Connection timeout : {}", (Object)settings.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS));
            logger.debug("Max wait timeout : {}", (Object)settings.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS));
            logger.debug("Socket read timeout : {}", (Object)settings.getSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS));
        }
        return settings;
    }

    public int getConnectionsPerHost() {
        return this.connectionsPerHost > 0 ? this.connectionsPerHost : this.defaults.getConnectionPoolSettings().getMaxSize();
    }

    public void setConnectionsPerHost(int connectionsPerHost) {
        this.connectionsPerHost = connectionsPerHost;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout > 0 ? this.socketConnectTimeout : this.defaults.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS);
    }

    public void setSocketConnectTimeout(int socketConnectTimeout) {
        this.socketConnectTimeout = socketConnectTimeout;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime > 0L ? this.maxWaitTime : this.defaults.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS);
    }

    public void setMaxWaitTime(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public int getSocketReadTimeOut() {
        return this.socketReadTimeOut > 0 ? this.socketReadTimeOut : this.defaults.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS);
    }

    public void setSocketReadTimeOut(int socketReadTimeOut) {
        this.socketReadTimeOut = socketReadTimeOut;
    }

    public void setMongoAddresses(List<ServerAddress> mongoAddresses) {
        this.mongoAddresses = mongoAddresses;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    private WriteConcern defaultWriteConcern() {
        if (this.writeConcern != null) {
            return this.writeConcern;
        }
        if (this.mongoAddresses.size() > 1) {
            return WriteConcern.W2;
        }
        return WriteConcern.JOURNALED;
    }
}

