/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandHandler;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

@Internal
public class RecordingCommandBus
implements CommandBus {
    private final CommandBus delegate;
    private final Map<CommandMessage, Message> recorded = new HashMap<CommandMessage, Message>();

    public RecordingCommandBus(@Nonnull CommandBus delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate CommandBus may not be null");
    }

    public CompletableFuture<CommandResultMessage> dispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext processingContext) {
        this.recorded.put(command, null);
        CompletableFuture commandResult = this.delegate.dispatch(command, processingContext);
        commandResult.thenApply(result -> {
            this.recorded.put(command, (Message)result);
            return result;
        });
        return commandResult;
    }

    public CommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        return (CommandBus)this.delegate.subscribe(name, commandHandler);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
    }

    public Map<CommandMessage, Message> recorded() {
        return Map.copyOf(this.recorded);
    }

    public List<CommandMessage> recordedCommands() {
        return List.copyOf(this.recorded.keySet());
    }

    @Nullable
    public Message resultOf(@Nonnull CommandMessage command) {
        Objects.requireNonNull(command, "Command Message may not be null.");
        return this.recorded.get(command);
    }

    public RecordingCommandBus reset() {
        this.recorded.clear();
        return this;
    }
}

