/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.util.DescriptionUtils;
import org.axonframework.test.util.RecordingCommandBus;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class CommandValidator {
    private final FieldFilter fieldFilter;
    private final Supplier<List<CommandMessage>> dispatchedCommands;
    private final Runnable clearRecordedCommands;

    public CommandValidator(RecordingCommandBus commandBus, FieldFilter fieldFilter) {
        this(commandBus::getDispatchedCommands, commandBus::clearCommands, fieldFilter);
    }

    public CommandValidator(Supplier<List<CommandMessage>> dispatchedCommands, Runnable clearRecordedCommands, FieldFilter fieldFilter) {
        this.dispatchedCommands = dispatchedCommands;
        this.clearRecordedCommands = clearRecordedCommands;
        this.fieldFilter = fieldFilter;
    }

    public void startRecording() {
        this.clearRecordedCommands.run();
    }

    public void assertDispatchedEqualTo(Object ... expected) {
        List<CommandMessage> actual = this.dispatchedCommands.get();
        if (actual.size() != expected.length) {
            throw new AxonAssertionError("Got wrong number of commands dispatched.\nExpected <" + expected.length + ">,\n but got <" + actual.size() + ">.");
        }
        Iterator<CommandMessage> actualIterator = actual.iterator();
        Iterator<Object> expectedIterator = Arrays.asList(expected).iterator();
        int counter = 0;
        while (actualIterator.hasNext()) {
            CommandMessage actualItem = actualIterator.next();
            Object expectedItem = expectedIterator.next();
            if (expectedItem instanceof CommandMessage) {
                CommandMessage expectedMessage = (CommandMessage)expectedItem;
                if (!expectedMessage.payloadType().equals(actualItem.payloadType())) {
                    throw new AxonAssertionError("Unexpected payload type of command at position " + counter + " (0-based).\nExpected <" + String.valueOf(expectedMessage.payloadType()) + ">,\n but got <" + String.valueOf(actualItem.payloadType()) + ">.");
                }
                this.assertCommandEquality(counter, expectedMessage.payload(), actualItem.payload());
                if (!expectedMessage.metadata().equals((Object)actualItem.metadata())) {
                    throw new AxonAssertionError("Unexpected metadata of command at position " + counter + " (0-based).\nExpected <" + String.valueOf(expectedMessage.metadata()) + ">,\n but got <" + String.valueOf(actualItem.metadata()) + ">.");
                }
            } else {
                this.assertCommandEquality(counter, expectedItem, actualItem.payload());
            }
            ++counter;
        }
    }

    public void assertDispatchedMatching(Matcher<?> matcher) {
        if (!matcher.matches(this.dispatchedCommands.get())) {
            StringDescription expectedDescription = new StringDescription();
            StringDescription actualDescription = new StringDescription();
            matcher.describeTo((Description)expectedDescription);
            DescriptionUtils.describe(this.dispatchedCommands.get(), (Description)actualDescription);
            throw new AxonAssertionError("Incorrect dispatched command.\nExpected <" + String.valueOf(expectedDescription) + ">,\n but got <" + String.valueOf(actualDescription) + ">.");
        }
    }

    private void assertCommandEquality(int commandIndex, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            if (!expected.getClass().equals(actual.getClass())) {
                throw new AxonAssertionError("Wrong command type at index " + commandIndex + " (0-based).\nExpected <" + expected.getClass().getSimpleName() + ">,\n but got <" + actual.getClass().getSimpleName() + ">.");
            }
            Matcher<Object> matcher = Matchers.deepEquals(expected, this.fieldFilter);
            if (!matcher.matches(actual)) {
                throw new AxonAssertionError("Unexpected command at index " + commandIndex + " (0-based).\nExpected <" + String.valueOf(expected) + ">,\n but got <" + String.valueOf(actual) + ">.");
            }
        }
    }
}

