/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.utils;

import jakarta.annotation.Nonnull;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.test.utils.MessageMonitorReport;
import org.jetbrains.annotations.NotNull;

public class RecordingMessageMonitor
implements MessageMonitor<Message> {
    protected final MessageMonitorReport report;

    public RecordingMessageMonitor() {
        this(new MessageMonitorReport());
    }

    public RecordingMessageMonitor(@Nonnull MessageMonitorReport report) {
        this.report = report;
    }

    public final MessageMonitor.MonitorCallback onMessageIngested(final @NotNull Message message) {
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                RecordingMessageMonitor.this.onReportSuccess(message);
                RecordingMessageMonitor.this.report.add(MessageMonitorReport.success(message));
            }

            public void reportFailure(Throwable cause) {
                RecordingMessageMonitor.this.onReportFailure(message, cause);
                RecordingMessageMonitor.this.report.add(MessageMonitorReport.failure(message, cause));
            }

            public void reportIgnored() {
                RecordingMessageMonitor.this.onReportIgnored(message);
                RecordingMessageMonitor.this.report.add(MessageMonitorReport.ignored(message));
            }
        };
    }

    public MessageMonitorReport report() {
        return this.report;
    }

    protected void onReportSuccess(@Nonnull Message message) {
    }

    protected void onReportFailure(@Nonnull Message message, @Nonnull Throwable cause) {
    }

    protected void onReportIgnored(@Nonnull Message message) {
    }
}

