/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.axonframework.common.Registration;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.EventStoreTransaction;
import org.axonframework.eventstreaming.StreamingCondition;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.test.fixture.RecordingEventSink;
import org.jetbrains.annotations.NotNull;

@Internal
public class RecordingEventStore
extends RecordingEventSink
implements EventStore {
    private final EventStore eventStore;

    public RecordingEventStore(@Nonnull EventStore delegate) {
        super((EventSink)Objects.requireNonNull(delegate, "The delegate EventStore may not be null"));
        this.eventStore = delegate;
    }

    public EventStoreTransaction transaction(@NotNull ProcessingContext processingContext) {
        return this.eventStore.transaction(processingContext);
    }

    @Override
    public void describeTo(@NotNull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
    }

    public MessageStream<EventMessage> open(@Nonnull StreamingCondition condition, @Nullable ProcessingContext context) {
        return this.eventStore.open(condition, context);
    }

    public CompletableFuture<TrackingToken> firstToken(@Nullable ProcessingContext context) {
        return this.eventStore.firstToken(context);
    }

    public CompletableFuture<TrackingToken> latestToken(@Nullable ProcessingContext context) {
        return this.eventStore.latestToken(context);
    }

    public CompletableFuture<TrackingToken> tokenAt(@Nonnull Instant at, @Nullable ProcessingContext context) {
        return this.eventStore.tokenAt(at, context);
    }

    public Registration subscribe(@Nonnull BiFunction<List<? extends EventMessage>, ProcessingContext, CompletableFuture<?>> eventsBatchConsumer) {
        return this.eventStore.subscribe(eventsBatchConsumer);
    }
}

