/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Consumer;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.messaging.Message;
import org.axonframework.test.fixture.AxonTestFixture;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.AxonTestThenMessage;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;
import org.axonframework.test.fixture.Reporter;
import org.axonframework.test.matchers.PayloadMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;

class AxonTestThenCommand
extends AxonTestThenMessage<AxonTestPhase.Then.Command>
implements AxonTestPhase.Then.Command {
    private final Reporter reporter = new Reporter();
    private final Message actualResult;

    public AxonTestThenCommand(@Nonnull AxonConfiguration configuration, @Nonnull AxonTestFixture.Customization customization, @Nonnull RecordingCommandBus commandBus, @Nonnull RecordingEventSink eventSink, @Nonnull Message lastCommandResult, @Nullable Throwable lastCommandException) {
        super(configuration, customization, commandBus, eventSink, lastCommandException);
        this.actualResult = lastCommandResult;
    }

    @Override
    public AxonTestPhase.Then.Command success() {
        return this.resultMessageSatisfies(c -> {});
    }

    @Override
    public AxonTestPhase.Then.Command resultMessageSatisfies(@Nonnull Consumer<? super CommandResultMessage> consumer) {
        StringDescription expectedDescription = new StringDescription();
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)expectedDescription);
        }
        try {
            consumer.accept((CommandResultMessage)((CommandResultMessage)this.actualResult));
        }
        catch (AssertionError e) {
            this.reporter.reportWrongResult(this.actualResult, "Result message to satisfy custom assertions: " + ((Throwable)((Object)e)).getMessage());
        }
        return this;
    }

    @Override
    public AxonTestPhase.Then.Command resultMessagePayload(@Nonnull Object expectedPayload) {
        StringDescription expectedDescription = new StringDescription();
        StringDescription actualDescription = new StringDescription();
        PayloadMatcher expectedMatcher = new PayloadMatcher(CoreMatchers.equalTo((Object)expectedPayload));
        expectedMatcher.describeTo((Description)expectedDescription);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)expectedDescription);
        } else if (!this.verifyPayloadEquality(expectedPayload, this.actualResult.payload())) {
            PayloadMatcher actualMatcher = new PayloadMatcher(CoreMatchers.equalTo((Object)this.actualResult.payload()));
            actualMatcher.describeTo((Description)actualDescription);
            this.reporter.reportWrongResult(actualDescription, expectedDescription);
        }
        return this;
    }

    @Override
    public AxonTestPhase.Then.Command resultMessagePayloadSatisfies(@Nonnull Consumer<Object> consumer) {
        StringDescription expectedDescription = new StringDescription();
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)expectedDescription);
        }
        try {
            Object payload = this.actualResult.payload();
            consumer.accept(payload);
        }
        catch (AssertionError e) {
            this.reporter.reportWrongResult(this.actualResult.payload(), "Result message to satisfy custom assertions: " + ((Throwable)((Object)e)).getMessage());
        }
        return this;
    }

    @Override
    public AxonTestPhase.Then.Command exception(@Nonnull Class<? extends Throwable> type) {
        StringDescription description = new StringDescription();
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualResult == null ? null : this.actualResult.payload(), (Description)description);
        }
        return (AxonTestPhase.Then.Command)super.exception((Class)type);
    }

    @Override
    public AxonTestPhase.Then.Command exception(@Nonnull Class<? extends Throwable> type, @Nonnull String message) {
        StringDescription description = new StringDescription();
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualResult == null ? null : this.actualResult.payload(), (Description)description);
        }
        return (AxonTestPhase.Then.Command)super.exception((Class)type, message);
    }

    @Override
    public AxonTestPhase.Then.Command exceptionSatisfies(@Nonnull Consumer<Throwable> consumer) {
        StringDescription description = new StringDescription();
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualResult == null ? null : this.actualResult.payload(), (Description)description);
        }
        return (AxonTestPhase.Then.Command)super.exceptionSatisfies((Consumer)consumer);
    }
}

