/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.configuration.ApplicationConfigurer;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.fixture.AxonTestGiven;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.AxonTestWhen;
import org.axonframework.test.fixture.MessagesRecordingConfigurationEnhancer;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;

public class AxonTestFixture
implements AxonTestPhase.Setup {
    private final AxonConfiguration configuration;
    private final Customization customization;
    private final RecordingCommandBus commandBus;
    private final RecordingEventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;
    private final UnitOfWorkFactory unitOfWorkFactory;

    public AxonTestFixture(@Nonnull AxonConfiguration configuration, @Nonnull Customization customization) {
        this.customization = Objects.requireNonNull(customization, "Customization may not be null.");
        this.configuration = Objects.requireNonNull(configuration, "Configuration may not be null.");
        CommandBus commandBusComponent = (CommandBus)configuration.getComponent(CommandBus.class);
        if (!(commandBusComponent instanceof RecordingCommandBus)) {
            throw new FixtureExecutionException("CommandBus is not a RecordingCommandBus. This may happen in Spring environments where the MessagesRecordingConfigurationEnhancer is not properly registered. Please declare MessagesRecordingConfigurationEnhancer as a bean in your test context. Note: This configuration may be subject to change until the 5.0.0 release.");
        }
        this.commandBus = (RecordingCommandBus)commandBusComponent;
        EventSink eventSinkComponent = (EventSink)configuration.getComponent(EventSink.class);
        if (!(eventSinkComponent instanceof RecordingEventSink)) {
            throw new FixtureExecutionException("EventSink is not a RecordingEventSink. This may happen in Spring environments where the MessagesRecordingConfigurationEnhancer is not properly registered. Please declare MessagesRecordingConfigurationEnhancer as a bean in your test context. Note: This configuration may be subject to change until the 5.0.0 release.");
        }
        this.eventSink = (RecordingEventSink)eventSinkComponent;
        this.messageTypeResolver = (MessageTypeResolver)configuration.getComponent(MessageTypeResolver.class);
        this.unitOfWorkFactory = (UnitOfWorkFactory)configuration.getComponent(UnitOfWorkFactory.class);
    }

    public static AxonTestFixture with(@Nonnull ApplicationConfigurer configurer) {
        return AxonTestFixture.with(configurer, c -> c);
    }

    public static AxonTestFixture with(@Nonnull ApplicationConfigurer configurer, @Nonnull UnaryOperator<Customization> customization) {
        Objects.requireNonNull(configurer, "Configurer may not be null");
        Objects.requireNonNull(customization, "Customization may not be null");
        Customization fixtureConfiguration = (Customization)customization.apply(new Customization());
        if (!fixtureConfiguration.axonServerEnabled()) {
            configurer = configurer.componentRegistry(cr -> cr.disableEnhancer("org.axonframework.axonserver.connector.AxonServerConfigurationEnhancer"));
        }
        AxonConfiguration configuration = configurer.componentRegistry(cr -> cr.registerEnhancer((ConfigurationEnhancer)new MessagesRecordingConfigurationEnhancer())).start();
        return new AxonTestFixture(configuration, fixtureConfiguration);
    }

    @Override
    public AxonTestPhase.Given given() {
        return new AxonTestGiven(this.configuration, this.customization, this.commandBus, this.eventSink, this.messageTypeResolver, this.unitOfWorkFactory);
    }

    @Override
    public AxonTestPhase.When when() {
        return new AxonTestWhen(this.configuration, this.customization, this.commandBus, this.eventSink, this.messageTypeResolver, this.unitOfWorkFactory);
    }

    @Override
    public void stop() {
        this.configuration.shutdown();
    }

    public record Customization(boolean axonServerEnabled, @Nonnull List<FieldFilter> fieldFilters) {
        public Customization() {
            this(true, new ArrayList<FieldFilter>());
        }

        public Customization registerFieldFilter(@Nonnull FieldFilter fieldFilter) {
            ArrayList<FieldFilter> fieldFiltersCopy = new ArrayList<FieldFilter>(this.fieldFilters);
            fieldFiltersCopy.add(fieldFilter);
            return new Customization(this.axonServerEnabled, fieldFiltersCopy);
        }

        public Customization registerIgnoredField(@Nonnull Class<?> declaringClass, @Nonnull String fieldName) {
            return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
        }

        public Customization disableAxonServer() {
            return new Customization(false, this.fieldFilters);
        }

        public boolean axonServerDisabled() {
            return !this.axonServerEnabled;
        }
    }
}

