/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.EventSink;

@Internal
public class RecordingEventSink
implements EventSink {
    private final List<EventMessage> recorded = new CopyOnWriteArrayList<EventMessage>();
    protected final EventSink delegate;

    public RecordingEventSink(@Nonnull EventSink delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate EventSink may not be null");
    }

    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
        return this.delegate.publish(context, events).thenRun(() -> this.recorded.addAll(events));
    }

    public List<EventMessage> recorded() {
        return List.copyOf(this.recorded);
    }

    public RecordingEventSink reset() {
        this.recorded.clear();
        return this;
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
        descriptor.describeProperty("recorded", this.recorded);
    }
}

