/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.axonframework.common.configuration.AxonConfiguration;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.GenericCommandMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.core.unitofwork.UnitOfWork;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.GenericEventMessage;
import org.axonframework.test.fixture.AxonTestFixture;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.AxonTestThenCommand;
import org.axonframework.test.fixture.AxonTestThenEvent;
import org.axonframework.test.fixture.AxonTestThenNothing;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;

class AxonTestWhen
implements AxonTestPhase.When {
    private final AxonConfiguration configuration;
    private final AxonTestFixture.Customization customization;
    private final RecordingCommandBus commandBus;
    private final RecordingEventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;
    private final UnitOfWorkFactory unitOfWorkFactory;
    private Message actualResult;
    private Throwable actualException;

    public AxonTestWhen(@Nonnull AxonConfiguration configuration, @Nonnull AxonTestFixture.Customization customization, @Nonnull RecordingCommandBus commandBus, @Nonnull RecordingEventSink eventSink, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull UnitOfWorkFactory unitOfWorkFactory) {
        this.configuration = configuration;
        this.customization = customization;
        this.commandBus = commandBus.reset();
        this.eventSink = eventSink.reset();
        this.messageTypeResolver = messageTypeResolver;
        this.unitOfWorkFactory = unitOfWorkFactory;
    }

    @Override
    public Command command(@Nonnull Object payload, @Nonnull Metadata metadata) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        GenericCommandMessage message = new GenericCommandMessage(messageType, payload, (Map)metadata);
        this.inUnitOfWorkOnInvocation(processingContext -> this.commandBus.dispatch((CommandMessage)message, (ProcessingContext)processingContext).whenComplete((r, e) -> {
            if (e == null) {
                this.actualResult = r;
                this.actualException = null;
            } else {
                this.actualResult = null;
                this.actualException = e.getCause();
            }
        }));
        return new Command();
    }

    @Override
    public Event event(@Nonnull Object payload, @Nonnull Metadata metadata) {
        GenericEventMessage eventMessage = this.toGenericEventMessage(payload, metadata);
        return this.events(new EventMessage[]{eventMessage});
    }

    private GenericEventMessage toGenericEventMessage(Object payload, Metadata metadata) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        return new GenericEventMessage(messageType, payload, (Map)metadata);
    }

    @Override
    public Event events(List<?> ... events) {
        EventMessage[] messages = (EventMessage[])Arrays.stream(events).map(e -> {
            EventMessage message;
            return e instanceof EventMessage ? (message = (EventMessage)e) : this.toGenericEventMessage(e, Metadata.emptyInstance());
        }).toArray(EventMessage[]::new);
        return this.events(messages);
    }

    @Override
    public Event events(EventMessage ... messages) {
        this.inUnitOfWorkOnInvocation(processingContext -> this.eventSink.publish((ProcessingContext)processingContext, messages));
        return new Event();
    }

    private void inUnitOfWorkOnInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        UnitOfWork unitOfWork = this.unitOfWorkFactory.create();
        unitOfWork.onInvocation(action);
        this.awaitCompletion(unitOfWork.execute());
    }

    private void awaitCompletion(CompletableFuture<?> completion) {
        try {
            completion.join();
        }
        catch (Exception e) {
            this.actualResult = null;
            this.actualException = e.getCause();
        }
    }

    @Override
    public AxonTestPhase.When.Nothing nothing() {
        return new Nothing();
    }

    class Command
    implements AxonTestPhase.When.Command {
        Command() {
        }

        @Override
        public AxonTestPhase.Then.Command then() {
            return new AxonTestThenCommand(AxonTestWhen.this.configuration, AxonTestWhen.this.customization, AxonTestWhen.this.commandBus, AxonTestWhen.this.eventSink, AxonTestWhen.this.actualResult, AxonTestWhen.this.actualException);
        }
    }

    class Event
    implements AxonTestPhase.When.Event {
        Event() {
        }

        @Override
        public AxonTestPhase.Then.Event then() {
            return new AxonTestThenEvent(AxonTestWhen.this.configuration, AxonTestWhen.this.customization, AxonTestWhen.this.commandBus, AxonTestWhen.this.eventSink, AxonTestWhen.this.actualException);
        }
    }

    class Nothing
    implements AxonTestPhase.When.Nothing {
        Nothing() {
        }

        @Override
        public AxonTestPhase.Then.Nothing then() {
            return new AxonTestThenNothing(AxonTestWhen.this.configuration, AxonTestWhen.this.customization, AxonTestWhen.this.commandBus, AxonTestWhen.this.eventSink, AxonTestWhen.this.actualException);
        }
    }
}

