/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.utils;

import jakarta.annotation.Nonnull;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.messaging.Message;
import org.jetbrains.annotations.NotNull;

public class MessageMonitorReport
extends AbstractList<Report> {
    private final List<Report> delegate = new CopyOnWriteArrayList<Report>();

    public static Report.Success success(Message message) {
        return new Report.Success(message);
    }

    public static Report.Ignored ignored(Message message) {
        return new Report.Ignored(message);
    }

    public static Report.Failure failure(Message message, Throwable cause) {
        return new Report.Failure(message, cause);
    }

    @Override
    public void add(int index, @Nonnull Report report) {
        this.delegate.add(index, report);
    }

    @Override
    public Report get(int index) {
        return this.delegate.get(index);
    }

    public List<Report.Success> successReports() {
        return this.delegate.stream().filter(Report.Success.class::isInstance).map(Report.Success.class::cast).toList();
    }

    public List<Report.Failure> failureReports() {
        return this.delegate.stream().filter(Report.Failure.class::isInstance).map(Report.Failure.class::cast).toList();
    }

    public List<Report.Ignored> ignoredReports() {
        return this.delegate.stream().filter(Report.Ignored.class::isInstance).map(Report.Ignored.class::cast).toList();
    }

    @Override
    @NotNull
    public Iterator<Report> iterator() {
        return Collections.unmodifiableList(this.delegate).iterator();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public static sealed interface Report {
        public Message message();

        public record Ignored(Message message) implements Report
        {
        }

        public record Failure(Message message, Throwable cause) implements Report
        {
        }

        public record Success(Message message) implements Report
        {
        }
    }
}

