/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.configuration.AxonConfiguration;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWorkFactory;
import org.axonframework.test.fixture.AxonTestFixture;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.AxonTestThenNothing;
import org.axonframework.test.fixture.AxonTestWhen;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;

class AxonTestGiven
implements AxonTestPhase.Given {
    private final AxonConfiguration configuration;
    private final AxonTestFixture.Customization customization;
    private final RecordingCommandBus commandBus;
    private final RecordingEventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;
    private final UnitOfWorkFactory unitOfWorkFactory;

    AxonTestGiven(@Nonnull AxonConfiguration configuration, @Nonnull AxonTestFixture.Customization customization, @Nonnull RecordingCommandBus commandBus, @Nonnull RecordingEventSink eventSink, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull UnitOfWorkFactory unitOfWorkFactory) {
        this.configuration = configuration;
        this.customization = customization;
        this.commandBus = commandBus;
        this.eventSink = eventSink;
        this.messageTypeResolver = messageTypeResolver;
        this.unitOfWorkFactory = unitOfWorkFactory;
    }

    @Override
    public AxonTestPhase.Given noPriorActivity() {
        return this;
    }

    @Override
    public AxonTestPhase.Given event(@Nonnull Object payload, @Nonnull Metadata metadata) {
        GenericEventMessage eventMessage = this.toGenericEventMessage(payload, metadata);
        return this.events(new EventMessage[]{eventMessage});
    }

    private GenericEventMessage toGenericEventMessage(Object payload, Metadata metadata) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        return new GenericEventMessage(messageType, payload, (Map)metadata);
    }

    @Override
    public AxonTestPhase.Given events(@Nonnull List<?> events) {
        EventMessage[] messages = (EventMessage[])events.stream().map(e -> {
            EventMessage message;
            return e instanceof EventMessage ? (message = (EventMessage)e) : this.toGenericEventMessage(e, Metadata.emptyInstance());
        }).toArray(EventMessage[]::new);
        return this.events(messages);
    }

    @Override
    public AxonTestPhase.Given events(EventMessage ... messages) {
        this.inUnitOfWorkOnInvocation(processingContext -> this.eventSink.publish((ProcessingContext)processingContext, messages));
        return this;
    }

    private void inUnitOfWorkOnInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        UnitOfWork unitOfWork = this.unitOfWorkFactory.create();
        unitOfWork.onInvocation(action);
        unitOfWork.execute().join();
    }

    @Override
    public AxonTestPhase.Given command(@Nonnull Object payload, @Nonnull Metadata metadata) {
        GenericCommandMessage commandMessage = this.toGenericCommandMessage(payload, metadata);
        return this.commands(new CommandMessage[]{commandMessage});
    }

    @Override
    public AxonTestPhase.Given commands(@Nonnull List<?> commands) {
        CommandMessage[] messages = (CommandMessage[])commands.stream().map(c -> {
            CommandMessage message;
            return c instanceof CommandMessage ? (message = (CommandMessage)c) : this.toGenericCommandMessage(c, Metadata.emptyInstance());
        }).toArray(CommandMessage[]::new);
        return this.commands(messages);
    }

    @Override
    public AxonTestPhase.Given execute(@Nonnull Function<Configuration, ?> function) {
        function.apply((Configuration)this.configuration);
        return this;
    }

    @Override
    public AxonTestPhase.Given executeAsync(@Nonnull Function<Configuration, CompletableFuture<?>> function) {
        function.apply((Configuration)this.configuration).join();
        return this;
    }

    private GenericCommandMessage toGenericCommandMessage(@Nonnull Object payload, @Nonnull Metadata metadata) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        return new GenericCommandMessage(messageType, payload, (Map)metadata);
    }

    @Override
    public AxonTestPhase.Given commands(CommandMessage ... messages) {
        for (CommandMessage message : messages) {
            this.inUnitOfWorkOnInvocation(processingContext -> this.commandBus.dispatch(message, (ProcessingContext)processingContext));
        }
        return this;
    }

    @Override
    public AxonTestPhase.When when() {
        return new AxonTestWhen(this.configuration, this.customization, this.commandBus, this.eventSink, this.messageTypeResolver, this.unitOfWorkFactory);
    }

    @Override
    public AxonTestPhase.Then.Nothing then() {
        return new AxonTestThenNothing(this.configuration, this.customization, this.commandBus, this.eventSink, null);
    }
}

