/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;

public class AxonAssertionError
extends AssertionError {
    private static final long serialVersionUID = 3731933425096971345L;

    public AxonAssertionError(@Nonnull String detailMessage) {
        super((Object)detailMessage);
        StackTraceElement[] original = this.getStackTrace();
        this.setStackTrace(this.cleanStackTrace(original));
    }

    public AxonAssertionError(@Nonnull String detailMessage, @Nonnull Throwable cause) {
        super(Objects.requireNonNull(detailMessage), Objects.requireNonNull(cause));
        StackTraceElement[] original = this.getStackTrace();
        this.setStackTrace(this.cleanStackTrace(original));
    }

    private StackTraceElement[] cleanStackTrace(StackTraceElement[] original) {
        int ignoreCount = 0;
        for (StackTraceElement element : original) {
            if (!element.getClassName().startsWith("org.axonframework.test")) break;
            ++ignoreCount;
        }
        return Arrays.copyOfRange(original, ignoreCount, original.length);
    }
}

