/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;

public class RecordingListenerInvocationErrorHandler
implements ListenerInvocationErrorHandler {
    private ListenerInvocationErrorHandler listenerInvocationErrorHandler;
    private boolean started = false;
    private Exception exception;
    private boolean failOnErrorInPreparation = true;

    public RecordingListenerInvocationErrorHandler(ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        if (listenerInvocationErrorHandler == null) {
            throw new IllegalArgumentException("listenerInvocationErrorHandler cannot be null");
        }
        this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
    }

    public void onError(@Nonnull Exception exception, @Nonnull EventMessage<?> event, @Nonnull EventMessageHandler eventHandler) throws Exception {
        if (!this.started && this.failOnErrorInPreparation) {
            throw exception;
        }
        this.exception = exception;
        this.listenerInvocationErrorHandler.onError(exception, event, eventHandler);
    }

    public void startRecording() {
        this.started = true;
        this.exception = null;
    }

    public void setListenerInvocationErrorHandler(ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        if (listenerInvocationErrorHandler == null) {
            throw new IllegalArgumentException("listenerInvocationErrorHandler cannot be null");
        }
        this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public void failOnErrorInPreparation(boolean failOnErrorInPreparation) {
        this.failOnErrorInPreparation = failOnErrorInPreparation;
    }
}

