/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.matchers;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Objects;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.test.matchers.AllFieldsFilter;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.MatcherExecutionException;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepEqualsMatcher<T>
extends BaseMatcher<T> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final T expected;
    private final FieldFilter filter;
    private boolean noneMatchingTypes = false;
    private boolean noneMatchingEquals = false;
    private Field failedField;
    private Object failedFieldExpected;
    private Object failedFieldActual;
    private boolean failedForAccessibilityException;

    public DeepEqualsMatcher(T expected) {
        this(expected, AllFieldsFilter.instance());
    }

    public DeepEqualsMatcher(T expected, FieldFilter filter) {
        BuilderUtils.assertNonNull(expected, (String)"The expected value should be non-null.");
        this.expected = expected;
        this.filter = filter;
    }

    public boolean matches(Object actual) {
        if (!this.matchingTypes(actual)) {
            this.noneMatchingTypes = true;
            return false;
        }
        if (Objects.equals(this.expected, actual)) {
            return true;
        }
        if (ReflectionUtils.hasEqualsMethod(actual.getClass()) && this.defaultFilterUsed()) {
            this.noneMatchingEquals = true;
            return false;
        }
        return this.matchingFields(this.expected.getClass(), this.expected, actual);
    }

    private boolean matchingTypes(Object actual) {
        return this.expected.getClass().isInstance(actual) && this.expected.getClass().equals(actual.getClass());
    }

    private boolean defaultFilterUsed() {
        return this.filter == AllFieldsFilter.instance();
    }

    private boolean matchingFields(Class<?> aClass, Object expectedValue, Object actual) {
        boolean match = true;
        for (Field field : aClass.getDeclaredFields()) {
            if (!this.filter.accept(field)) continue;
            try {
                field.setAccessible(true);
                Object expectedFieldValue = field.get(expectedValue);
                Object actualFieldValue = field.get(actual);
                if (Objects.deepEquals(expectedFieldValue, actualFieldValue)) continue;
                this.failedField = field;
                this.failedFieldExpected = expectedFieldValue;
                this.failedFieldActual = actualFieldValue;
                return false;
            }
            catch (Exception e) {
                if ("InaccessibleObjectException".equals(e.getClass().getSimpleName())) {
                    logger.warn("Could not confirm object field equality due to InaccessibleObjectException.");
                    this.failedForAccessibilityException = true;
                    return false;
                }
                throw new MatcherExecutionException("Could not confirm object equality due to an exception.", e);
            }
        }
        if (aClass.getSuperclass() != Object.class) {
            match = this.matchingFields(aClass.getSuperclass(), expectedValue, actual);
        }
        return match;
    }

    public void describeTo(Description description) {
        description.appendText(this.expected.getClass().getName());
        if (this.noneMatchingTypes) {
            description.appendText(" does not match with the actual type.");
        } else if (this.noneMatchingEquals) {
            description.appendText(" does not equal with the actual instance.");
        } else if (this.failedField != null) {
            description.appendText(" (failed on field '").appendText(this.failedField.getName()).appendText("').").appendText(" Expected field value [").appendValue(this.failedFieldExpected).appendText("], but actual field value was [").appendValue(this.failedFieldActual).appendText("].");
        } else if (this.failedForAccessibilityException) {
            description.appendText(" failed during field equality with InaccessibleObjectException. ").appendText("The cause for this is that the matched object does not allow reflective access.");
        }
    }
}

