/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.axonframework.common.Assert;
import org.junit.jupiter.api.Assertions;

public class AxonServerContainerUtils {
    public static final boolean DCB_CONTEXT = true;
    public static final boolean NO_DCB_CONTEXT = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCluster(String hostname, int port, boolean shouldBeReused) throws IOException {
        if (shouldBeReused && AxonServerContainerUtils.initialized(hostname, port)) {
            return;
        }
        URL url = URI.create(String.format("http://%s:%d/v2/cluster/init", hostname, port)).toURL();
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.getInputStream().close();
            int responseCode = connection.getResponseCode();
            Assert.isTrue((202 == responseCode ? 1 : 0) != 0, () -> "The response code [" + responseCode + "] did not match 202.");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        AxonServerContainerUtils.waitForContextsCondition(hostname, port, contexts -> contexts.contains("_admin") && contexts.contains("default"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> contexts(String hostname, int port) throws IOException {
        URL url = URI.create(String.format("http://%s:%d/v1/public/context", hostname, port)).toURL();
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            Assert.isTrue((200 == responseCode ? 1 : 0) != 0, () -> "The response code [" + responseCode + "] did not match 200.");
            List<String> list = AxonServerContainerUtils.contexts(connection);
            return list;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static List<String> contexts(HttpURLConnection connection) throws IOException {
        String outputLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder output = new StringBuilder();
        while ((outputLine = br.readLine()) != null) {
            output.append(outputLine);
        }
        JsonElement jsonElement = JsonParser.parseString((String)output.toString());
        ArrayList<String> contexts = new ArrayList<String>();
        for (JsonElement element : jsonElement.getAsJsonArray()) {
            String context = element.getAsJsonObject().get("context").getAsString();
            contexts.add(context);
        }
        return contexts;
    }

    private static void waitForContextsCondition(String hostname, int port, Predicate<List<String>> condition) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            scheduler.submit(() -> AxonServerContainerUtils.checkContextsCondition(hostname, port, condition, latch, scheduler)).get();
            if (!latch.await(60L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Condition on contexts has not been met!");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            scheduler.shutdown();
        }
    }

    private static void checkContextsCondition(String hostname, int port, Predicate<List<String>> condition, CountDownLatch latch, ScheduledExecutorService scheduler) {
        try {
            if (condition.test(AxonServerContainerUtils.contexts(hostname, port))) {
                latch.countDown();
            } else {
                scheduler.schedule(() -> AxonServerContainerUtils.checkContextsCondition(hostname, port, condition, latch, scheduler), 10L, TimeUnit.MILLISECONDS);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean initialized(String hostname, int port) throws IOException {
        try {
            List<String> cont = AxonServerContainerUtils.contexts(hostname, port);
            return cont.contains("_admin") && cont.contains("default");
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void purgeEventsFromAxonServer(String hostname, int port, String context, boolean dcbContext) throws IOException {
        AxonServerContainerUtils.deleteContext(hostname, port, context);
        AxonServerContainerUtils.createContext(hostname, port, context, dcbContext);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteContext(String hostname, int port, String context) throws IOException {
        URL url = URI.create(String.format("http://%s:%d/v1/context/%s", hostname, port, context)).toURL();
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("DELETE");
            connection.getInputStream().close();
            Assertions.assertEquals((int)202, (int)connection.getResponseCode());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        AxonServerContainerUtils.waitForContextsCondition(hostname, port, contexts -> !contexts.contains(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createContext(String hostname, int port, String context, boolean dcbContext) throws IOException {
        URL url = URI.create(String.format("http://%s:%d/v1/context", hostname, port)).toURL();
        HttpURLConnection connection = null;
        try {
            String jsonRequest = String.format("{\"context\": \"%s\", \"dcbContext\": %b, \"replicationGroup\": \"%s\", \"roles\": [{ \"node\": \"axonserver\", \"role\": \"PRIMARY\" }]}", context, dcbContext, context);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonRequest.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            connection.getInputStream().close();
            Assertions.assertEquals((int)202, (int)connection.getResponseCode());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        AxonServerContainerUtils.waitForContextsCondition(hostname, port, contexts -> contexts.contains(context));
    }
}

