/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.configuration.Configuration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.test.fixture.AxonTestFixture;
import org.axonframework.test.fixture.AxonTestPhase;
import org.axonframework.test.fixture.AxonTestWhen;
import org.axonframework.test.fixture.RecordingCommandBus;
import org.axonframework.test.fixture.RecordingEventSink;

class AxonTestGiven
implements AxonTestPhase.Given {
    private final Configuration configuration;
    private final AxonTestFixture.Customization customization;
    private final RecordingCommandBus commandBus;
    private final RecordingEventSink eventSink;
    private final MessageTypeResolver messageTypeResolver;

    AxonTestGiven(Configuration configuration, AxonTestFixture.Customization customization, RecordingCommandBus commandBus, RecordingEventSink eventSink, MessageTypeResolver messageTypeResolver) {
        this.configuration = configuration;
        this.customization = customization;
        this.commandBus = commandBus;
        this.eventSink = eventSink;
        this.messageTypeResolver = messageTypeResolver;
    }

    @Override
    public AxonTestPhase.Given noPriorActivity() {
        return this;
    }

    @Override
    public AxonTestPhase.Given event(@Nonnull Object payload, @Nonnull MetaData metaData) {
        GenericEventMessage<Object> eventMessage = this.toGenericEventMessage(payload, metaData);
        return this.events(new EventMessage[]{eventMessage});
    }

    private GenericEventMessage<Object> toGenericEventMessage(Object payload, MetaData metaData) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        return new GenericEventMessage(messageType, payload, (Map)metaData);
    }

    @Override
    public AxonTestPhase.Given events(@Nonnull List<?> events) {
        EventMessage[] messages = (EventMessage[])events.stream().map(e -> {
            GenericEventMessage<Object> message;
            return e instanceof EventMessage ? (message = (GenericEventMessage<Object>)e) : this.toGenericEventMessage(e, MetaData.emptyInstance());
        }).toArray(EventMessage[]::new);
        return this.events(messages);
    }

    @Override
    public AxonTestPhase.Given events(EventMessage<?> ... messages) {
        this.inUnitOfWorkRunOnInvocation(processingContext -> this.eventSink.publish((ProcessingContext)processingContext, (EventMessage[])messages));
        return this;
    }

    private void inUnitOfWorkRunOnInvocation(Consumer<ProcessingContext> action) {
        UnitOfWork unitOfWork = new UnitOfWork();
        unitOfWork.runOnInvocation(action);
        unitOfWork.execute().join();
    }

    private void inUnitOfWorkOnInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        UnitOfWork unitOfWork = new UnitOfWork();
        unitOfWork.onInvocation(action);
        unitOfWork.execute().join();
    }

    @Override
    public AxonTestPhase.Given command(@Nonnull Object payload, @Nonnull MetaData metaData) {
        GenericCommandMessage<Object> commandMessage = this.toGenericCommandMessage(payload, metaData);
        return this.commands(new CommandMessage[]{commandMessage});
    }

    @Override
    public AxonTestPhase.Given commands(@Nonnull List<?> commands) {
        CommandMessage[] messages = (CommandMessage[])commands.stream().map(c -> {
            GenericCommandMessage<Object> message;
            return c instanceof CommandMessage ? (message = (GenericCommandMessage<Object>)c) : this.toGenericCommandMessage(c, MetaData.emptyInstance());
        }).toArray(CommandMessage[]::new);
        return this.commands(messages);
    }

    private GenericCommandMessage<Object> toGenericCommandMessage(@Nonnull Object payload, @Nonnull MetaData metaData) {
        MessageType messageType = this.messageTypeResolver.resolveOrThrow(payload);
        return new GenericCommandMessage(messageType, payload, (Map)metaData);
    }

    @Override
    public AxonTestPhase.Given commands(CommandMessage<?> ... messages) {
        for (CommandMessage<?> message : messages) {
            this.inUnitOfWorkOnInvocation(processingContext -> this.commandBus.dispatch(message, (ProcessingContext)processingContext));
        }
        return this;
    }

    @Override
    public AxonTestPhase.When when() {
        return new AxonTestWhen(this.configuration, this.customization, this.messageTypeResolver, this.commandBus, this.eventSink);
    }
}

