/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.deadline;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.messaging.Message;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.deadline.ScheduledDeadlineInfo;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.matchers.FieldFilter;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public class DeadlineManagerValidator {
    private final StubDeadlineManager deadlineManager;
    private final FieldFilter fieldFilter;

    public DeadlineManagerValidator(StubDeadlineManager deadlineManager, FieldFilter fieldFilter) {
        this.deadlineManager = deadlineManager;
        this.fieldFilter = fieldFilter;
    }

    public Instant currentDateTime() {
        return this.deadlineManager.getCurrentDateTime();
    }

    public void assertScheduledDeadlineMatching(Duration duration, Matcher<?> matcher) {
        Instant targetTime = this.currentDateTime().plus(duration);
        this.assertScheduledDeadlineMatching(targetTime, matcher);
    }

    public void assertScheduledDeadlineMatching(Instant scheduledTime, Matcher<?> matcher) {
        List<ScheduledDeadlineInfo> scheduledDeadlines = this.deadlineManager.getScheduledDeadlines();
        for (ScheduledDeadlineInfo scheduledDeadline : scheduledDeadlines) {
            if (!scheduledDeadline.getScheduleTime().equals(scheduledTime) || !matcher.matches(scheduledDeadline.deadlineMessage())) continue;
            return;
        }
        StringDescription expected = new StringDescription();
        StringDescription actual = new StringDescription();
        matcher.describeTo((Description)expected);
        this.describe(scheduledDeadlines, (Description)actual);
        throw new AxonAssertionError(String.format("Did not find a deadline at the given deadline manager.\nExpected <%s> at <%s>,\n but got <%s>.\n", expected, scheduledTime, actual));
    }

    public void assertNoScheduledDeadlineMatching(Matcher<?> matcher) {
        for (ScheduledDeadlineInfo scheduledDeadline : this.deadlineManager.getScheduledDeadlines()) {
            if (!matcher.matches(scheduledDeadline.deadlineMessage())) continue;
            StringDescription unexpected = new StringDescription();
            matcher.describeTo((Description)unexpected);
            throw new AxonAssertionError(String.format("Unexpected matching deadline found at the given deadline manager.\nGot <%s>.\n", unexpected));
        }
    }

    public void assertTriggeredDeadlinesMatching(Matcher<? extends Iterable<?>> matcher) {
        List<ScheduledDeadlineInfo> triggeredDeadlines = this.deadlineManager.getTriggeredDeadlines();
        List deadlineMessages = triggeredDeadlines.stream().map(ScheduledDeadlineInfo::deadlineMessage).collect(Collectors.toList());
        if (!matcher.matches(deadlineMessages)) {
            StringDescription expected = new StringDescription();
            StringDescription actual = new StringDescription();
            matcher.describeTo((Description)expected);
            this.describe(triggeredDeadlines, (Description)actual);
            throw new AxonAssertionError(String.format("Expected deadlines were not triggered at the given deadline manager.\nExpected <%s>,\n but got <%s>.\n", expected, actual));
        }
    }

    public void assertTriggeredDeadlines(Object ... expected) {
        this.assertNumberOfAndMatchTriggeredDeadlines(expected.length, org.axonframework.test.matchers.Matchers.payloadsMatching(org.axonframework.test.matchers.Matchers.exactSequenceOf(this.createEqualToMatchers(expected))));
    }

    public void assertTriggeredDeadlinesWithName(String ... expectedDeadlineNames) {
        this.assertNumberOfAndMatchTriggeredDeadlines(expectedDeadlineNames.length, org.axonframework.test.matchers.Matchers.exactSequenceOf(this.createDeadlineNameMatchers(expectedDeadlineNames)));
    }

    private Matcher<DeadlineMessage<?>>[] createDeadlineNameMatchers(String[] expectedDeadlineNames) {
        ArrayList<Matcher<DeadlineMessage>> matchers = new ArrayList<Matcher<DeadlineMessage>>(expectedDeadlineNames.length);
        for (String deadlineName : expectedDeadlineNames) {
            matchers.add(org.axonframework.test.matchers.Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
        }
        return matchers.toArray(new Matcher[0]);
    }

    public void assertTriggeredDeadlinesOfType(Class<?> ... expectedDeadlineTypes) {
        this.assertNumberOfAndMatchTriggeredDeadlines(expectedDeadlineTypes.length, org.axonframework.test.matchers.Matchers.exactSequenceOf(this.createDeadlineTypeMatchers(expectedDeadlineTypes)));
    }

    private Matcher<Message<?>>[] createDeadlineTypeMatchers(Class<?>[] expectedDeadlineTypes) {
        ArrayList matchers = new ArrayList(expectedDeadlineTypes.length);
        for (Class<?> deadlineType : expectedDeadlineTypes) {
            matchers.add(org.axonframework.test.matchers.Matchers.messageWithPayload(Matchers.any(deadlineType)));
        }
        return matchers.toArray(new Matcher[0]);
    }

    private void assertNumberOfAndMatchTriggeredDeadlines(int numberOfExpectedDeadlines, Matcher<? extends Iterable<?>> deadlinesMatcher) {
        List<ScheduledDeadlineInfo> triggeredDeadlines = this.deadlineManager.getTriggeredDeadlines();
        if (triggeredDeadlines.size() != numberOfExpectedDeadlines) {
            throw new AxonAssertionError(String.format("Got wrong number of triggered deadlines.\nExpected <%s>,\n but got <%s>.", numberOfExpectedDeadlines, triggeredDeadlines.size()));
        }
        this.assertTriggeredDeadlinesMatching(deadlinesMatcher);
    }

    public void assertNoScheduledDeadlines() {
        List<ScheduledDeadlineInfo> scheduledDeadlines = this.deadlineManager.getScheduledDeadlines();
        if (scheduledDeadlines != null && !scheduledDeadlines.isEmpty()) {
            throw new AxonAssertionError("Expected no scheduled deadlines, but got " + scheduledDeadlines.size() + " deadlines.");
        }
    }

    private void describe(List<ScheduledDeadlineInfo> scheduleDeadlines, Description description) {
        if (scheduleDeadlines.isEmpty()) {
            description.appendText("\n<no scheduled events>");
        }
        for (ScheduledDeadlineInfo item : scheduleDeadlines) {
            description.appendText("\n<").appendText(item.deadlineMessage().toString()).appendText("> at <").appendText(DateTimeUtils.formatInstant((TemporalAccessor)item.getScheduleTime())).appendText(">");
        }
    }

    private Matcher<Object>[] createEqualToMatchers(Object[] expected) {
        ArrayList<Matcher<Object>> matchers = new ArrayList<Matcher<Object>>(expected.length);
        for (Object deadline : expected) {
            matchers.add(org.axonframework.test.matchers.Matchers.deepEquals(deadline, this.fieldFilter));
        }
        return matchers.toArray(new Matcher[0]);
    }
}

