/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.fixture;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventSink;
import org.axonframework.messaging.unitofwork.ProcessingContext;

class RecordingEventSink
implements EventSink {
    private final EventSink delegate;
    private final List<EventMessage<?>> recorded;

    RecordingEventSink(EventSink delegate) {
        this.delegate = delegate;
        this.recorded = new ArrayList();
    }

    public void publish(@Nonnull ProcessingContext processingContext, @Nonnull List<EventMessage<?>> events) {
        this.recorded.addAll(events);
        this.delegate.publish(processingContext, events);
    }

    public CompletableFuture<Void> publish(@Nonnull List<EventMessage<?>> events) {
        return this.delegate.publish(events).thenRun(() -> this.recorded.addAll(events));
    }

    public List<EventMessage<?>> recorded() {
        return List.copyOf(this.recorded);
    }

    public RecordingEventSink reset() {
        this.recorded.clear();
        return this;
    }
}

