/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.deadline;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.common.ObjectUtils;
import org.axonframework.common.Registration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.LegacyDefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.deadline.DeadlineConsumer;
import org.axonframework.test.deadline.ScheduledDeadlineInfo;

public class StubDeadlineManager
implements DeadlineManager {
    private final NavigableSet<ScheduledDeadlineInfo> scheduledDeadlines = new TreeSet<ScheduledDeadlineInfo>();
    private final List<ScheduledDeadlineInfo> triggeredDeadlines = new CopyOnWriteArrayList<ScheduledDeadlineInfo>();
    private final AtomicInteger deadlineCounter = new AtomicInteger(0);
    private final List<MessageDispatchInterceptor<? super DeadlineMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final List<MessageHandlerInterceptor<? super DeadlineMessage<?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private Instant currentDateTime;

    public StubDeadlineManager() {
        this(ZonedDateTime.now());
    }

    public StubDeadlineManager(TemporalAccessor currentDateTime) {
        this.currentDateTime = Instant.from(currentDateTime);
    }

    public void initializeAt(TemporalAccessor currentDateTime) throws IllegalStateException {
        if (!this.scheduledDeadlines.isEmpty()) {
            throw new IllegalStateException("Initializing the deadline manager at a specific dateTime must take place before any deadlines are scheduled");
        }
        this.currentDateTime = Instant.from(currentDateTime);
    }

    @Nonnull
    public String schedule(@Nonnull Instant triggerDateTime, @Nonnull String deadlineName, Object payloadOrMessage, @Nonnull ScopeDescriptor deadlineScope) {
        DeadlineMessage scheduledMessage = this.processDispatchInterceptors(StubDeadlineManager.asDeadlineMessage(deadlineName, payloadOrMessage, triggerDateTime));
        this.scheduledDeadlines.add(new ScheduledDeadlineInfo(triggerDateTime, deadlineName, scheduledMessage.getIdentifier(), this.deadlineCounter.getAndIncrement(), scheduledMessage, deadlineScope));
        return scheduledMessage.getIdentifier();
    }

    private static <P> DeadlineMessage<P> asDeadlineMessage(@Nonnull String deadlineName, @Nullable Object messageOrPayload, @Nonnull Instant expiryTime) {
        if (messageOrPayload instanceof Message) {
            return new GenericDeadlineMessage(deadlineName, (Message)messageOrPayload, () -> expiryTime);
        }
        MessageType type = new MessageType(ObjectUtils.nullSafeTypeOf((Object)messageOrPayload));
        return new GenericDeadlineMessage(deadlineName, (Message)new GenericMessage(type, messageOrPayload), () -> expiryTime);
    }

    @Nonnull
    public String schedule(@Nonnull Duration triggerDuration, @Nonnull String deadlineName, Object payloadOrMessage, @Nonnull ScopeDescriptor deadlineScope) {
        return this.schedule(this.currentDateTime.plus(triggerDuration), deadlineName, payloadOrMessage, deadlineScope);
    }

    public void cancelSchedule(@Nonnull String deadlineName, @Nonnull String scheduleId) {
        this.scheduledDeadlines.removeIf(scheduledDeadline -> scheduledDeadline.getDeadlineName().equals(deadlineName) && scheduledDeadline.getScheduleId().equals(scheduleId));
    }

    public void cancelAll(@Nonnull String deadlineName) {
        this.scheduledDeadlines.removeIf(scheduledDeadline -> scheduledDeadline.getDeadlineName().equals(deadlineName));
    }

    public void cancelAllWithinScope(@Nonnull String deadlineName, @Nonnull ScopeDescriptor scope) {
        this.scheduledDeadlines.removeIf(scheduledDeadline -> scheduledDeadline.getDeadlineName().equals(deadlineName) && scheduledDeadline.getDeadlineScope().equals((Object)scope));
    }

    public List<ScheduledDeadlineInfo> getScheduledDeadlines() {
        return new ArrayList<ScheduledDeadlineInfo>(this.scheduledDeadlines);
    }

    public List<ScheduledDeadlineInfo> getTriggeredDeadlines() {
        return Collections.unmodifiableList(this.triggeredDeadlines);
    }

    public Instant getCurrentDateTime() {
        return this.currentDateTime;
    }

    public ScheduledDeadlineInfo advanceToNextTrigger() {
        ScheduledDeadlineInfo nextItem = this.scheduledDeadlines.pollFirst();
        if (nextItem == null) {
            throw new NoSuchElementException("There are no scheduled deadlines");
        }
        if (nextItem.getScheduleTime().isAfter(this.currentDateTime)) {
            this.currentDateTime = nextItem.getScheduleTime();
        }
        this.triggeredDeadlines.add(nextItem);
        return nextItem;
    }

    public void advanceTimeTo(Instant newDateTime, DeadlineConsumer deadlineConsumer) {
        while (!this.scheduledDeadlines.isEmpty() && !((ScheduledDeadlineInfo)this.scheduledDeadlines.first()).getScheduleTime().isAfter(newDateTime)) {
            ScheduledDeadlineInfo scheduledDeadlineInfo = this.advanceToNextTrigger();
            DeadlineMessage<?> consumedMessage = this.consumeDeadline(deadlineConsumer, scheduledDeadlineInfo);
            this.triggeredDeadlines.remove(scheduledDeadlineInfo);
            this.triggeredDeadlines.add(scheduledDeadlineInfo.recreateWithNewMessage(consumedMessage));
        }
        if (newDateTime.isAfter(this.currentDateTime)) {
            this.currentDateTime = newDateTime;
        }
    }

    public void advanceTimeBy(Duration duration, DeadlineConsumer deadlineConsumer) {
        this.advanceTimeTo(this.currentDateTime.plus(duration), deadlineConsumer);
    }

    @Nonnull
    public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super DeadlineMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    @Nonnull
    public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<? super DeadlineMessage<?>> handlerInterceptor) {
        this.handlerInterceptors.add(handlerInterceptor);
        return () -> this.handlerInterceptors.remove(handlerInterceptor);
    }

    private <T> DeadlineMessage<T> processDispatchInterceptors(DeadlineMessage<T> message) {
        DeadlineMessage intercepted = message;
        for (MessageDispatchInterceptor<? super DeadlineMessage<?>> messageDispatchInterceptor : this.dispatchInterceptors) {
            intercepted = (DeadlineMessage)messageDispatchInterceptor.handle((Message)intercepted);
        }
        return intercepted;
    }

    private DeadlineMessage<?> consumeDeadline(DeadlineConsumer deadlineConsumer, ScheduledDeadlineInfo scheduledDeadlineInfo) {
        LegacyDefaultUnitOfWork uow = LegacyDefaultUnitOfWork.startAndGet(scheduledDeadlineInfo.deadlineMessage());
        DefaultInterceptorChain chain = new DefaultInterceptorChain((LegacyUnitOfWork)uow, this.handlerInterceptors, deadlineMessage -> {
            deadlineConsumer.consume(scheduledDeadlineInfo.getDeadlineScope(), (DeadlineMessage<?>)deadlineMessage);
            return deadlineMessage;
        });
        ResultMessage resultMessage = uow.executeWithResult(() -> ((InterceptorChain)chain).proceedSync());
        if (resultMessage.isExceptional()) {
            Throwable e = resultMessage.exceptionResult();
            throw new FixtureExecutionException("Exception occurred while handling the deadline", e);
        }
        return (DeadlineMessage)resultMessage.getPayload();
    }
}

