/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.common.Assert;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.modelling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.deadline.DeadlineManagerValidator;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.eventscheduler.EventSchedulerValidator;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.saga.CommandValidator;
import org.axonframework.test.saga.EventValidator;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.RecordingListenerInvocationErrorHandler;
import org.axonframework.test.saga.RepositoryContentValidator;
import org.axonframework.test.utils.RecordingCommandBus;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;

public class FixtureExecutionResultImpl<T>
implements FixtureExecutionResult {
    private final RepositoryContentValidator<T> repositoryContentValidator;
    private final EventValidator eventValidator;
    private final EventSchedulerValidator eventSchedulerValidator;
    private final DeadlineManagerValidator deadlineManagerValidator;
    private final CommandValidator commandValidator;
    private final FieldFilter fieldFilter;
    private final List<Runnable> onStartRecordingCallbacks;
    private final RecordingListenerInvocationErrorHandler recordingListenerInvocationErrorHandler;

    FixtureExecutionResultImpl(InMemorySagaStore sagaStore, StubEventScheduler eventScheduler, StubDeadlineManager deadlineManager, EventBus eventBus, RecordingCommandBus commandBus, Class<T> sagaType, FieldFilter fieldFilter, RecordingListenerInvocationErrorHandler recordingListenerInvocationErrorHandler) {
        Assertions.assertNotNull((Object)recordingListenerInvocationErrorHandler, (String)"recordingListenerInvocationErrorHandler cannot be null");
        this.fieldFilter = fieldFilter;
        this.recordingListenerInvocationErrorHandler = recordingListenerInvocationErrorHandler;
        this.commandValidator = new CommandValidator(commandBus, fieldFilter);
        this.repositoryContentValidator = new RepositoryContentValidator<T>(sagaType, sagaStore);
        this.eventValidator = new EventValidator(eventBus, fieldFilter);
        this.eventSchedulerValidator = new EventSchedulerValidator(eventScheduler);
        this.deadlineManagerValidator = new DeadlineManagerValidator(deadlineManager, fieldFilter);
        this.onStartRecordingCallbacks = new CopyOnWriteArrayList<Runnable>();
    }

    public void registerStartRecordingCallback(Runnable onStartRecordingCallback) {
        Assert.notNull((Object)onStartRecordingCallback, () -> "onStartRecordingCallback may not be null");
        this.onStartRecordingCallbacks.add(onStartRecordingCallback);
    }

    public void startRecording() {
        this.eventValidator.startRecording();
        this.commandValidator.startRecording();
        this.recordingListenerInvocationErrorHandler.startRecording();
        this.onStartRecordingCallbacks.forEach(Runnable::run);
    }

    @Override
    public FixtureExecutionResult expectActiveSagas(int expected) {
        this.repositoryContentValidator.assertActiveSagas(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertAssociationPresent(associationKey, associationValue.toString());
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoAssociationWith(String associationKey, Object associationValue) {
        this.repositoryContentValidator.assertNoAssociationPresent(associationKey, associationValue.toString());
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEventMatching(Duration duration, Matcher<? super EventMessage<?>> matcher) {
        this.eventSchedulerValidator.assertScheduledEventMatching(duration, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadlineMatching(Duration duration, Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertScheduledDeadlineMatching(duration, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Duration duration, Object applicationEvent) {
        return this.expectScheduledEventMatching(duration, Matchers.messageWithPayload(Matchers.deepEquals(applicationEvent, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadline(Duration duration, Object deadline) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventOfType(Duration duration, Class<?> eventType) {
        return this.expectScheduledEventMatching(duration, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadlineOfType(Duration duration, Class<?> deadlineType) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadlineWithName(Duration duration, String deadlineName) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventMatching(Instant scheduledTime, Matcher<? super EventMessage<?>> matcher) {
        this.eventSchedulerValidator.assertScheduledEventMatching(scheduledTime, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadlineMatching(Instant scheduledTime, Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertScheduledDeadlineMatching(scheduledTime, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectScheduledEvent(Instant scheduledTime, Object applicationEvent) {
        return this.expectScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(applicationEvent, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadline(Instant scheduledTime, Object deadline) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectScheduledEventOfType(Instant scheduledTime, Class<?> eventType) {
        return this.expectScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadlineOfType(Instant scheduledTime, Class<?> deadlineType) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public FixtureExecutionResult expectScheduledDeadlineWithName(Instant scheduledTime, String deadlineName) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommands(Object ... expected) {
        this.commandValidator.assertDispatchedEqualTo(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectDispatchedCommandsMatching(Matcher<? extends List<? super CommandMessage<?>>> matcher) {
        this.commandValidator.assertDispatchedMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoDispatchedCommands() {
        this.commandValidator.assertDispatchedMatching(Matchers.noCommands());
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEvents() {
        this.eventSchedulerValidator.assertNoScheduledEvents();
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEventMatching(Duration durationToScheduledTime, Matcher<? super EventMessage<?>> matcher) {
        this.eventSchedulerValidator.assertNoScheduledEventMatching(durationToScheduledTime, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEvent(Duration durationToScheduledTime, Object event) {
        return this.expectNoScheduledEventMatching(durationToScheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(event, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEventOfType(Duration durationToScheduledTime, Class<?> eventType) {
        return this.expectNoScheduledEventMatching(durationToScheduledTime, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEventMatching(Instant scheduledTime, Matcher<? super EventMessage<?>> matcher) {
        this.eventSchedulerValidator.assertNoScheduledEventMatching(scheduledTime, matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEvent(Instant scheduledTime, Object event) {
        return this.expectNoScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(event, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledEventOfType(Instant scheduledTime, Class<?> eventType) {
        return this.expectNoScheduledEventMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(eventType)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlines() {
        this.deadlineManagerValidator.assertNoScheduledDeadlines();
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineMatching(Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertNoScheduledDeadlineMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineMatching(Duration durationToScheduledTime, Matcher<? super DeadlineMessage<?>> matcher) {
        Instant scheduledTime = this.deadlineManagerValidator.currentDateTime().plus(durationToScheduledTime);
        return this.expectNoScheduledDeadlineMatching(scheduledTime, matcher);
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadline(Duration durationToScheduledTime, Object deadline) {
        return this.expectNoScheduledDeadlineMatching(durationToScheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineOfType(Duration durationToScheduledTime, Class<?> deadlineType) {
        return this.expectNoScheduledDeadlineMatching(durationToScheduledTime, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineWithName(Duration durationToScheduledTime, String deadlineName) {
        return this.expectNoScheduledDeadlineMatching(durationToScheduledTime, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineMatching(Instant scheduledTime, Matcher<? super DeadlineMessage<?>> matcher) {
        return this.expectNoScheduledDeadlineMatching(Matchers.matches(deadlineMessage -> deadlineMessage.getTimestamp().equals(scheduledTime) && matcher.matches(deadlineMessage)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadline(Instant scheduledTime, Object deadline) {
        return this.expectNoScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineOfType(Instant scheduledTime, Class<?> deadlineType) {
        return this.expectNoScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineWithName(Instant scheduledTime, String deadlineName) {
        return this.expectNoScheduledDeadlineMatching(scheduledTime, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineMatching(Instant from, Instant to, Matcher<? super DeadlineMessage<?>> matcher) {
        return this.expectNoScheduledDeadlineMatching(Matchers.matches(deadlineMessage -> !deadlineMessage.getTimestamp().isBefore(from) && !deadlineMessage.getTimestamp().isAfter(to) && matcher.matches(deadlineMessage)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadline(Instant from, Instant to, Object deadline) {
        return this.expectNoScheduledDeadlineMatching(from, to, Matchers.messageWithPayload(Matchers.equalTo(deadline, this.fieldFilter)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineOfType(Instant from, Instant to, Class<?> deadlineType) {
        return this.expectNoScheduledDeadlineMatching(from, to, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public FixtureExecutionResult expectNoScheduledDeadlineWithName(Instant from, Instant to, String deadlineName) {
        return this.expectNoScheduledDeadlineMatching(from, to, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public FixtureExecutionResult expectPublishedEventsMatching(Matcher<? extends List<? super EventMessage<?>>> matcher) {
        this.eventValidator.assertPublishedEventsMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectDeadlinesMetMatching(Matcher<? extends List<? super DeadlineMessage<?>>> matcher) {
        return this.expectTriggeredDeadlinesMatching(matcher);
    }

    @Override
    public FixtureExecutionResult expectTriggeredDeadlinesMatching(Matcher<? extends List<? super DeadlineMessage<?>>> matcher) {
        this.deadlineManagerValidator.assertTriggeredDeadlinesMatching(matcher);
        return this;
    }

    @Override
    public FixtureExecutionResult expectPublishedEvents(Object ... expected) {
        this.eventValidator.assertPublishedEvents(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectDeadlinesMet(Object ... expected) {
        return this.expectTriggeredDeadlines(expected);
    }

    @Override
    public FixtureExecutionResult expectTriggeredDeadlines(Object ... expected) {
        this.deadlineManagerValidator.assertTriggeredDeadlines(expected);
        return this;
    }

    @Override
    public FixtureExecutionResult expectTriggeredDeadlinesWithName(String ... expectedDeadlineNames) {
        this.deadlineManagerValidator.assertTriggeredDeadlinesWithName(expectedDeadlineNames);
        return this;
    }

    @Override
    public FixtureExecutionResult expectTriggeredDeadlinesOfType(Class<?> ... expectedDeadlineTypes) {
        this.deadlineManagerValidator.assertTriggeredDeadlinesOfType(expectedDeadlineTypes);
        return this;
    }

    @Override
    public FixtureExecutionResult expectSuccessfulHandlerExecution() {
        Optional<Exception> throwableOptional = this.recordingListenerInvocationErrorHandler.getException();
        if (throwableOptional.isPresent()) {
            throw new AxonAssertionError(String.format("An exception occurred during event handling: [%s]", throwableOptional.get().getMessage()));
        }
        return this;
    }
}

