/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.gateway.CommandGatewayFactory;
import org.axonframework.commandhandling.gateway.DefaultCommandGateway;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.LoggingErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.SimpleEventBus;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerDefinition;
import org.axonframework.messaging.annotation.MultiHandlerEnhancerDefinition;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.SimpleResourceParameterResolverFactory;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.modelling.saga.AnnotatedSagaManager;
import org.axonframework.modelling.saga.ResourceInjector;
import org.axonframework.modelling.saga.SagaRepository;
import org.axonframework.modelling.saga.SimpleResourceInjector;
import org.axonframework.modelling.saga.repository.AnnotatedSagaRepository;
import org.axonframework.modelling.saga.repository.SagaStore;
import org.axonframework.modelling.saga.repository.inmemory.InMemorySagaStore;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.eventscheduler.StubEventScheduler;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.IgnoreField;
import org.axonframework.test.saga.ContinuedGivenState;
import org.axonframework.test.saga.FixtureConfiguration;
import org.axonframework.test.saga.FixtureExecutionResult;
import org.axonframework.test.saga.FixtureExecutionResultImpl;
import org.axonframework.test.saga.GivenAggregateEventPublisher;
import org.axonframework.test.saga.WhenAggregateEventPublisher;
import org.axonframework.test.saga.WhenState;
import org.axonframework.test.utils.CallbackBehavior;
import org.axonframework.test.utils.RecordingCommandBus;

public class SagaTestFixture<T>
implements FixtureConfiguration,
ContinuedGivenState {
    private final RecordingCommandBus commandBus;
    private EventBus eventBus;
    private final StubEventScheduler eventScheduler;
    private final StubDeadlineManager deadlineManager;
    private final LinkedList<ParameterResolverFactory> registeredParameterResolverFactories = new LinkedList();
    private final LinkedList<HandlerDefinition> registeredHandlerDefinitions = new LinkedList();
    private final LinkedList<HandlerEnhancerDefinition> registeredHandlerEnhancerDefinitions = new LinkedList();
    private ListenerInvocationErrorHandler listenerInvocationErrorHandler;
    private final Class<T> sagaType;
    private final InMemorySagaStore sagaStore;
    private AnnotatedSagaManager<T> sagaManager;
    private final LinkedList<Object> registeredResources = new LinkedList();
    private ResourceInjector resourceInjector;
    private final FixtureExecutionResultImpl<T> fixtureExecutionResult;
    private final Map<Object, AggregateEventPublisherImpl> aggregatePublishers = new HashMap<Object, AggregateEventPublisherImpl>();
    private final MutableFieldFilter fieldFilters = new MutableFieldFilter();
    private boolean transienceCheckEnabled = true;
    private boolean resourcesInitialized = false;

    public SagaTestFixture(Class<T> sagaType) {
        this.commandBus = new RecordingCommandBus();
        this.eventBus = SimpleEventBus.builder().build();
        this.eventScheduler = new StubEventScheduler();
        this.deadlineManager = new StubDeadlineManager();
        this.registeredParameterResolverFactories.add((ParameterResolverFactory)new SimpleResourceParameterResolverFactory(this.registeredResources));
        this.registeredParameterResolverFactories.add(ClasspathParameterResolverFactory.forClass(sagaType));
        this.registeredHandlerDefinitions.add((HandlerDefinition)ClasspathHandlerDefinition.forClass(sagaType));
        this.registeredHandlerEnhancerDefinitions.add((HandlerEnhancerDefinition)ClasspathHandlerEnhancerDefinition.forClass(sagaType));
        this.listenerInvocationErrorHandler = new LoggingErrorHandler();
        this.sagaType = sagaType;
        this.sagaStore = new InMemorySagaStore();
        this.registeredResources.add(this.eventBus);
        this.registeredResources.add(this.commandBus);
        this.registeredResources.add(this.eventScheduler);
        this.registeredResources.add(this.deadlineManager);
        this.registeredResources.add(DefaultCommandGateway.builder().commandBus((CommandBus)this.commandBus).build());
        this.fixtureExecutionResult = new FixtureExecutionResultImpl<T>(this.sagaStore, this.eventScheduler, this.deadlineManager, this.eventBus, this.commandBus, sagaType, this.fieldFilters);
    }

    protected void handleInSaga(EventMessage<?> event) {
        this.ensureSagaResourcesInitialized();
        ResultMessage resultMessage = DefaultUnitOfWork.startAndGet(event).executeWithResult(() -> {
            this.sagaManager.handle(event, Segment.ROOT_SEGMENT);
            return null;
        });
        if (resultMessage.isExceptional()) {
            Throwable e = resultMessage.exceptionResult();
            if (Error.class.isAssignableFrom(e.getClass())) {
                throw (Error)e;
            }
            throw new FixtureExecutionException("Exception occurred while handling an event", e);
        }
    }

    protected void handleDeadline(ScopeDescriptor sagaDescriptor, DeadlineMessage<?> deadlineMessage) throws Exception {
        this.ensureSagaResourcesInitialized();
        this.sagaManager.send(deadlineMessage, sagaDescriptor);
    }

    protected void ensureSagaResourcesInitialized() {
        if (!this.resourcesInitialized) {
            AnnotatedSagaRepository sagaRepository = AnnotatedSagaRepository.builder().sagaType(this.sagaType).parameterResolverFactory(this.getParameterResolverFactory()).handlerDefinition(this.getHandlerDefinition()).sagaStore((SagaStore)this.sagaStore).resourceInjector(this.getResourceInjector()).build();
            this.sagaManager = AnnotatedSagaManager.builder().sagaRepository((SagaRepository)sagaRepository).sagaType(this.sagaType).parameterResolverFactory(this.getParameterResolverFactory()).handlerDefinition(this.getHandlerDefinition()).listenerInvocationErrorHandler(this.listenerInvocationErrorHandler).build();
            this.resourcesInitialized = true;
        }
    }

    private ParameterResolverFactory getParameterResolverFactory() {
        return MultiParameterResolverFactory.ordered(this.registeredParameterResolverFactories);
    }

    private HandlerDefinition getHandlerDefinition() {
        MultiHandlerEnhancerDefinition handlerEnhancerDefinition = MultiHandlerEnhancerDefinition.ordered(this.registeredHandlerEnhancerDefinitions);
        return MultiHandlerDefinition.ordered(this.registeredHandlerDefinitions, (HandlerEnhancerDefinition)handlerEnhancerDefinition);
    }

    private ResourceInjector getResourceInjector() {
        TransienceValidatingResourceInjector defaultResourceInjector = new TransienceValidatingResourceInjector(this.registeredResources, this.transienceCheckEnabled);
        return this.resourceInjector != null ? new WrappingResourceInjector(this.resourceInjector, defaultResourceInjector) : defaultResourceInjector;
    }

    @Override
    public FixtureConfiguration withTransienceCheckDisabled() {
        this.transienceCheckEnabled = false;
        return this;
    }

    @Override
    public FixtureExecutionResult whenTimeElapses(Duration elapsedTime) {
        try {
            this.fixtureExecutionResult.startRecording();
            this.eventScheduler.advanceTimeBy(elapsedTime, this::handleInSaga);
            this.deadlineManager.advanceTimeBy(elapsedTime, this::handleDeadline);
        }
        catch (Exception e) {
            throw new FixtureExecutionException("Exception occurred while trying to advance time and handle scheduled events", e);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public FixtureExecutionResult whenTimeAdvancesTo(Instant newDateTime) {
        try {
            this.fixtureExecutionResult.startRecording();
            this.eventScheduler.advanceTimeTo(newDateTime, this::handleInSaga);
            this.deadlineManager.advanceTimeTo(newDateTime, this::handleDeadline);
        }
        catch (Exception e) {
            throw new FixtureExecutionException("Exception occurred while trying to advance time and handle scheduled events", e);
        }
        return this.fixtureExecutionResult;
    }

    @Override
    public void registerResource(Object resource) {
        this.registeredResources.addFirst(resource);
    }

    @Override
    public FixtureConfiguration registerParameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
        this.registeredParameterResolverFactories.addFirst(parameterResolverFactory);
        return this;
    }

    @Override
    public void setCallbackBehavior(CallbackBehavior callbackBehavior) {
        this.commandBus.setCallbackBehavior(callbackBehavior);
    }

    @Override
    public GivenAggregateEventPublisher givenAggregate(String aggregateIdentifier) {
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState givenAPublished(Object event) {
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this;
    }

    @Override
    public ContinuedGivenState givenCurrentTime(Instant currentTime) {
        this.eventScheduler.initializeAt(currentTime);
        this.deadlineManager.initializeAt(currentTime);
        return this;
    }

    @Override
    public WhenState givenNoPriorActivity() {
        return this;
    }

    @Override
    public GivenAggregateEventPublisher andThenAggregate(String aggregateIdentifier) {
        return this.givenAggregate(aggregateIdentifier);
    }

    @Override
    public ContinuedGivenState andThenTimeElapses(Duration elapsedTime) {
        this.eventScheduler.advanceTimeBy(elapsedTime, this::handleInSaga);
        this.deadlineManager.advanceTimeBy(elapsedTime, this::handleDeadline);
        return this;
    }

    @Override
    public ContinuedGivenState andThenTimeAdvancesTo(Instant newDateTime) {
        this.eventScheduler.advanceTimeTo(newDateTime, this::handleInSaga);
        this.deadlineManager.advanceTimeTo(newDateTime, this::handleDeadline);
        return this;
    }

    @Override
    public ContinuedGivenState andThenAPublished(Object event) {
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this;
    }

    @Override
    public ContinuedGivenState andThenAPublished(Object event, Map<String, ?> metaData) {
        EventMessage msg = GenericEventMessage.asEventMessage((Object)event).andMetaData(metaData);
        this.handleInSaga(this.timeCorrectedEventMessage(msg));
        return this;
    }

    @Override
    public WhenAggregateEventPublisher whenAggregate(String aggregateIdentifier) {
        this.fixtureExecutionResult.startRecording();
        return this.getPublisherFor(aggregateIdentifier);
    }

    @Override
    public FixtureExecutionResult whenPublishingA(Object event) {
        this.fixtureExecutionResult.startRecording();
        this.handleInSaga(this.timeCorrectedEventMessage(event));
        return this.fixtureExecutionResult;
    }

    @Override
    public FixtureExecutionResult whenPublishingA(Object event, Map<String, ?> metaData) {
        EventMessage msg = GenericEventMessage.asEventMessage((Object)event).andMetaData(metaData);
        this.fixtureExecutionResult.startRecording();
        this.handleInSaga(this.timeCorrectedEventMessage(msg));
        return this.fixtureExecutionResult;
    }

    private EventMessage<Object> timeCorrectedEventMessage(Object event) {
        EventMessage msg = GenericEventMessage.asEventMessage((Object)event);
        return new GenericEventMessage(msg.getIdentifier(), msg.getPayload(), (Map)msg.getMetaData(), this.currentTime());
    }

    @Override
    public Instant currentTime() {
        return this.eventScheduler.getCurrentDateTime();
    }

    public <I> I registerCommandGateway(Class<I> gatewayInterface) {
        return this.registerCommandGateway(gatewayInterface, (I)null);
    }

    public <I> I registerCommandGateway(Class<I> gatewayInterface, I stubImplementation) {
        StubAwareCommandGatewayFactory factory = StubAwareCommandGatewayFactory.builder().commandBus(this.commandBus).stubImplementation(stubImplementation).build();
        Object gateway = factory.createGateway(gatewayInterface);
        this.registerResource(gateway);
        return (I)gateway;
    }

    @Override
    public FixtureConfiguration registerFieldFilter(FieldFilter fieldFilter) {
        this.fieldFilters.add(fieldFilter);
        return this;
    }

    @Override
    public FixtureConfiguration registerIgnoredField(Class<?> declaringClass, String fieldName) {
        return this.registerFieldFilter(new IgnoreField(declaringClass, fieldName));
    }

    @Override
    public FixtureConfiguration registerHandlerDefinition(HandlerDefinition handlerDefinition) {
        this.registeredHandlerDefinitions.addFirst(handlerDefinition);
        return this;
    }

    @Override
    public FixtureConfiguration registerHandlerEnhancerDefinition(HandlerEnhancerDefinition handlerEnhancerDefinition) {
        this.registeredHandlerEnhancerDefinitions.addFirst(handlerEnhancerDefinition);
        return this;
    }

    @Override
    public FixtureConfiguration registerDeadlineDispatchInterceptor(MessageDispatchInterceptor<DeadlineMessage<?>> deadlineDispatchInterceptor) {
        this.deadlineManager.registerDispatchInterceptor(deadlineDispatchInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration registerDeadlineHandlerInterceptor(MessageHandlerInterceptor<DeadlineMessage<?>> deadlineHandlerInterceptor) {
        this.deadlineManager.registerHandlerInterceptor(deadlineHandlerInterceptor);
        return this;
    }

    @Override
    public FixtureConfiguration registerStartRecordingCallback(Runnable onStartRecordingCallback) {
        this.fixtureExecutionResult.registerStartRecordingCallback(onStartRecordingCallback);
        return this;
    }

    @Override
    public FixtureConfiguration registerListenerInvocationErrorHandler(ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
        this.listenerInvocationErrorHandler = listenerInvocationErrorHandler;
        return this;
    }

    @Override
    public FixtureConfiguration registerResourceInjector(ResourceInjector resourceInjector) {
        this.resourceInjector = resourceInjector;
        return this;
    }

    private AggregateEventPublisherImpl getPublisherFor(String aggregateIdentifier) {
        if (!this.aggregatePublishers.containsKey(aggregateIdentifier)) {
            this.aggregatePublishers.put(aggregateIdentifier, new AggregateEventPublisherImpl(aggregateIdentifier));
        }
        return this.aggregatePublishers.get(aggregateIdentifier);
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public RecordingCommandBus getCommandBus() {
        return this.commandBus;
    }

    private static class WrappingResourceInjector
    implements ResourceInjector {
        private final ResourceInjector customResourceInjector;
        private final TransienceValidatingResourceInjector defaultResourceInjector;

        public WrappingResourceInjector(ResourceInjector customResourceInjector, TransienceValidatingResourceInjector defaultResourceInjector) {
            this.customResourceInjector = customResourceInjector;
            this.defaultResourceInjector = defaultResourceInjector;
        }

        public void injectResources(Object saga) {
            this.defaultResourceInjector.injectResources(saga);
            this.customResourceInjector.injectResources(saga);
        }
    }

    private static class TransienceValidatingResourceInjector
    extends SimpleResourceInjector {
        private final List<Object> registeredResources;
        private final boolean transienceCheckEnabled;

        public TransienceValidatingResourceInjector(List<Object> registeredResources, boolean transienceCheckEnabled) {
            super(registeredResources);
            this.registeredResources = registeredResources;
            this.transienceCheckEnabled = transienceCheckEnabled;
        }

        public void injectResources(Object saga) {
            super.injectResources(saga);
            if (this.transienceCheckEnabled) {
                StreamSupport.stream(ReflectionUtils.fieldsOf(saga.getClass()).spliterator(), false).filter(f -> !Modifier.isTransient(f.getModifiers())).filter(f -> this.registeredResources.contains(ReflectionUtils.getFieldValue((Field)f, (Object)saga))).findFirst().ifPresent(field -> {
                    throw new AssertionError((Object)String.format("Field %s.%s is injected with a resource, but it doesn't have the 'transient' modifier.\nMark field as 'transient' or disable this check using:\nfixture.withTransienceCheckDisabled()", field.getDeclaringClass(), field.getName()));
                });
            }
        }
    }

    private static class MutableFieldFilter
    implements FieldFilter {
        private final List<FieldFilter> filters = new ArrayList<FieldFilter>();

        private MutableFieldFilter() {
        }

        @Override
        public boolean accept(Field field) {
            for (FieldFilter filter : this.filters) {
                if (filter.accept(field)) continue;
                return false;
            }
            return true;
        }

        public void add(FieldFilter fieldFilter) {
            this.filters.add(fieldFilter);
        }
    }

    private class AggregateEventPublisherImpl
    implements GivenAggregateEventPublisher,
    WhenAggregateEventPublisher {
        private final String aggregateIdentifier;
        private final String type;
        private int sequenceNumber = 0;

        public AggregateEventPublisherImpl(String aggregateIdentifier) {
            this.aggregateIdentifier = aggregateIdentifier;
            this.type = "Stub_" + aggregateIdentifier;
        }

        @Override
        public ContinuedGivenState published(Object ... events) {
            this.publish(events);
            return SagaTestFixture.this;
        }

        @Override
        public FixtureExecutionResult publishes(Object event) {
            this.publish(event);
            return SagaTestFixture.this.fixtureExecutionResult;
        }

        @Override
        public FixtureExecutionResult publishes(Object event, Map<String, ?> metaData) {
            EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event).andMetaData(metaData);
            this.publish(eventMessage);
            return SagaTestFixture.this.fixtureExecutionResult;
        }

        private void publish(Object ... events) {
            for (Object event : events) {
                EventMessage eventMessage = GenericEventMessage.asEventMessage((Object)event);
                SagaTestFixture.this.handleInSaga((EventMessage<?>)new GenericDomainEventMessage(this.type, this.aggregateIdentifier, (long)this.sequenceNumber++, eventMessage.getPayload(), (Map)eventMessage.getMetaData(), eventMessage.getIdentifier(), SagaTestFixture.this.currentTime()));
            }
        }
    }

    private static class ReturnResultFromStub<R>
    implements CommandGatewayFactory.InvocationHandler<R> {
        private final CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> dispatcher;
        private final Object stubGateway;

        public ReturnResultFromStub(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> dispatcher, Object stubGateway) {
            this.dispatcher = dispatcher;
            this.stubGateway = stubGateway;
        }

        public R invoke(Object proxy, Method invokedMethod, Object[] args) throws Exception {
            Future future = (Future)this.dispatcher.invoke(proxy, invokedMethod, args);
            if (this.stubGateway != null) {
                return (R)invokedMethod.invoke(this.stubGateway, args);
            }
            if (future.isDone()) {
                return (R)future.get();
            }
            return null;
        }
    }

    private static class StubAwareCommandGatewayFactory
    extends CommandGatewayFactory {
        private final Object stubImplementation;

        protected StubAwareCommandGatewayFactory(Builder builder) {
            super((CommandGatewayFactory.Builder)builder);
            this.stubImplementation = builder.stubImplementation;
        }

        public static Builder builder() {
            return new Builder();
        }

        protected <R> CommandGatewayFactory.InvocationHandler<R> wrapToWaitForResult(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> delegate) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> CommandGatewayFactory.InvocationHandler<R> wrapToReturnWithFixedTimeout(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> delegate, long timeout, TimeUnit timeUnit) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        protected <R> CommandGatewayFactory.InvocationHandler<R> wrapToReturnWithTimeoutInArguments(CommandGatewayFactory.InvocationHandler<CompletableFuture<R>> delegate, int timeoutIndex, int timeUnitIndex) {
            return new ReturnResultFromStub<R>(delegate, this.stubImplementation);
        }

        public static class Builder
        extends CommandGatewayFactory.Builder {
            private Object stubImplementation;

            public Builder commandBus(CommandBus commandBus) {
                super.commandBus(commandBus);
                return this;
            }

            private Builder stubImplementation(Object stubImplementation) {
                this.stubImplementation = stubImplementation;
                return this;
            }

            public StubAwareCommandGatewayFactory build() {
                return new StubAwareCommandGatewayFactory(this);
            }
        }
    }
}

