/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.server;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.test.server.AxonServerContainerUtils;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class AxonServerContainer
extends GenericContainer<AxonServerContainer> {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"axoniq/axonserver");
    private static final int AXON_SERVER_HTTP_PORT = 8024;
    private static final int AXON_SERVER_GRPC_PORT = 8124;
    private static final String WAIT_FOR_LOG_MESSAGE = ".*Started AxonServer.*";
    private static final String HEALTH_ENDPOINT = "/actuator/health";
    private static final String LICENCE_DEFAULT_LOCATION = "/axonserver/config/axoniq.license";
    private static final String CONFIGURATION_DEFAULT_LOCATION = "/axonserver/config/axonserver.properties";
    private static final String CLUSTER_TEMPLATE_DEFAULT_LOCATION = "/axonserver/cluster-template.yml";
    private static final String AXONIQ_LICENSE = "AXONIQ_LICENSE";
    private static final String AXONIQ_AXONSERVER_NAME = "AXONIQ_AXONSERVER_NAME";
    private static final String AXONIQ_AXONSERVER_INTERNAL_HOSTNAME = "AXONIQ_AXONSERVER_INTERNAL_HOSTNAME";
    private static final String AXONIQ_AXONSERVER_HOSTNAME = "AXONIQ_AXONSERVER_HOSTNAME";
    private static final String AXONIQ_AXONSERVER_DEVMODE_ENABLED = "AXONIQ_AXONSERVER_DEVMODE_ENABLED";
    private static final String AXON_SERVER_ADDRESS_TEMPLATE = "%s:%s";
    private String licensePath;
    private String configurationPath;
    private String clusterTemplatePath;
    private String axonServerName;
    private String axonServerInternalHostname;
    private String axonServerHostname;
    private boolean devMode;

    public AxonServerContainer() {
        this(DEFAULT_IMAGE_NAME);
    }

    public AxonServerContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public AxonServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        ((AxonServerContainer)((AxonServerContainer)((AxonServerContainer)this.withExposedPorts(new Integer[]{8024, 8124})).withEnv(AXONIQ_LICENSE, LICENCE_DEFAULT_LOCATION)).waitingFor((WaitStrategy)Wait.forLogMessage((String)WAIT_FOR_LOG_MESSAGE, (int)1))).waitingFor((WaitStrategy)Wait.forHttp((String)HEALTH_ENDPOINT).forPort(8024));
    }

    protected void configure() {
        this.optionallyCopyResourceToContainer(LICENCE_DEFAULT_LOCATION, this.licensePath);
        this.optionallyCopyResourceToContainer(CONFIGURATION_DEFAULT_LOCATION, this.configurationPath);
        this.optionallyCopyResourceToContainer(CLUSTER_TEMPLATE_DEFAULT_LOCATION, this.clusterTemplatePath);
        this.withOptionalEnv(AXONIQ_AXONSERVER_NAME, this.axonServerName);
        this.withOptionalEnv(AXONIQ_AXONSERVER_HOSTNAME, this.axonServerHostname);
        this.withOptionalEnv(AXONIQ_AXONSERVER_INTERNAL_HOSTNAME, this.axonServerInternalHostname);
        this.withEnv(AXONIQ_AXONSERVER_DEVMODE_ENABLED, String.valueOf(this.devMode));
    }

    protected void doStart() {
        super.doStart();
        try {
            AxonServerContainerUtils.initCluster(this.getHost(), this.getHttpPort(), this.isShouldBeReused());
        }
        catch (IOException e) {
            throw new ContainerLaunchException("Axon Server cluster initialization failed.", (Throwable)e);
        }
    }

    protected void optionallyCopyResourceToContainer(String pathNameInContainer, String resourceLocation) {
        Optional.ofNullable(resourceLocation).map(MountableFile::forClasspathResource).ifPresent(mountableFile -> {
            AxonServerContainer cfr_ignored_0 = (AxonServerContainer)this.withCopyFileToContainer((MountableFile)mountableFile, pathNameInContainer);
        });
    }

    protected void withOptionalEnv(String key, String value) {
        Optional.ofNullable(value).ifPresent(v -> {
            AxonServerContainer cfr_ignored_0 = (AxonServerContainer)this.withEnv(key, value);
        });
    }

    public AxonServerContainer withLicense(String licensePath) {
        this.licensePath = licensePath;
        return (AxonServerContainer)this.self();
    }

    public AxonServerContainer withConfiguration(String configurationPath) {
        this.configurationPath = configurationPath;
        return (AxonServerContainer)this.self();
    }

    public AxonServerContainer withClusterTemplate(String clusterTemplatePath) {
        this.clusterTemplatePath = clusterTemplatePath;
        return (AxonServerContainer)this.self();
    }

    public AxonServerContainer withAxonServerName(String axonServerName) {
        this.axonServerName = axonServerName;
        return (AxonServerContainer)this.self();
    }

    public AxonServerContainer withAxonServerInternalHostname(String axonServerInternalHostname) {
        this.axonServerInternalHostname = axonServerInternalHostname;
        return (AxonServerContainer)this.self();
    }

    public AxonServerContainer withAxonServerHostname(String axonServerHostname) {
        this.axonServerHostname = axonServerHostname;
        return (AxonServerContainer)this.self();
    }

    public AxonServerContainer withDevMode(boolean devMode) {
        this.devMode = devMode;
        return (AxonServerContainer)this.self();
    }

    public Integer getHttpPort() {
        return this.getMappedPort(8024);
    }

    public Integer getGrpcPort() {
        return this.getMappedPort(8124);
    }

    public String getAxonServerAddress() {
        return String.format(AXON_SERVER_ADDRESS_TEMPLATE, this.getHost(), this.getMappedPort(8124));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AxonServerContainer that = (AxonServerContainer)((Object)o);
        return Objects.equals(this.licensePath, that.licensePath) && Objects.equals(this.configurationPath, that.configurationPath) && Objects.equals(this.clusterTemplatePath, that.clusterTemplatePath) && Objects.equals(this.axonServerName, that.axonServerName) && Objects.equals(this.axonServerInternalHostname, that.axonServerInternalHostname) && Objects.equals(this.axonServerHostname, that.axonServerHostname) && Objects.equals(this.devMode, that.devMode);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.licensePath, this.configurationPath, this.clusterTemplatePath, this.axonServerName, this.axonServerInternalHostname, this.axonServerHostname, this.devMode);
    }

    public String toString() {
        return "AxonServerContainer{licensePath='" + this.licensePath + '\'' + ", configurationPath='" + this.configurationPath + '\'' + ", clusterTemplatePath='" + this.clusterTemplatePath + '\'' + ", axonServerName='" + this.axonServerName + '\'' + ", axonServerInternalHostname='" + this.axonServerInternalHostname + '\'' + ", axonServerHostname='" + this.axonServerHostname + '\'' + ", devMode='" + this.devMode + '\'' + '}';
    }
}

