/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.deadline;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.common.Registration;
import org.axonframework.deadline.DeadlineManager;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.deadline.DeadlineConsumer;
import org.axonframework.test.deadline.ScheduledDeadlineInfo;

public class StubDeadlineManager
implements DeadlineManager {
    private final NavigableSet<ScheduledDeadlineInfo> schedules = new TreeSet<ScheduledDeadlineInfo>();
    private final List<ScheduledDeadlineInfo> deadlinesMet = new CopyOnWriteArrayList<ScheduledDeadlineInfo>();
    private final AtomicInteger counter = new AtomicInteger(0);
    private final List<MessageDispatchInterceptor<? super DeadlineMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final List<MessageHandlerInterceptor<? super DeadlineMessage<?>>> handlerInterceptors = new CopyOnWriteArrayList();
    private Instant currentDateTime;

    public StubDeadlineManager() {
        this(ZonedDateTime.now());
    }

    public StubDeadlineManager(TemporalAccessor currentDateTime) {
        this.currentDateTime = Instant.from(currentDateTime);
    }

    public void initializeAt(TemporalAccessor currentDateTime) throws IllegalStateException {
        if (!this.schedules.isEmpty()) {
            throw new IllegalStateException("Initializing the deadline manager at a specific dateTime must take place before any deadlines are scheduled");
        }
        this.currentDateTime = Instant.from(currentDateTime);
    }

    public String schedule(Instant triggerDateTime, String deadlineName, Object payloadOrMessage, ScopeDescriptor deadlineScope) {
        DeadlineMessage deadlineMessage = this.processDispatchInterceptors(GenericDeadlineMessage.asDeadlineMessage((String)deadlineName, (Object)payloadOrMessage));
        GenericDeadlineMessage scheduledMessage = new GenericDeadlineMessage(deadlineName, deadlineMessage, () -> triggerDateTime);
        this.schedules.add(new ScheduledDeadlineInfo(triggerDateTime, deadlineName, scheduledMessage.getIdentifier(), this.counter.getAndIncrement(), (DeadlineMessage<?>)scheduledMessage, deadlineScope));
        return scheduledMessage.getIdentifier();
    }

    public String schedule(Duration triggerDuration, String deadlineName, Object payloadOrMessage, ScopeDescriptor deadlineScope) {
        return this.schedule(this.currentDateTime.plus(triggerDuration), deadlineName, payloadOrMessage, deadlineScope);
    }

    public void cancelSchedule(String deadlineName, String scheduleId) {
        this.schedules.removeIf(scheduledDeadline -> scheduledDeadline.getDeadlineName().equals(deadlineName) && scheduledDeadline.getScheduleId().equals(scheduleId));
    }

    public void cancelAll(String deadlineName) {
        this.schedules.removeIf(scheduledDeadline -> scheduledDeadline.getDeadlineName().equals(deadlineName));
    }

    public List<ScheduledDeadlineInfo> getScheduledDeadlines() {
        return new ArrayList<ScheduledDeadlineInfo>(this.schedules);
    }

    public List<ScheduledDeadlineInfo> getDeadlinesMet() {
        return Collections.unmodifiableList(this.deadlinesMet);
    }

    public Instant getCurrentDateTime() {
        return this.currentDateTime;
    }

    public ScheduledDeadlineInfo advanceToNextTrigger() {
        ScheduledDeadlineInfo nextItem = this.schedules.pollFirst();
        if (nextItem == null) {
            throw new NoSuchElementException("There are no scheduled deadlines");
        }
        if (nextItem.getScheduleTime().isAfter(this.currentDateTime)) {
            this.currentDateTime = nextItem.getScheduleTime();
        }
        this.deadlinesMet.add(nextItem);
        return nextItem;
    }

    public void advanceTimeTo(Instant newDateTime, DeadlineConsumer deadlineConsumer) {
        while (!this.schedules.isEmpty() && !((ScheduledDeadlineInfo)this.schedules.first()).getScheduleTime().isAfter(newDateTime)) {
            ScheduledDeadlineInfo scheduledDeadlineInfo = this.advanceToNextTrigger();
            DeadlineMessage<?> consumedMessage = this.consumeDeadline(deadlineConsumer, scheduledDeadlineInfo);
            this.deadlinesMet.remove(scheduledDeadlineInfo);
            this.deadlinesMet.add(scheduledDeadlineInfo.recreateWithNewMessage(consumedMessage));
        }
        if (newDateTime.isAfter(this.currentDateTime)) {
            this.currentDateTime = newDateTime;
        }
    }

    public void advanceTimeBy(Duration duration, DeadlineConsumer deadlineConsumer) {
        this.advanceTimeTo(this.currentDateTime.plus(duration), deadlineConsumer);
    }

    public Registration registerDispatchInterceptor(MessageDispatchInterceptor<? super DeadlineMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    public Registration registerHandlerInterceptor(MessageHandlerInterceptor<? super DeadlineMessage<?>> handlerInterceptor) {
        this.handlerInterceptors.add(handlerInterceptor);
        return () -> this.handlerInterceptors.remove(handlerInterceptor);
    }

    private <T> DeadlineMessage<T> processDispatchInterceptors(DeadlineMessage<T> message) {
        DeadlineMessage intercepted = message;
        for (MessageDispatchInterceptor<? super DeadlineMessage<?>> messageDispatchInterceptor : this.dispatchInterceptors) {
            intercepted = (DeadlineMessage)messageDispatchInterceptor.handle((Message)intercepted);
        }
        return intercepted;
    }

    private DeadlineMessage<?> consumeDeadline(DeadlineConsumer deadlineConsumer, ScheduledDeadlineInfo scheduledDeadlineInfo) {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(scheduledDeadlineInfo.deadlineMessage());
        DefaultInterceptorChain chain = new DefaultInterceptorChain((UnitOfWork)uow, this.handlerInterceptors, deadlineMessage -> {
            deadlineConsumer.consume(scheduledDeadlineInfo.getDeadlineScope(), (DeadlineMessage<?>)deadlineMessage);
            return deadlineMessage;
        });
        ResultMessage resultMessage = uow.executeWithResult(() -> ((InterceptorChain)chain).proceed());
        if (resultMessage.isExceptional()) {
            Throwable e = resultMessage.exceptionResult();
            throw new FixtureExecutionException("Exception occurred while handling the deadline", e);
        }
        return (DeadlineMessage)resultMessage.getPayload();
    }
}

