/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.deadline;

import java.time.Instant;
import java.util.Objects;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.messaging.ScopeDescriptor;

public class ScheduledDeadlineInfo
implements Comparable<ScheduledDeadlineInfo> {
    private final Instant scheduleTime;
    private final String deadlineName;
    private final String scheduleId;
    private final int counter;
    private final DeadlineMessage<?> deadlineMessage;
    private final ScopeDescriptor deadlineScope;

    public ScheduledDeadlineInfo(Instant scheduleTime, String deadlineName, String scheduleId, int counter, DeadlineMessage<?> deadlineMessage, ScopeDescriptor deadlineScope) {
        this.scheduleTime = scheduleTime;
        this.deadlineName = deadlineName;
        this.scheduleId = scheduleId;
        this.counter = counter;
        this.deadlineMessage = deadlineMessage;
        this.deadlineScope = deadlineScope;
    }

    public Instant getScheduleTime() {
        return this.scheduleTime;
    }

    public String getDeadlineName() {
        return this.deadlineName;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public int getCounter() {
        return this.counter;
    }

    public ScopeDescriptor getDeadlineScope() {
        return this.deadlineScope;
    }

    public DeadlineMessage<?> deadlineMessage() {
        return this.deadlineMessage;
    }

    @Override
    public int compareTo(ScheduledDeadlineInfo other) {
        if (this.scheduleTime.equals(other.scheduleTime)) {
            return Integer.compare(this.counter, other.counter);
        }
        return this.scheduleTime.compareTo(other.scheduleTime);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledDeadlineInfo that = (ScheduledDeadlineInfo)o;
        return this.counter == that.counter && Objects.equals(this.scheduleTime, that.scheduleTime);
    }

    public int hashCode() {
        return Objects.hash(this.scheduleTime, this.counter);
    }
}

