/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.aggregate;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.model.Aggregate;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.aggregate.Reporter;
import org.axonframework.test.aggregate.ResultValidator;
import org.axonframework.test.deadline.DeadlineManagerValidator;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.MapEntryMatcher;
import org.axonframework.test.matchers.Matchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class ResultValidatorImpl<T>
implements ResultValidator<T>,
CommandCallback<Object, Object> {
    private final List<EventMessage<?>> publishedEvents;
    private final Reporter reporter = new Reporter();
    private final FieldFilter fieldFilter;
    private final Supplier<Aggregate<T>> state;
    private final DeadlineManagerValidator deadlineManagerValidator;
    private Object actualReturnValue;
    private Throwable actualException;

    public ResultValidatorImpl(List<EventMessage<?>> publishedEvents, FieldFilter fieldFilter, Supplier<Aggregate<T>> aggregateState, StubDeadlineManager stubDeadlineManager) {
        this.publishedEvents = publishedEvents;
        this.fieldFilter = fieldFilter;
        this.state = aggregateState;
        this.deadlineManagerValidator = new DeadlineManagerValidator(stubDeadlineManager, fieldFilter);
    }

    @Override
    public ResultValidator<T> expectEvents(Object ... expectedEvents) {
        if (expectedEvents.length != this.publishedEvents.size()) {
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<EventMessage<?>> iterator = this.publishedEvents.iterator();
        for (Object expectedEvent : expectedEvents) {
            EventMessage<?> actualEvent = iterator.next();
            if (this.verifyEventEquality(expectedEvent, actualEvent.getPayload())) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectEvents(EventMessage ... expectedEvents) {
        this.expectEvents((Object[])expectedEvents);
        Iterator<EventMessage<?>> iterator = this.publishedEvents.iterator();
        for (EventMessage expectedEvent : expectedEvents) {
            EventMessage<?> actualEvent = iterator.next();
            if (this.verifyMetaDataEquality(expectedEvent.getPayloadType(), (Map<String, Object>)expectedEvent.getMetaData(), (Map<String, Object>)actualEvent.getMetaData())) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectEventsMatching(Matcher<? extends List<? super EventMessage<?>>> matcher) {
        if (!matcher.matches(this.publishedEvents)) {
            this.reporter.reportWrongEvent(this.publishedEvents, this.descriptionOf(matcher), this.actualException);
        }
        return this;
    }

    private StringDescription descriptionOf(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        return description;
    }

    @Override
    public ResultValidator<T> expectSuccessfulHandlerExecution() {
        return this.expectReturnValueMatching(CoreMatchers.anything());
    }

    @Override
    public ResultValidator<T> expectState(Consumer<T> aggregateStateValidator) {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        try {
            this.state.get().execute(aggregateStateValidator);
        }
        finally {
            uow.rollback();
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineMatching(Duration duration, Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertScheduledDeadlineMatching(duration, matcher);
        return this;
    }

    @Override
    public ResultValidator<T> expectScheduledDeadline(Duration duration, Object deadline) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.messageWithPayload(Matchers.equalTo(deadline, this.fieldFilter)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineOfType(Duration duration, Class<?> deadlineType) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineMatching(Instant scheduledTime, Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertScheduledDeadlineMatching(scheduledTime, matcher);
        return this;
    }

    @Override
    public ResultValidator<T> expectScheduledDeadline(Instant scheduledTime, Object deadline) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(Matchers.equalTo(deadline, this.fieldFilter)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineOfType(Instant scheduledTime, Class<?> deadlineType) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlines() {
        this.deadlineManagerValidator.assertNoScheduledDeadlines();
        return this;
    }

    @Override
    public ResultValidator<T> expectDeadlinesMetMatching(Matcher<? extends List<? super DeadlineMessage<?>>> matcher) {
        this.deadlineManagerValidator.assertDeadlinesMetMatching(matcher);
        return this;
    }

    @Override
    public ResultValidator<T> expectDeadlinesMet(Object ... expected) {
        this.deadlineManagerValidator.assertDeadlinesMet(expected);
        return this;
    }

    @Override
    public ResultValidator<T> expectReturnValue(Object expectedReturnValue) {
        if (expectedReturnValue == null) {
            return this.expectReturnValueMatching(CoreMatchers.nullValue());
        }
        return this.expectReturnValueMatching(CoreMatchers.equalTo((Object)expectedReturnValue));
    }

    @Override
    public ResultValidator<T> expectReturnValueMatching(Matcher<?> matcher) {
        if (matcher == null) {
            return this.expectReturnValueMatching(CoreMatchers.nullValue());
        }
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)description);
        } else if (!matcher.matches(this.actualReturnValue)) {
            this.reporter.reportWrongResult(this.actualReturnValue, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectExceptionMessage(Matcher<?> exceptionMessageMatcher) {
        StringDescription emptyMatcherDescription = new StringDescription((Appendable)new StringBuilder("Given exception message matcher is null!"));
        if (exceptionMessageMatcher == null) {
            this.reporter.reportWrongExceptionMessage(this.actualException, (Description)emptyMatcherDescription);
            return this;
        }
        StringDescription description = new StringDescription();
        exceptionMessageMatcher.describeTo((Description)description);
        if (this.actualException != null && !exceptionMessageMatcher.matches((Object)this.actualException.getMessage())) {
            this.reporter.reportWrongExceptionMessage(this.actualException, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectExceptionMessage(String exceptionMessage) {
        return this.expectExceptionMessage(CoreMatchers.equalTo((Object)exceptionMessage));
    }

    @Override
    public ResultValidator<T> expectException(Class<? extends Throwable> expectedException) {
        return this.expectException(CoreMatchers.instanceOf(expectedException));
    }

    @Override
    public ResultValidator<T> expectException(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue, (Description)description);
        }
        if (!matcher.matches((Object)this.actualException)) {
            this.reporter.reportWrongException(this.actualException, (Description)description);
        }
        return this;
    }

    public void onSuccess(CommandMessage<?> commandMessage, Object result) {
        this.actualReturnValue = result;
    }

    public void onFailure(CommandMessage<?> commandMessage, Throwable cause) {
        this.actualException = cause;
    }

    public void assertValidRecording() {
        if (this.actualException instanceof Error) {
            throw (Error)this.actualException;
        }
        if (this.actualException instanceof FixtureExecutionException) {
            throw (FixtureExecutionException)((Object)this.actualException);
        }
    }

    private boolean verifyEventEquality(Object expectedEvent, Object actualEvent) {
        if (!expectedEvent.getClass().equals(actualEvent.getClass())) {
            return false;
        }
        EqualFieldsMatcher<Object> matcher = new EqualFieldsMatcher<Object>(expectedEvent, this.fieldFilter);
        if (!matcher.matches(actualEvent)) {
            this.reporter.reportDifferentEventContents(expectedEvent.getClass(), matcher.getFailedField(), matcher.getFailedFieldActualValue(), matcher.getFailedFieldExpectedValue());
        }
        return true;
    }

    private boolean verifyMetaDataEquality(Class<?> eventType, Map<String, Object> expectedMetaData, Map<String, Object> actualMetaData) {
        MapEntryMatcher matcher = new MapEntryMatcher(expectedMetaData);
        if (!matcher.matches(actualMetaData)) {
            this.reporter.reportDifferentMetaData(eventType, matcher.getMissingEntries(), matcher.getAdditionalEntries());
        }
        return true;
    }
}

